/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aika.AbstractNode;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.ReadWriteLock;
import org.aika.Utils;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.corpus.SearchNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INeuron
extends AbstractNode<Neuron>
implements Comparable<INeuron> {
    private static final Logger log = LoggerFactory.getLogger(INeuron.class);
    public static final double LEARN_RATE = 0.01;
    public static final double WEIGHT_TOLERANCE = 0.001;
    public static final double TOLERANCE = 1.0E-6;
    public static final int MAX_SELF_REFERENCING_DEPTH = 5;
    public String label;
    public volatile double bias;
    public volatile double negDirSum;
    public volatile double negRecSum;
    public volatile double posRecSum;
    public volatile double maxRecurrentSum = 0.0;
    public TreeMap<Synapse, Synapse> inputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
    public TreeMap<Synapse.Key, Provider<InputNode>> outputNodes = new TreeMap();
    public Provider<OrNode> node;
    public boolean isBlocked;
    public boolean noTraining;
    public volatile double activationSum;
    public volatile int numberOfActivations;
    public ReadWriteLock lock = new ReadWriteLock();

    private INeuron() {
    }

    public INeuron(Model m) {
        this(m, null);
    }

    public INeuron(Model m, String label) {
        this(m, label, false, false);
    }

    public INeuron(Model m, String label, boolean isBlocked, boolean noTraining) {
        this.label = label;
        this.isBlocked = isBlocked;
        this.noTraining = noTraining;
        this.provider = new Neuron(m, this);
        OrNode node = new OrNode(m);
        node.neuron = (Neuron)this.provider;
        this.node = node.provider;
        ((Neuron)this.provider).setModified();
    }

    public Activation addInput(Document doc, int begin, int end, Integer rid, InterprNode o, double value) {
        if (value <= 0.0) {
            return null;
        }
        Node.addActivationAndPropagate(doc, new NodeActivation.Key<Node>(this.node.get(), new Range(begin, end), rid, o), Collections.emptySet());
        doc.propagate();
        Activation act = (Activation)NodeActivation.get(doc, (Node)this.node.get(), rid, new Range(begin, end), Range.Operator.EQUALS, Range.Operator.EQUALS, o, InterprNode.Relation.EQUALS);
        Activation.State s = new Activation.State(value, value, value, 0, NormWeight.ZERO_WEIGHT, NormWeight.ZERO_WEIGHT);
        act.rounds.set(0, s);
        act.finalState = s;
        act.upperBound = value;
        act.isInput = true;
        doc.inputNeuronActivations.add(act);
        doc.finallyActivatedNeurons.add((INeuron)((OrNode)act.key.n).neuron.get());
        doc.ubQueue.add(act);
        doc.propagate();
        return act;
    }

    public void removeInput(Document doc, int begin, int end, Integer rid, InterprNode o) {
        Range r = new Range(begin, end);
        Object act = NodeActivation.get(doc, (Node)this.node.get(), rid, r, Range.Operator.EQUALS, Range.Operator.EQUALS, o, InterprNode.Relation.EQUALS);
        Node.removeActivationAndPropagate(doc, act, Collections.emptySet());
        doc.propagate();
        doc.inputNeuronActivations.remove(act);
    }

    public double avgActivation() {
        return (double)this.numberOfActivations > 0.0 ? this.activationSum / (double)this.numberOfActivations : 1.0;
    }

    public void publish(int threadId) {
    }

    public void unpublish(int threadId) {
    }

    public void remove(int threadId) {
        this.unpublish(threadId);
        for (Synapse s : this.inputSynapses.values()) {
            INeuron in = (INeuron)s.input.get();
            in.lock.acquireWriteLock(threadId);
            ((Neuron)in.provider).inMemoryOutputSynapses.remove(s);
            in.lock.releaseWriteLock();
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            INeuron out = (INeuron)s.output.get();
            out.lock.acquireWriteLock(threadId);
            out.inputSynapses.remove(s);
            out.lock.releaseWriteLock();
        }
    }

    public void propagateAddedActivation(Document doc, Activation act) {
        doc.ubQueue.add(act);
    }

    public void propagateRemovedActivation(Document doc, NodeActivation act) {
        for (Provider<InputNode> out : this.outputNodes.values()) {
            out.get().removeActivation(doc, act);
        }
    }

    public void computeBounds(Activation act) {
        double ub = this.bias + this.posRecSum - (this.negDirSum + this.negRecSum);
        double lb = this.bias + this.posRecSum - (this.negDirSum + this.negRecSum);
        for (Activation.SynapseActivation sa : act.neuronInputs) {
            Synapse s = sa.s;
            Activation iAct = sa.input;
            if (iAct == act || iAct.isRemoved) continue;
            if (s.key.isNeg) {
                if (!INeuron.checkSelfReferencing(act.key.o, iAct.key.o, null, 0) && act.key.o.contains(iAct.key.o, true)) {
                    ub += iAct.lowerBound * (double)s.w;
                }
                lb += (double)s.w;
                continue;
            }
            ub += iAct.upperBound * (double)s.w;
            lb += iAct.lowerBound * (double)s.w;
        }
        act.upperBound = INeuron.transferFunction(ub);
        act.lowerBound = INeuron.transferFunction(lb);
    }

    public Activation.State computeWeight(int round, Activation act, SearchNode sn, Document doc) {
        InterprNode o = act.key.o;
        double st = this.bias - (this.negDirSum + this.negRecSum);
        double[][] sum = new double[][]{{st, st, st}, {0.0, 0.0, 0.0}};
        int fired = -1;
        for (Activation.SynapseActivation sa : this.getInputSAs(act, round)) {
            Synapse s = sa.s;
            Activation iAct = sa.input;
            InterprNode io = iAct.key.o;
            if (iAct == act || iAct.isRemoved) continue;
            Activation.State is = Activation.State.ZERO;
            if (s.key.isRecurrent) {
                if (!s.key.isNeg || !INeuron.checkSelfReferencing(o, io, sn, 0)) {
                    is = round == 0 ? this.getInitialState(sn.getCoverage(io)) : iAct.rounds.get(round - 1);
                }
            } else {
                is = iAct.rounds.get(round);
            }
            int t = s.key.isRecurrent ? 1 : 0;
            double[] dArray = sum[t];
            dArray[0] = dArray[0] + is.value * (double)s.w;
            double[] dArray2 = sum[t];
            dArray2[1] = dArray2[1] + (s.key.isNeg ? is.lb : is.ub) * (double)s.w;
            double[] dArray3 = sum[t];
            dArray3[2] = dArray3[2] + (s.key.isNeg ? is.ub : is.lb) * (double)s.w;
            if (s.key.isRecurrent || s.key.isNeg || !(sum[0][0] + sum[1][0] >= 0.0) || fired >= 0) continue;
            fired = iAct.rounds.get((int)round).fired + 1;
        }
        double drSum = sum[0][0] + sum[1][0];
        double drSumUB = sum[0][1] + sum[1][1];
        double drSumLB = sum[0][2] + sum[1][2];
        SearchNode.Coverage c = sn.getCoverage(act.key.o);
        NormWeight newWeight = NormWeight.create(c == SearchNode.Coverage.SELECTED ? (sum[0][0] + this.negRecSum < 0.0 ? Math.max(0.0, drSum) : sum[1][0] - this.negRecSum) : 0.0, sum[0][0] + this.negRecSum < 0.0 ? Math.max(0.0, sum[0][0] + this.negRecSum + this.maxRecurrentSum) : this.maxRecurrentSum);
        NormWeight newWeightUB = NormWeight.create(c == SearchNode.Coverage.SELECTED || c == SearchNode.Coverage.UNKNOWN ? (sum[0][1] + this.negRecSum < 0.0 ? Math.max(0.0, drSumUB) : sum[1][1] - this.negRecSum) : 0.0, sum[0][2] + this.negRecSum < 0.0 ? Math.max(0.0, sum[0][2] + this.negRecSum + this.maxRecurrentSum) : this.maxRecurrentSum);
        if (doc.debugActId == act.id && doc.debugActWeight <= newWeight.w) {
            this.storeDebugOutput(doc, act, newWeight, drSum, round);
        }
        return new Activation.State(c == SearchNode.Coverage.SELECTED ? INeuron.transferFunction(drSum) : 0.0, c == SearchNode.Coverage.SELECTED || c == SearchNode.Coverage.UNKNOWN ? INeuron.transferFunction(drSumUB) : 0.0, c == SearchNode.Coverage.SELECTED ? INeuron.transferFunction(drSumLB) : 0.0, c == SearchNode.Coverage.SELECTED ? fired : -1, newWeight, newWeightUB);
    }

    private Activation.State getInitialState(SearchNode.Coverage c) {
        return new Activation.State(c == SearchNode.Coverage.SELECTED ? 1.0 : 0.0, c == SearchNode.Coverage.SELECTED || c == SearchNode.Coverage.UNKNOWN ? 1.0 : 0.0, c == SearchNode.Coverage.SELECTED ? 1.0 : 0.0, 0, NormWeight.ZERO_WEIGHT, NormWeight.ZERO_WEIGHT);
    }

    private List<Activation.SynapseActivation> getInputSAs(Activation act, int round) {
        ArrayList<Activation.SynapseActivation> tmp = new ArrayList<Activation.SynapseActivation>();
        Synapse lastSynapse = null;
        Activation.SynapseActivation maxSA = null;
        for (Activation.SynapseActivation sa : act.neuronInputs) {
            block7: {
                block6: {
                    if (lastSynapse != null && lastSynapse != sa.s) {
                        tmp.add(maxSA);
                        maxSA = null;
                    }
                    if (maxSA == null) break block6;
                    double d = maxSA.input.rounds.get((int)(sa.s.key.isRecurrent ? round - 1 : round)).value;
                    Activation.Rounds rounds = sa.input.rounds;
                    int n = sa.s.key.isRecurrent ? round - 1 : round;
                    if (!(d < rounds.get((int)n).value)) break block7;
                }
                maxSA = sa;
            }
            lastSynapse = sa.s;
        }
        if (maxSA != null) {
            tmp.add(maxSA);
        }
        return tmp;
    }

    private void storeDebugOutput(Document doc, Activation act, NormWeight nw, double sum, int round) {
        StringBuilder sb = new StringBuilder();
        sb.append("Activation ID: " + doc.debugActId + "\n");
        sb.append("Neuron: " + this.label + "\n");
        sb.append("Sum: " + sum + "\n");
        sb.append("Bias: " + this.bias + "\n");
        sb.append("Round: " + round + "\n");
        sb.append("Positive Recurrent Sum: " + this.posRecSum + "\n");
        sb.append("Negative Recurrent Sum: " + this.negRecSum + "\n");
        sb.append("Negative Direct Sum: " + this.negDirSum + "\n");
        sb.append("Inputs:\n");
        for (Activation.SynapseActivation sa : this.getInputSAs(act, round)) {
            String actValue = "";
            if (sa.s.key.isRecurrent) {
                if (round > 0) {
                    actValue = "" + sa.input.rounds.get(round - 1);
                }
            } else {
                actValue = "" + sa.input.rounds.get(round);
            }
            sb.append("    " + ((INeuron)((OrNode)sa.input.key.n).neuron.get()).label + "  SynWeight: " + sa.s.w + "  ActValue: " + actValue);
            sb.append("\n");
        }
        sb.append("Weight: " + nw.w + "\n");
        sb.append("Norm: " + nw.n + "\n");
        sb.append("\n");
        doc.debugOutput = sb.toString();
    }

    public void computeErrorSignal(Document doc, Activation act) {
        act.errorSignal = act.initialErrorSignal;
        for (Activation.SynapseActivation sa : act.neuronOutputs) {
            Synapse s = sa.s;
            Activation oAct = sa.output;
            act.errorSignal += (double)s.w * oAct.errorSignal * (1.0 - act.finalState.value);
        }
        for (Activation.SynapseActivation sa : act.neuronInputs) {
            doc.bQueue.add(sa.input);
        }
    }

    public void train(Document doc, Activation act) {
        if (Math.abs(act.errorSignal) < 1.0E-6) {
            return;
        }
        long v = NodeActivation.visitedCounter++;
        Range targetRange = null;
        if (act.key.r != null) {
            int s = act.key.r.end - act.key.r.begin;
            targetRange = new Range(Math.max(0, act.key.r.begin - s / 2), Math.min(doc.length(), act.key.r.end + s / 2));
        }
        ArrayList<Activation> inputActs = new ArrayList<Activation>();
        for (INeuron n : doc.finallyActivatedNeurons) {
            for (Activation iAct : n.getFinalActivations(doc)) {
                if (!Range.overlaps(iAct.key.r, targetRange)) continue;
                inputActs.add(iAct);
            }
        }
        if (Document.TRAIN_DEBUG_OUTPUT) {
            log.info("Debug discover:");
            log.info("Old Synapses:");
            for (Synapse s : this.inputSynapses.values()) {
                log.info("S:" + s.input + " RID:" + s.key.relativeRid + " W:" + s.w);
            }
            log.info("");
        }
        for (Activation.SynapseActivation sa : act.neuronInputs) {
            inputActs.add(sa.input);
        }
        for (Activation iAct : inputActs) {
            Integer rid = Utils.nullSafeSub(iAct.key.rid, false, act.key.rid, false);
            this.train(doc, iAct, rid, 0.01 * act.errorSignal, v);
        }
        if (Document.TRAIN_DEBUG_OUTPUT) {
            log.info("");
        }
        Node.adjust(doc.m, doc.threadId, this, act.errorSignal > 0.0 ? 1 : -1, this.inputSynapses.values());
    }

    public void train(Document doc, Activation iAct, Integer rid, double x, long v) {
        if (iAct.visitedNeuronTrain == v) {
            return;
        }
        iAct.visitedNeuronTrain = v;
        INeuron n = (INeuron)((OrNode)iAct.key.n).neuron.get();
        double deltaW = x * iAct.finalState.value;
    }

    private static boolean checkSelfReferencing(InterprNode nx, InterprNode ny, SearchNode en, int depth) {
        if (nx == ny && (en == null || en.isCovered(ny.markedSelected))) {
            return true;
        }
        if (depth > 5) {
            return false;
        }
        if (ny.orInterprNodes != null) {
            for (InterprNode n : ny.orInterprNodes.values()) {
                if (!INeuron.checkSelfReferencing(nx, n, en, depth + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public static double transferFunction(double x) {
        return x > 0.0 ? 2.0 * INeuron.sigmoid(x) - 1.0 : 0.0;
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.pow(Math.E, -x));
    }

    public void count(Document doc) {
        Node.ThreadState th = this.node.get().getThreadState(doc.threadId, false);
        if (th == null) {
            return;
        }
        for (Activation act : th.activations.values()) {
            if (act.finalState == null || !(act.finalState.value > 0.0)) continue;
            this.activationSum += act.finalState.value;
            ++this.numberOfActivations;
        }
    }

    public void linkNeuronRelations(Document doc, Activation act) {
        int v = doc.visitedCounter++;
        this.lock.acquireReadLock();
        this.linkNeuronActs(doc, act, v, 0);
        this.linkNeuronActs(doc, act, v, 1);
        this.lock.releaseReadLock();
    }

    private void linkNeuronActs(Document doc, Activation act, int v, int dir) {
        ArrayList<Activation> recNegTmp = new ArrayList<Activation>();
        TreeMap<Synapse, Synapse> syns = dir == 0 ? ((Neuron)this.provider).inMemoryInputSynapses : ((Neuron)this.provider).inMemoryOutputSynapses;
        for (Synapse s : INeuron.getActiveSynapses(doc, dir, syns)) {
            Neuron p = dir == 0 ? s.input : s.output;
            if (p.isSuspended()) continue;
            INeuron an = (INeuron)p.get();
            OrNode n = an.node.get();
            Node.ThreadState th = n.getThreadState(doc.threadId, false);
            if (th == null || th.activations.isEmpty()) continue;
            INeuron.linkActSyn(n, doc, act, dir, recNegTmp, s);
        }
        for (Activation rAct : recNegTmp) {
            Activation oAct = dir == 0 ? act : rAct;
            Activation iAct = dir == 0 ? rAct : act;
            INeuron.markConflicts(iAct, oAct, v);
            INeuron.addConflict(doc, oAct.key.o, iAct.key.o, iAct, Collections.singleton(act), v);
        }
    }

    private static void linkActSyn(OrNode n, Document doc, Activation act, int dir, ArrayList<Activation> recNegTmp, Synapse s) {
        Integer rid = dir == 0 ? (s.key.absoluteRid != null ? s.key.absoluteRid : Utils.nullSafeAdd(act.key.rid, false, s.key.relativeRid, false)) : Utils.nullSafeSub(act.key.rid, false, s.key.relativeRid, false);
        Range.Operator begin = INeuron.replaceFirstAndLast(s.key.startRangeMatch);
        Range.Operator end = INeuron.replaceFirstAndLast(s.key.endRangeMatch);
        Range r = act.key.r;
        if (dir == 0) {
            begin = Range.Operator.invert(s.key.startRangeMapping == Range.Mapping.START ? begin : (s.key.endRangeMapping == Range.Mapping.START ? end : Range.Operator.NONE));
            end = Range.Operator.invert(s.key.endRangeMapping == Range.Mapping.END ? end : (s.key.startRangeMapping == Range.Mapping.END ? begin : Range.Operator.NONE));
            if (s.key.startRangeMapping != Range.Mapping.START || s.key.endRangeMapping != Range.Mapping.END) {
                r = new Range(s.key.endRangeMapping == Range.Mapping.START ? r.end : (s.key.startRangeMapping == Range.Mapping.START ? r.begin : null), s.key.startRangeMapping == Range.Mapping.END ? r.begin : (s.key.endRangeMapping == Range.Mapping.END ? r.end : null));
            }
        } else if (s.key.startRangeMapping != Range.Mapping.START || s.key.endRangeMapping != Range.Mapping.END) {
            r = new Range(s.key.startRangeMapping == Range.Mapping.END ? r.end : (s.key.startRangeMapping == Range.Mapping.START ? r.begin : null), s.key.endRangeMapping == Range.Mapping.START ? r.begin : (s.key.endRangeMapping == Range.Mapping.END ? r.end : null));
        }
        Stream tmp = NodeActivation.select(doc, n, rid, r, begin, end, null, null);
        int d = dir;
        tmp.forEach(rAct -> {
            Activation oAct = d == 0 ? act : rAct;
            Activation iAct = d == 0 ? rAct : act;
            Activation.SynapseActivation sa = new Activation.SynapseActivation(s, iAct, oAct);
            iAct.addSynapseActivation(0, sa);
            oAct.addSynapseActivation(1, sa);
            if (synapse.key.isNeg && synapse.key.isRecurrent) {
                recNegTmp.add((Activation)rAct);
            }
        });
    }

    private static Collection<Synapse> getActiveSynapses(Document doc, int dir, TreeMap<Synapse, Synapse> syns) {
        if (syns.size() < 10 || doc.activatedNeurons.size() * 20 > syns.size()) {
            return syns.values();
        }
        ArrayList<Synapse> newSyns = new ArrayList<Synapse>();
        Synapse lk = new Synapse(null, Synapse.Key.MIN_KEY);
        Synapse uk = new Synapse(null, Synapse.Key.MAX_KEY);
        for (INeuron n : doc.activatedNeurons) {
            if (dir == 0) {
                lk.input = (Neuron)n.provider;
                uk.input = (Neuron)n.provider;
            } else {
                lk.output = (Neuron)n.provider;
                uk.output = (Neuron)n.provider;
            }
            for (Synapse s : syns.subMap(lk, true, uk, true).values()) {
                newSyns.add(s);
            }
        }
        ArrayList<Synapse> synsTmp = newSyns;
        return synsTmp;
    }

    private static Range.Operator replaceFirstAndLast(Range.Operator rm) {
        return rm == Range.Operator.FIRST || rm == Range.Operator.LAST ? Range.Operator.EQUALS : rm;
    }

    public static void unlinkNeuronRelations(Document doc, Activation act) {
        int dir;
        int v = doc.visitedCounter++;
        for (dir = 0; dir < 2; ++dir) {
            for (Activation.SynapseActivation sa : dir == 0 ? act.neuronInputs : act.neuronOutputs) {
                Activation rAct;
                Synapse s = sa.s;
                Activation activation = rAct = dir == 0 ? sa.input : sa.output;
                if (!s.key.isNeg || !s.key.isRecurrent) continue;
                Activation oAct = dir == 0 ? act : rAct;
                Activation iAct = dir == 0 ? rAct : act;
                INeuron.markConflicts(iAct, oAct, v);
                INeuron.removeConflict(doc, oAct.key.o, iAct.key.o, iAct, act, v);
            }
        }
        for (dir = 0; dir < 2; ++dir) {
            for (Activation.SynapseActivation sa : dir == 0 ? act.neuronInputs : act.neuronOutputs) {
                Activation rAct = dir == 0 ? sa.input : sa.output;
                rAct.removeSynapseActivation(dir, sa);
            }
        }
    }

    private static void addConflict(Document doc, InterprNode io, InterprNode o, NodeActivation act, Collection<NodeActivation> inputActs, long v) {
        if ((long)o.markedConflict == v || o.orInterprNodes == null) {
            if (!INeuron.isAllowed(doc.threadId, io, o, inputActs)) {
                Conflicts.add(doc, act, io, o);
            }
        } else {
            for (InterprNode no : o.orInterprNodes.values()) {
                INeuron.addConflict(doc, io, no, act, inputActs, v);
            }
        }
    }

    private static boolean isAllowed(int threadId, InterprNode io, InterprNode o, Collection<NodeActivation> inputActs) {
        if (io != null && o.contains(io, false)) {
            return true;
        }
        for (NodeActivation act : inputActs) {
            if (!((Node)act.key.n).isAllowedOption(threadId, o, act, Node.visitedCounter++)) continue;
            return true;
        }
        return false;
    }

    private static void removeConflict(Document doc, InterprNode io, InterprNode o, NodeActivation act, NodeActivation nAct, long v) {
        if ((long)o.markedConflict == v || o.orInterprNodes == null) {
            if (!((Node)nAct.key.n).isAllowedOption(doc.threadId, o, nAct, Node.visitedCounter++)) {
                assert (io != null);
                Conflicts.remove(doc, act, io, o);
            }
        } else {
            for (InterprNode no : o.orInterprNodes.values()) {
                INeuron.removeConflict(doc, io, no, act, nAct, v);
            }
        }
    }

    private static void markConflicts(Activation iAct, Activation oAct, int v) {
        oAct.key.o.markedConflict = v;
        for (Activation.SynapseActivation sa : iAct.neuronOutputs) {
            if (!sa.s.key.isRecurrent || !sa.s.key.isNeg) continue;
            sa.output.key.o.markedConflict = v;
        }
    }

    public Synapse getInputSynapse(Synapse s) {
        return this.inputSynapses.getOrDefault(s, s);
    }

    @Override
    public int compareTo(INeuron n) {
        if (((Neuron)this.provider).id < ((Neuron)n.provider).id) {
            return -1;
        }
        if (((Neuron)this.provider).id > ((Neuron)n.provider).id) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(true);
        out.writeUTF(this.label);
        out.writeDouble(this.bias);
        out.writeDouble(this.negDirSum);
        out.writeDouble(this.negRecSum);
        out.writeDouble(this.posRecSum);
        out.writeDouble(this.maxRecurrentSum);
        out.writeInt(this.outputNodes.size());
        for (Map.Entry<Synapse.Key, Provider<InputNode>> me : this.outputNodes.entrySet()) {
            me.getKey().write(out);
            out.writeInt(me.getValue().id);
        }
        out.writeBoolean(this.node != null);
        if (this.node != null) {
            out.writeInt(this.node.id);
        }
        out.writeBoolean(this.isBlocked);
        out.writeBoolean(this.noTraining);
        out.writeDouble(this.activationSum);
        out.writeInt(this.numberOfActivations);
        for (Synapse s : this.inputSynapses.values()) {
            if (s.input == null) continue;
            out.writeBoolean(true);
            s.write(out);
        }
        out.writeBoolean(false);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.label = in.readUTF();
        this.bias = in.readDouble();
        this.negDirSum = in.readDouble();
        this.negRecSum = in.readDouble();
        this.posRecSum = in.readDouble();
        this.maxRecurrentSum = in.readDouble();
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            Synapse.Key k = Synapse.Key.read(in, m);
            Object n = m.lookupNodeProvider(in.readInt());
            this.outputNodes.put(k, (Provider<InputNode>)n);
        }
        if (in.readBoolean()) {
            Integer nId = in.readInt();
            this.node = m.lookupNodeProvider(nId);
        }
        this.isBlocked = in.readBoolean();
        this.noTraining = in.readBoolean();
        this.activationSum = in.readDouble();
        this.numberOfActivations = in.readInt();
        while (in.readBoolean()) {
            Synapse syn = Synapse.read(in, m);
            this.inputSynapses.put(syn, syn);
        }
    }

    @Override
    public void suspend() {
        for (Synapse s : this.inputSynapses.values()) {
            s.input.inMemoryOutputSynapses.remove(s);
            if (s.inputNode.isSuspended()) continue;
            InputNode iNode = s.inputNode.get();
            iNode.removeSynapse(((Neuron)this.provider).m.defaultThreadId, s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            s.output.inMemoryInputSynapses.remove(s);
        }
    }

    @Override
    public void reactivate() {
        for (Synapse s : this.inputSynapses.values()) {
            s.input.inMemoryOutputSynapses.put(s, s);
            if (!s.input.isSuspended()) {
                s.output.inMemoryInputSynapses.put(s, s);
            }
            if (s.inputNode.isSuspended()) continue;
            InputNode iNode = s.inputNode.get();
            iNode.setSynapse(((Neuron)this.provider).m.defaultThreadId, s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            s.output.inMemoryInputSynapses.put(s, s);
        }
    }

    public static Neuron init(Model m, int threadId, Neuron pn, double bias, double negDirSum, double negRecSum, double posRecSum, Set<Synapse> inputs) {
        INeuron n = (INeuron)pn.get();
        ++((Neuron)n.provider).m.stat.neurons;
        n.bias = bias;
        n.negDirSum = negDirSum;
        n.negRecSum = negRecSum;
        n.posRecSum = posRecSum;
        float sum = 0.0f;
        ArrayList<Synapse> modifiedSynapses = new ArrayList<Synapse>();
        for (Synapse s : inputs) {
            assert (!s.key.startRangeOutput || s.key.startRangeMatch == Range.Operator.EQUALS || s.key.startRangeMatch == Range.Operator.FIRST);
            assert (!s.key.endRangeOutput || s.key.endRangeMatch == Range.Operator.EQUALS || s.key.endRangeMatch == Range.Operator.FIRST);
            s.output = (Neuron)n.provider;
            s.link(threadId);
            if (s.maxLowerWeightsSum == Float.MAX_VALUE) {
                s.maxLowerWeightsSum = sum;
            }
            sum += s.w;
            modifiedSynapses.add(s);
        }
        if (!Node.adjust(m, threadId, n, -1, modifiedSynapses)) {
            return null;
        }
        n.publish(threadId);
        return (Neuron)n.provider;
    }

    public static INeuron addSynapse(Model m, int threadId, Neuron pn, double biasDelta, double negDirSumDelta, double negRecSumDelta, double posRecSumDelta, Synapse s) {
        INeuron n = (INeuron)pn.get();
        n.bias += biasDelta;
        n.negDirSum += negDirSumDelta;
        n.negRecSum += negRecSumDelta;
        n.posRecSum += posRecSumDelta;
        s.output = (Neuron)n.provider;
        s.link(threadId);
        if (!Node.adjust(m, threadId, n, -1, Collections.singletonList(s))) {
            return null;
        }
        return n;
    }

    public static INeuron readNeuron(DataInput in, Neuron p) throws IOException {
        INeuron n = new INeuron();
        n.provider = p;
        n.readFields(in, p.m);
        return n;
    }

    public String toString() {
        return "n(" + this.label + ")";
    }

    public String toStringWithSynapses() {
        TreeSet<Synapse> is = new TreeSet<Synapse>(new Comparator<Synapse>(){

            @Override
            public int compare(Synapse s1, Synapse s2) {
                int r = Double.compare(s2.w, s1.w);
                if (r != 0) {
                    return r;
                }
                return Integer.compare(s1.input.id, s2.input.id);
            }
        });
        is.addAll(this.inputSynapses.values());
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("<");
        sb.append("B:");
        sb.append(Utils.round(this.bias));
        for (Synapse s : is) {
            sb.append(", ");
            sb.append(Utils.round(s.w));
            sb.append(":");
            sb.append(s.key.relativeRid);
            sb.append(":");
            sb.append(s.input.toString());
        }
        sb.append(">");
        return sb.toString();
    }

    public Collection<Activation> getFinalActivations(Document doc) {
        Stream s = NodeActivation.select(doc, (Node)this.node.get(), null, null, null, null, null, null);
        return s.filter(act -> act.finalState != null && act.finalState.value > 0.0).collect(Collectors.toList());
    }

    public static class NormWeight {
        public static final NormWeight ZERO_WEIGHT = new NormWeight(0.0, 0.0);
        public final double w;
        public final double n;

        private NormWeight(double w, double n) {
            this.w = w;
            this.n = n;
        }

        public static NormWeight create(double w, double n) {
            assert (w >= 0.0 && n >= 0.0);
            if (w == 0.0 && n == 0.0) {
                return ZERO_WEIGHT;
            }
            return new NormWeight(w, n);
        }

        public NormWeight add(NormWeight nw) {
            if (nw == null || nw == ZERO_WEIGHT) {
                return this;
            }
            return new NormWeight(this.w + nw.w, this.n + nw.n);
        }

        public NormWeight sub(NormWeight nw) {
            if (nw == null || nw == ZERO_WEIGHT) {
                return this;
            }
            return new NormWeight(this.w - nw.w, this.n - nw.n);
        }

        public double getNormWeight() {
            return this.n > 0.0 ? this.w / this.n : 0.0;
        }

        public boolean equals(NormWeight nw) {
            return Math.abs(this.w - nw.w) <= 0.001 && Math.abs(this.n - nw.n) <= 0.001;
        }

        public String toString() {
            return "W:" + this.w + " N:" + this.n + " NW:" + this.getNormWeight();
        }
    }
}

