/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Range;
import org.aika.lattice.InputNode;
import org.aika.neuron.INeuron;

public class Synapse
implements Writable {
    public static final Comparator<Synapse> INPUT_SYNAPSE_BY_WEIGHTS_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = Synapse.compareWeights(Float.valueOf(s1.w), Float.valueOf(s2.w), 1.0E-5);
            if (r != 0) {
                return r;
            }
            r = s1.input.compareTo(s2.input);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = s1.input.compareTo(s2.input);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = s1.output.compareTo(s2.output);
            if (r != 0) {
                return r;
            }
            return s1.key.compareTo(s2.key);
        }
    };
    public Neuron input;
    public Neuron output;
    public Provider<InputNode> inputNode;
    public Key key;
    public float w;
    public float maxLowerWeightsSum = Float.MAX_VALUE;
    static Map<Key, Key> keyMap = new TreeMap<Key, Key>();

    public Synapse() {
    }

    public Synapse(Neuron input) {
        if (input != null) {
            this.input = input;
        }
    }

    public Synapse(Neuron input, Key key) {
        this(input);
        this.key = Synapse.lookupKey(key);
        assert ((double)this.w >= 0.0 && !key.isNeg || (double)this.w <= 0.0 && key.isNeg);
    }

    public void link(int threadId) {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.provider).id < ((Neuron)out.provider).id;
        (dir ? in : out).lock.acquireWriteLock(threadId);
        (dir ? out : in).lock.acquireWriteLock(threadId);
        ((Neuron)in.provider).inMemoryOutputSynapses.put(this, this);
        ((Neuron)out.provider).inMemoryInputSynapses.put(this, this);
        out.inputSynapses.put(this, this);
        ((Neuron)out.provider).setModified();
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
        ++((Neuron)out.provider).m.stat.synapses;
    }

    public static int compareWeights(Float a, Float b, double tolerance) {
        double bAbs;
        double aAbs = Math.abs(a.floatValue());
        if (aAbs + tolerance < (bAbs = (double)Math.abs(b.floatValue()))) {
            return -1;
        }
        if (aAbs > bAbs + tolerance) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "S " + this.w + " " + this.key.relativeRid + " S:" + (Object)((Object)this.key.startRangeMapping) + " E:" + (Object)((Object)this.key.endRangeMapping) + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.input.id);
        out.writeInt(this.output.id);
        out.writeInt(this.inputNode.id);
        this.key.write(out);
        out.writeFloat(this.w);
        out.writeFloat(this.maxLowerWeightsSum);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.input = m.lookupNeuron(in.readInt());
        this.output = m.lookupNeuron(in.readInt());
        this.inputNode = m.lookupNodeProvider(in.readInt());
        this.key = Synapse.lookupKey(Key.read(in, m));
        this.w = in.readFloat();
        this.maxLowerWeightsSum = in.readFloat();
    }

    public static Synapse read(DataInput in, Model m) throws IOException {
        Synapse s = new Synapse();
        s.readFields(in, m);
        return s;
    }

    public static Key lookupKey(Key k) {
        Key rk = keyMap.get(k);
        if (rk == null) {
            keyMap.put(k, k);
            rk = k;
        }
        return rk;
    }

    public static class Key
    implements Comparable<Key>,
    Writable {
        public static final Key MIN_KEY = new Key();
        public static final Key MAX_KEY = new Key();
        public boolean isNeg;
        public boolean isRecurrent;
        public Integer relativeRid;
        public Integer absoluteRid;
        public Range.Operator startRangeMatch;
        public Range.Operator endRangeMatch;
        public Range.Mapping startRangeMapping;
        public Range.Mapping endRangeMapping;
        public boolean startRangeOutput;
        public boolean endRangeOutput;

        public Key() {
        }

        public Key(boolean isNeg, boolean isRecurrent, Integer relativeRid, Integer absoluteRid, Range.Operator startRangeMatch, Range.Mapping startRangeMapping, boolean startRangeOutput, Range.Operator endRangeMatch, Range.Mapping endRangeMapping, boolean endRangeOutput) {
            this.isNeg = isNeg;
            this.isRecurrent = isRecurrent;
            this.relativeRid = relativeRid;
            this.absoluteRid = absoluteRid;
            this.startRangeMatch = startRangeMatch;
            this.endRangeMatch = endRangeMatch;
            this.startRangeMapping = startRangeMapping;
            this.endRangeMapping = endRangeMapping;
            this.startRangeOutput = startRangeOutput;
            this.endRangeOutput = endRangeOutput;
        }

        public Key createInputNodeKey() {
            return this.relativeRid != null ? new Key(this.isNeg, this.isRecurrent, 0, this.absoluteRid, this.startRangeMatch, this.startRangeMapping, this.startRangeOutput, this.endRangeMatch, this.endRangeMapping, this.endRangeOutput) : this;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.isNeg);
            out.writeBoolean(this.isRecurrent);
            out.writeBoolean(this.relativeRid != null);
            if (this.relativeRid != null) {
                out.writeByte(this.relativeRid);
            }
            out.writeBoolean(this.absoluteRid != null);
            if (this.absoluteRid != null) {
                out.writeByte(this.absoluteRid);
            }
            out.writeByte(this.startRangeMatch.getId());
            out.writeByte(this.endRangeMatch.getId());
            out.writeByte(this.startRangeMapping.getId());
            out.writeByte(this.endRangeMapping.getId());
            out.writeBoolean(this.startRangeOutput);
            out.writeBoolean(this.endRangeOutput);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.isNeg = in.readBoolean();
            this.isRecurrent = in.readBoolean();
            if (in.readBoolean()) {
                this.relativeRid = in.readByte();
            }
            if (in.readBoolean()) {
                this.absoluteRid = in.readByte();
            }
            this.startRangeMatch = Range.Operator.getById(in.readByte());
            this.endRangeMatch = Range.Operator.getById(in.readByte());
            this.startRangeMapping = Range.Mapping.getById(in.readByte());
            this.endRangeMapping = Range.Mapping.getById(in.readByte());
            this.startRangeOutput = in.readBoolean();
            this.endRangeOutput = in.readBoolean();
        }

        public static Key read(DataInput in, Model m) throws IOException {
            Key k = new Key();
            k.readFields(in, m);
            return k;
        }

        @Override
        public int compareTo(Key k) {
            if (this == k) {
                return 0;
            }
            if (this == MIN_KEY && k != MIN_KEY) {
                return -1;
            }
            if (this != MIN_KEY && k == MIN_KEY) {
                return 1;
            }
            if (this == MAX_KEY && k != MAX_KEY) {
                return 1;
            }
            if (this != MAX_KEY && k == MAX_KEY) {
                return -1;
            }
            int r = Boolean.compare(this.isNeg, k.isNeg);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.isRecurrent, k.isRecurrent);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.relativeRid, k.relativeRid);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.absoluteRid, k.absoluteRid);
            if (r != 0) {
                return r;
            }
            r = this.startRangeMatch.compareTo(k.startRangeMatch);
            if (r != 0) {
                return r;
            }
            r = this.endRangeMatch.compareTo(k.endRangeMatch);
            if (r != 0) {
                return r;
            }
            r = this.startRangeMapping.compareTo(k.startRangeMapping);
            if (r != 0) {
                return r;
            }
            r = this.endRangeMapping.compareTo(k.endRangeMapping);
            if (r != 0) {
                return r;
            }
            r = Boolean.compare(this.startRangeOutput, k.startRangeOutput);
            if (r != 0) {
                return r;
            }
            return Boolean.compare(this.endRangeOutput, k.endRangeOutput);
        }
    }
}

