/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import org.aika.Neuron;
import org.aika.Utils;
import org.aika.corpus.Range;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public class Input
implements Comparable<Input> {
    boolean recurrent;
    Neuron neuron;
    float weight;
    double biasDelta;
    Range.Operator startRangeMatch = Range.Operator.NONE;
    Range.Operator endRangeMatch = Range.Operator.NONE;
    boolean startRangeOutput;
    boolean endRangeOutput;
    Range.Mapping startMapping = Range.Mapping.START;
    Range.Mapping endMapping = Range.Mapping.END;
    Integer relativeRid;
    Integer absoluteRid;

    public Input setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
        return this;
    }

    public Input setNeuron(Neuron neuron) {
        assert (neuron != null);
        this.neuron = neuron;
        return this;
    }

    public Input setWeight(float weight) {
        this.weight = weight;
        return this;
    }

    public Input setBiasDelta(double biasDelta) {
        assert (biasDelta >= 0.0 && biasDelta <= 1.0);
        this.biasDelta = biasDelta;
        return this;
    }

    public Input setAbsoluteRid(Integer absoluteRid) {
        this.absoluteRid = absoluteRid;
        return this;
    }

    public Input setRelativeRid(Integer relativeRid) {
        this.relativeRid = relativeRid;
        return this;
    }

    public Input setStartRangeMatch(Range.Operator rm) {
        this.startRangeMatch = rm;
        return this;
    }

    public Input setEndRangeMatch(Range.Operator rm) {
        this.endRangeMatch = rm;
        return this;
    }

    public Input setRangeMatch(RangeRelation rr) {
        switch (rr) {
            case EQUALS: {
                this.setStartRangeMatch(Range.Operator.EQUALS);
                this.setEndRangeMatch(Range.Operator.EQUALS);
                break;
            }
            case CONTAINS: {
                this.setStartRangeMatch(Range.Operator.LESS_THAN);
                this.setEndRangeMatch(Range.Operator.GREATER_THAN);
                break;
            }
            case CONTAINED_IN: {
                this.setStartRangeMatch(Range.Operator.GREATER_THAN);
                this.setEndRangeMatch(Range.Operator.LESS_THAN);
                break;
            }
            default: {
                this.setStartRangeMatch(Range.Operator.NONE);
                this.setEndRangeMatch(Range.Operator.NONE);
            }
        }
        return this;
    }

    public Input setRangeOutput(boolean ro) {
        this.setStartRangeOutput(ro);
        this.setEndRangeOutput(ro);
        return this;
    }

    public Input setStartRangeOutput(boolean ro) {
        this.startRangeOutput = ro;
        return this;
    }

    public Input setEndRangeOutput(boolean ro) {
        this.endRangeOutput = ro;
        return this;
    }

    public Input setStartRangeMapping(Range.Mapping startMapping) {
        this.startMapping = startMapping;
        return this;
    }

    public Input setEndRangeMapping(Range.Mapping endMapping) {
        this.endMapping = endMapping;
        return this;
    }

    Synapse getSynapse(Neuron outputNeuron) {
        return ((INeuron)outputNeuron.get()).getInputSynapse(new Synapse(this.neuron, new Synapse.Key(this.recurrent, this.relativeRid, this.absoluteRid, this.startRangeMatch, this.startMapping, this.startRangeOutput, this.endRangeMatch, this.endMapping, this.endRangeOutput)));
    }

    @Override
    public int compareTo(Input in) {
        int r = Double.compare(this.weight, in.weight);
        if (r != 0) {
            return r;
        }
        r = Double.compare(this.biasDelta, in.biasDelta);
        if (r != 0) {
            return r;
        }
        r = this.neuron.compareTo(in.neuron);
        if (r != 0) {
            return r;
        }
        r = this.startRangeMatch.compareTo(in.startRangeMatch);
        if (r != 0) {
            return r;
        }
        r = this.endRangeMatch.compareTo(in.endRangeMatch);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.relativeRid, in.relativeRid);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.absoluteRid, in.absoluteRid);
        if (r != 0) {
            return r;
        }
        r = Boolean.compare(this.startRangeOutput, in.startRangeOutput);
        if (r != 0) {
            return r;
        }
        r = Boolean.compare(this.endRangeOutput, in.endRangeOutput);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.startMapping.ordinal(), in.startMapping.ordinal());
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.endMapping.ordinal(), in.endMapping.ordinal());
        return r;
    }

    public static enum RangeRelation {
        EQUALS,
        CONTAINS,
        CONTAINED_IN,
        NONE;

    }
}

