/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.aika.AbstractNode;
import org.aika.Input;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.SuspensionHook;
import org.aika.corpus.Document;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public class Model {
    public int numberOfThreads = 1;
    public int[] lastCleanup;
    public Document[] docs;
    public SuspensionHook suspensionHook;
    public AtomicInteger currentId = new AtomicInteger(0);
    public WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> providers = new WeakHashMap();
    public Map<Integer, Provider<? extends AbstractNode>> activeProviders = new TreeMap<Integer, Provider<? extends AbstractNode>>();
    public Statistic stat = new Statistic();
    public int defaultThreadId = 0;
    public Set<Provider<AndNode>> numberOfPositionsQueue = Collections.synchronizedSet(new TreeSet<Provider<AndNode>>(new Comparator<Provider<AndNode>>(){

        @Override
        public int compare(Provider<AndNode> n1, Provider<AndNode> n2) {
            int r = Integer.compare(n1.get().numberOfPositionsNotify, n2.get().numberOfPositionsNotify);
            if (r != 0) {
                return r;
            }
            return n1.compareTo(n2);
        }
    }));
    public volatile int numberOfPositions;

    public Model() {
        this(null, 1);
    }

    public Model(SuspensionHook sh, int numberOfThreads) {
        assert (numberOfThreads >= 1);
        this.numberOfThreads = numberOfThreads;
        this.lastCleanup = new int[numberOfThreads];
        this.docs = new Document[numberOfThreads];
        this.suspensionHook = sh;
    }

    public Neuron createNeuron() {
        return (Neuron)new INeuron((Model)this).provider;
    }

    public Neuron createNeuron(String label) {
        return (Neuron)new INeuron((Model)this, (String)label).provider;
    }

    public Neuron createNeuron(String label, boolean isBlocked, boolean noTraining) {
        return (Neuron)new INeuron((Model)this, (String)label, (boolean)isBlocked, (boolean)noTraining).provider;
    }

    public Document createDocument(String txt) {
        return this.createDocument(txt, 0);
    }

    public Document createDocument(String txt, int threadId) {
        Document doc = new Document(txt, this, threadId);
        if (txt != null) {
            doc.changeNumberOfPositions(doc.length());
            if (this.docs[threadId] != null) {
                throw new RuntimeException("Two documents are using the same thread. Call clearActivations() first, before processing the next document.");
            }
            this.docs[threadId] = doc;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Provider<? extends Node>> P lookupNodeProvider(int id) {
        WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = this.providers;
        synchronized (weakHashMap) {
            Provider p;
            WeakReference<Provider<? extends AbstractNode>> wr = this.providers.get(id);
            if (wr != null && (p = (Provider)wr.get()) != null) {
                return (P)p;
            }
            return (P)new Provider(this, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Neuron lookupNeuron(int id) {
        WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = this.providers;
        synchronized (weakHashMap) {
            Neuron n;
            WeakReference<Provider<? extends AbstractNode>> wr = this.providers.get(id);
            if (wr != null && (n = (Neuron)wr.get()) != null) {
                return n;
            }
            return new Neuron(this, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFrequency() {
        for (int t = 0; t < this.numberOfThreads; ++t) {
            Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
            synchronized (map) {
                for (Provider<? extends AbstractNode> p : this.activeProviders.values()) {
                    if (p == null || !(p.get() instanceof Node)) continue;
                    ((Node)p.get()).frequency = 0;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Provider p) {
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            this.activeProviders.put(p.id, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Provider p) {
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            this.activeProviders.remove(p.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendUnusedNodes(int docId) {
        ArrayList<Provider<? extends AbstractNode>> tmp;
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            tmp = new ArrayList<Provider<? extends AbstractNode>>(this.activeProviders.values());
        }
        for (Provider provider : tmp) {
            this.suspend(docId, provider);
        }
    }

    public void suspendAll() {
        this.suspendUnusedNodes(Integer.MAX_VALUE);
    }

    private boolean suspend(int docId, Provider<? extends AbstractNode> p) {
        AbstractNode an = p.getIfNotSuspended();
        if (an != null && an.lastUsedDocumentId <= docId) {
            p.suspend();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardAll() {
        ArrayList<Provider<? extends AbstractNode>> tmp;
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            tmp = new ArrayList<Provider<? extends AbstractNode>>(this.activeProviders.values());
        }
        for (Provider provider : tmp) {
            provider.discard();
        }
    }

    public Neuron initNeuron(Neuron n, double bias, Collection<Input> inputs) {
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        for (Input input : inputs) {
            Synapse s = input.getSynapse(n);
            s.nw = input.weight;
            bias -= (double)Math.abs(input.weight) * input.biasDelta;
            is.add(s);
        }
        return INeuron.init(this, this.defaultThreadId, n, bias, is);
    }

    public void addSynapse(Neuron n, Input input) {
        double biasDelta = 0.0;
        Synapse s = input.getSynapse(n);
        s.nw = input.weight;
        INeuron.addSynapse(this, this.defaultThreadId, n, biasDelta -= (double)Math.abs(input.weight) * input.biasDelta, s);
    }

    public Neuron initNeuron(Neuron n, double bias, Input ... inputs) {
        return this.initNeuron(n, bias, new TreeSet<Input>(Arrays.asList(inputs)));
    }

    public Neuron initRelationalNeuron(Neuron n, Neuron ctn, Neuron inputSignal, boolean dirIS) {
        double bias = -30.0;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        if (inputSignal != null) {
            Synapse iss = ((INeuron)n.get()).getInputSynapse(new Synapse(inputSignal, new Synapse.Key(false, null, null, Range.Operator.LESS_THAN, dirIS ? Range.Mapping.END : Range.Mapping.START, false, Range.Operator.GREATER_THAN, dirIS ? Range.Mapping.START : Range.Mapping.END, false)));
            iss.nw = 20.0f;
            is.add(iss);
        }
        if (ctn != null) {
            Synapse ctns = ((INeuron)n.get()).getInputSynapse(new Synapse(ctn, new Synapse.Key(false, 0, null, Range.Operator.EQUALS, Range.Mapping.START, true, Range.Operator.EQUALS, Range.Mapping.END, true)));
            ctns.nw = 20.0f;
            is.add(ctns);
        }
        return INeuron.init(this, this.defaultThreadId, n, bias, is);
    }

    public Neuron initCounterNeuron(Neuron n, Neuron clockSignal, boolean dirCS, Neuron startSignal, boolean dirSS, boolean direction) {
        double bias = -44.0;
        TreeSet<Synapse> is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_BY_WEIGHTS_COMP);
        if (clockSignal != null) {
            Synapse css = ((INeuron)n.get()).getInputSynapse(new Synapse(clockSignal, new Synapse.Key(false, null, null, Range.Operator.NONE, Range.Mapping.NONE, false, Range.Operator.FIRST, dirCS ? Range.Mapping.START : Range.Mapping.END, true)));
            css.nw = 20.0f;
            is.add(css);
        }
        if (startSignal != null) {
            Synapse sss = ((INeuron)n.get()).getInputSynapse(new Synapse(startSignal, new Synapse.Key(false, 0, null, Range.Operator.EQUALS, dirSS ? Range.Mapping.START : Range.Mapping.END, true, Range.Operator.NONE, Range.Mapping.NONE, false)));
            sss.nw = 8.0f;
            is.add(sss);
        }
        Synapse lastCycle = ((INeuron)n.get()).getInputSynapse(new Synapse(n, new Synapse.Key(false, -1, null, direction ? Range.Operator.NONE : Range.Operator.EQUALS, direction ? Range.Mapping.NONE : Range.Mapping.END, !direction, direction ? Range.Operator.EQUALS : Range.Operator.NONE, direction ? Range.Mapping.START : Range.Mapping.NONE, direction)));
        lastCycle.nw = 8.0f;
        is.add(lastCycle);
        Synapse neg = ((INeuron)n.get()).getInputSynapse(new Synapse(n, new Synapse.Key(true, 0, null, Range.Operator.EQUALS, Range.Mapping.START, false, Range.Operator.EQUALS, Range.Mapping.END, false)));
        neg.nw = -20.0f;
        is.add(neg);
        return INeuron.init(this, this.defaultThreadId, n, bias, is);
    }

    public static class Statistic {
        public volatile int synapses;
        public volatile int neurons;
        public volatile int nodes;
        public volatile int[] nodesPerLevel = new int[AndNode.MAX_AND_NODE_SIZE + 1];
        public volatile int orNodes;
    }
}

