/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.lattice.NodeActivation;

public class Conflicts {
    public SortedMap<Key, Conflict> primary = new TreeMap<Key, Conflict>();
    public Map<Key, Conflict> secondary = new TreeMap<Key, Conflict>();

    static void collectDirectConflicting(Collection<InterprNode> results, InterprNode n) {
        for (Conflict c : n.conflicts.primary.values()) {
            results.add(c.secondary);
        }
        for (Conflict c : n.conflicts.secondary.values()) {
            results.add(c.primary);
        }
    }

    static void collectAllConflicting(Collection<InterprNode> results, InterprNode n, int v) {
        if (n.visitedCollectAllConflicting == v) {
            return;
        }
        n.visitedCollectAllConflicting = v;
        Conflicts.collectDirectConflicting(results, n);
        for (InterprNode pn : n.parents) {
            Conflicts.collectAllConflicting(results, pn, v);
        }
    }

    public static void add(Document doc, NodeActivation act, InterprNode primary, InterprNode secondary) {
        Key ck = new Key(secondary, act);
        Conflict c = (Conflict)primary.conflicts.primary.get(ck);
        if (c == null) {
            c = new Conflict(act, primary, secondary, InterprNode.add(primary.doc, false, primary, secondary));
            primary.countRef();
            secondary.countRef();
            c.conflict.countRef();
            ++c.conflict.isConflict;
            primary.conflicts.primary.put(ck, c);
            secondary.conflicts.secondary.put(new Key(primary, act), c);
            c.conflict.removeActivationsRecursiveStep(doc, c.conflict, doc.visitedCounter++);
        }
    }

    public static void remove(Document doc, NodeActivation act, InterprNode primary, InterprNode secondary) {
        Key ck = new Key(secondary, act);
        Conflict c = (Conflict)primary.conflicts.primary.get(ck);
        if (c == null) {
            return;
        }
        primary.conflicts.primary.remove(ck);
        secondary.conflicts.secondary.remove(new Key(primary, act));
        --c.conflict.isConflict;
        c.conflict.expandActivationsRecursiveStep(doc, c.conflict, doc.visitedCounter++);
        Conflicts.removeInternal(c);
    }

    private static void removeInternal(Conflict c) {
        c.primary.releaseRef();
        c.secondary.releaseRef();
        c.conflict.releaseRef();
    }

    public void removeAll() {
        if (this.primary != null) {
            for (Conflict c : this.primary.values()) {
                c.secondary.conflicts.secondary.remove(c.primary);
                Conflicts.removeInternal(c);
            }
        }
        this.primary.clear();
        if (this.secondary != null) {
            for (Conflict c : this.secondary.values()) {
                c.primary.conflicts.primary.remove(c.secondary);
                Conflicts.removeInternal(c);
            }
        }
        this.secondary.clear();
    }

    public boolean hasConflicts() {
        return !this.primary.isEmpty() || !this.secondary.isEmpty();
    }

    public static class Key
    implements Comparable<Key> {
        public InterprNode o;
        public NodeActivation act;

        public Key(InterprNode o, NodeActivation act) {
            this.o = o;
            this.act = act;
        }

        @Override
        public int compareTo(Key k) {
            int r = this.o.compareTo(k.o);
            if (r != 0) {
                return r;
            }
            return NodeActivation.compare(this.act, k.act);
        }
    }

    public static class Conflict {
        public NodeActivation act;
        public InterprNode primary;
        public InterprNode secondary;
        public InterprNode conflict;

        public Conflict(NodeActivation act, InterprNode primary, InterprNode secondary, InterprNode conflict) {
            this.act = act;
            this.primary = primary;
            this.secondary = secondary;
            this.conflict = conflict;
        }
    }
}

