/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import org.aika.Utils;

public class Range {
    public static final Range MIN = new Range(Integer.MIN_VALUE, Integer.MIN_VALUE);
    public static final Range MAX = new Range(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final Integer begin;
    public final Integer end;

    public Range(Integer begin, Integer end) {
        this.begin = begin;
        this.end = end;
    }

    public static Range mergeRange(Range ra, Range rb) {
        return new Range(ra.begin != null ? ra.begin : rb.begin, ra.end != null ? ra.end : rb.end);
    }

    public static Range getOutputRange(Range r, boolean[] ro) {
        return new Range(ro[0] ? r.begin : null, ro[1] ? r.end : null);
    }

    @Deprecated
    public static boolean overlaps(Range ra, Range rb) {
        return Utils.compareInteger(ra.end, rb.begin) > 0 && Utils.compareInteger(rb.end, ra.begin) > 0;
    }

    public Integer getBegin(boolean invert) {
        return invert ? this.end : this.begin;
    }

    public Integer getEnd(boolean invert) {
        return invert ? this.begin : this.end;
    }

    public Range invert(boolean inv) {
        return inv ? new Range(this.end, this.begin) : this;
    }

    public boolean isEmpty() {
        return this.end - this.begin == 0;
    }

    public int length() {
        return this.end - this.begin;
    }

    public boolean contains(Range r) {
        return this.begin <= r.begin && r.end <= this.end;
    }

    public boolean equals(Range r) {
        return this.begin == r.begin && this.end == r.end;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.begin);
        sb.append(",");
        sb.append(this.end);
        sb.append(")");
        return sb.toString();
    }

    public static int compare(Range ra, Range rb, boolean inv) {
        if (ra == null && rb == null) {
            return 0;
        }
        if (ra == null && rb != null) {
            return -1;
        }
        if (ra != null && rb == null) {
            return 1;
        }
        int a = Utils.compareInteger(ra.getBegin(inv), rb.getBegin(inv));
        if (a != 0) {
            return a;
        }
        int b = Utils.compareInteger(ra.getEnd(inv), rb.getEnd(inv));
        return b;
    }

    public static int compare(Range ra, Range rb) {
        int a = Utils.compareInteger(ra.begin, rb.begin);
        if (a != 0) {
            return a;
        }
        int b = Utils.compareInteger(ra.end, rb.end);
        return b;
    }

    public static enum Mapping {
        START(0),
        END(1),
        NONE(2);

        int id;

        private Mapping(int id) {
            this.id = id;
        }

        public static Mapping getById(int id) {
            for (Mapping m : Mapping.values()) {
                if (m.id != id) continue;
                return m;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public Integer getSignalPos(Range r) {
            switch (this) {
                case START: {
                    return r.begin;
                }
                case END: {
                    return r.end;
                }
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case START: {
                    return "S";
                }
                case END: {
                    return "E";
                }
                case NONE: {
                    return "N";
                }
            }
            return "";
        }
    }

    public static enum Operator {
        EQUALS(0),
        LESS_THAN(1),
        GREATER_THAN(2),
        FIRST(3),
        LAST(4),
        NONE(5);

        int id;

        private Operator(int id) {
            this.id = (short)id;
        }

        public static Operator getById(int id) {
            for (Operator o : Operator.values()) {
                if (o.id != id) continue;
                return o;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public boolean compare(Integer a, Integer b, Integer c, Integer d) {
            if (a == null || c == null) {
                return true;
            }
            switch (this) {
                case EQUALS: {
                    return a.intValue() == c.intValue();
                }
                case LESS_THAN: {
                    return a <= c;
                }
                case GREATER_THAN: {
                    return a >= c;
                }
                case FIRST: {
                    return d <= b && b < c;
                }
                case LAST: {
                    return b <= d && a > d;
                }
            }
            return true;
        }

        public static Operator invert(Operator rm) {
            switch (rm) {
                case EQUALS: {
                    return EQUALS;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
                case FIRST: {
                    return LAST;
                }
                case LAST: {
                    return FIRST;
                }
            }
            return NONE;
        }
    }
}

