/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.SearchNode;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public final class Activation
extends NodeActivation<OrNode> {
    public TreeSet<SynapseActivation> neuronInputs = new TreeSet<SynapseActivation>(SynapseActivation.INPUT_COMP);
    public TreeSet<SynapseActivation> neuronOutputs = new TreeSet<SynapseActivation>(SynapseActivation.OUTPUT_COMP);
    public double upperBound;
    public double lowerBound;
    public Rounds rounds = new Rounds();
    public State finalState;
    public boolean ubQueued = false;
    public boolean isQueued = false;
    public long queueId;
    public boolean isInput;
    public long currentStateV = -1L;
    public SearchNode.StateChange currentStateChange;
    public double initialErrorSignal;
    public double errorSignal;

    public Activation(int id, Document doc, NodeActivation.Key key) {
        super(id, doc, key);
    }

    public void addSynapseActivation(int dir, SynapseActivation sa) {
        if (dir == 0) {
            this.neuronOutputs.add(sa);
        } else {
            this.neuronInputs.add(sa);
        }
    }

    public void removeSynapseActivation(int dir, SynapseActivation sa) {
        if (dir == 0) {
            this.neuronOutputs.remove(sa);
        } else {
            this.neuronInputs.remove(sa);
        }
    }

    public static class State {
        public static final int DIR = 0;
        public static final int REC = 1;
        public final double value;
        public final int fired;
        public final INeuron.NormWeight weight;
        public static final State ZERO = new State(0.0, -1, INeuron.NormWeight.ZERO_WEIGHT);

        public State(double value, int fired, INeuron.NormWeight weight) {
            this.value = value;
            this.fired = fired;
            this.weight = weight;
        }

        public boolean equals(State s) {
            return Math.abs(this.value - s.value) <= INeuron.WEIGHT_TOLERANCE;
        }

        public boolean equalsWithWeights(State s) {
            return this.equals(s) && this.weight.equals(s.weight);
        }

        public String toString() {
            return "VALUE:" + this.value;
        }
    }

    public static class Rounds {
        private boolean[] isQueued = new boolean[3];
        public TreeMap<Integer, State> rounds = new TreeMap();

        public boolean set(int r, State s) {
            State lr = this.get(r - 1);
            if (lr != null && lr.equalsWithWeights(s)) {
                State or = this.rounds.get(r);
                if (or != null) {
                    this.rounds.remove(r);
                    return !or.equalsWithWeights(s);
                }
                return false;
            }
            State or = this.rounds.put(r, s);
            Iterator<Map.Entry<Integer, State>> it = this.rounds.tailMap(r + 1).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, State> me = it.next();
                if (!me.getValue().equalsWithWeights(s)) continue;
                it.remove();
            }
            return or == null || !or.equalsWithWeights(s);
        }

        public State get(int r) {
            Map.Entry<Integer, State> me = this.rounds.floorEntry(r);
            return me != null ? me.getValue() : State.ZERO;
        }

        public Rounds copy() {
            Rounds nr = new Rounds();
            nr.rounds.putAll(this.rounds);
            return nr;
        }

        public Integer getLastRound() {
            return !this.rounds.isEmpty() ? this.rounds.lastKey() : null;
        }

        public State getLast() {
            return !this.rounds.isEmpty() ? this.rounds.lastEntry().getValue() : null;
        }

        public void setQueued(int r, boolean v) {
            if (r >= this.isQueued.length) {
                this.isQueued = Arrays.copyOf(this.isQueued, this.isQueued.length * 2);
            }
            this.isQueued[r] = v;
        }

        public boolean isQueued(int r) {
            return r < this.isQueued.length ? this.isQueued[r] : false;
        }
    }

    public static class SynapseActivation {
        public final Synapse s;
        public final Activation input;
        public final Activation output;
        public static Comparator<SynapseActivation> INPUT_COMP = new Comparator<SynapseActivation>(){

            @Override
            public int compare(SynapseActivation sa1, SynapseActivation sa2) {
                int r = Synapse.INPUT_SYNAPSE_COMP.compare(sa1.s, sa2.s);
                if (r != 0) {
                    return r;
                }
                return sa1.input.compareTo(sa2.input);
            }
        };
        public static Comparator<SynapseActivation> OUTPUT_COMP = new Comparator<SynapseActivation>(){

            @Override
            public int compare(SynapseActivation sa1, SynapseActivation sa2) {
                int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(sa1.s, sa2.s);
                if (r != 0) {
                    return r;
                }
                return sa1.output.compareTo(sa2.output);
            }
        };

        public SynapseActivation(Synapse s, Activation input, Activation output) {
            this.s = s;
            this.input = input;
            this.output = output;
        }
    }
}

