/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import network.aika.AbstractNode;
import network.aika.Document;
import network.aika.PassiveInputFunction;
import network.aika.Provider;
import network.aika.SuspensionHook;
import network.aika.Writable;
import network.aika.lattice.InputNode;
import network.aika.lattice.Node;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Linker;
import network.aika.neuron.activation.SearchNode;

public class Model {
    public int numberOfThreads = 1;
    public int[] lastCleanup;
    public Document[] docs;
    public SuspensionHook suspensionHook;
    private WritableFactory nodeExtensionFactory;
    private WritableFactory neuronExtensionFactory;
    private WritableFactory synapseExtensionFactory;
    private WritableFactory activationExtensionFactory;
    public LinkerFactory linkerFactory = doc -> new Linker(doc);
    public SearchNode.SkipSelectStep skipSelectStep = act -> false;
    public AtomicInteger docIdCounter = new AtomicInteger(0);
    public AtomicInteger currentId = new AtomicInteger(0);
    public WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> providers = new WeakHashMap();
    public Map<Integer, Provider<? extends AbstractNode>> activeProviders = new TreeMap<Integer, Provider<? extends AbstractNode>>();
    public Map<Integer, PassiveInputFunction> passiveActivationFunctions = new TreeMap<Integer, PassiveInputFunction>();
    public int defaultThreadId = 0;
    public static AtomicLong visitedCounter = new AtomicLong(1L);

    public Model() {
        this(null, 1);
    }

    public Model(SuspensionHook sh, int numberOfThreads) {
        assert (numberOfThreads >= 1);
        this.numberOfThreads = numberOfThreads;
        this.lastCleanup = new int[numberOfThreads];
        this.docs = new Document[numberOfThreads];
        this.suspensionHook = sh;
    }

    public SuspensionHook getSuspensionHook() {
        return this.suspensionHook;
    }

    public void setSuspensionHook(SuspensionHook suspensionHook) {
        this.suspensionHook = suspensionHook;
    }

    public WritableFactory getNodeExtensionFactory() {
        return this.nodeExtensionFactory;
    }

    public void setNodeExtensionFactory(WritableFactory nodeExtensionFactory) {
        this.nodeExtensionFactory = nodeExtensionFactory;
    }

    public WritableFactory getNeuronExtensionFactory() {
        return this.neuronExtensionFactory;
    }

    public void setNeuronExtensionFactory(WritableFactory neuronExtensionFactory) {
        this.neuronExtensionFactory = neuronExtensionFactory;
    }

    public WritableFactory getSynapseExtensionFactory() {
        return this.synapseExtensionFactory;
    }

    public void setSynapseExtensionFactory(WritableFactory synapseExtensionFactory) {
        this.synapseExtensionFactory = synapseExtensionFactory;
    }

    public WritableFactory getActivationExtensionFactory() {
        return this.activationExtensionFactory;
    }

    public void setActivationExtensionFactory(WritableFactory activationExtensionFactory) {
        this.activationExtensionFactory = activationExtensionFactory;
    }

    public LinkerFactory getLinkerFactory() {
        return this.linkerFactory;
    }

    public void setLinkerFactory(LinkerFactory linkerFactory) {
        this.linkerFactory = linkerFactory;
    }

    public SearchNode.SkipSelectStep getSkipSelectStep() {
        return this.skipSelectStep;
    }

    public void setSkipSelectStep(SearchNode.SkipSelectStep skipSelectStep) {
        this.skipSelectStep = skipSelectStep;
    }

    public Neuron createNeuron() {
        return this.createNeuron(null);
    }

    public Neuron createNeuron(String label) {
        return this.createNeuron(label, null);
    }

    public Neuron createNeuron(String label, String outputText) {
        INeuron n = new INeuron(this, label, outputText);
        InputNode iNode = InputNode.add(this, n);
        iNode.setModified();
        return (Neuron)n.provider;
    }

    public Document createDocument(String txt) {
        return this.createDocument(txt, 0);
    }

    public Document createDocument(String txt, int threadId) {
        Document doc = new Document(this.docIdCounter.addAndGet(1), txt, this, threadId);
        if (txt != null) {
            if (this.docs[threadId] != null) {
                throw new RuntimeException("Two documents are using the same thread. Call clearActivations() first, before processing the next document.");
            }
            this.docs[threadId] = doc;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Provider<? extends Node>> P lookupNodeProvider(int id) {
        WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = this.providers;
        synchronized (weakHashMap) {
            Provider p;
            WeakReference<Provider<? extends AbstractNode>> wr = this.providers.get(id);
            if (wr != null && (p = (Provider)wr.get()) != null) {
                return (P)p;
            }
            return (P)new Provider(this, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Neuron lookupNeuron(int id) {
        WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = this.providers;
        synchronized (weakHashMap) {
            Neuron n;
            WeakReference<Provider<? extends AbstractNode>> wr = this.providers.get(id);
            if (wr != null && (n = (Neuron)wr.get()) != null) {
                return n;
            }
            return new Neuron(this, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Provider p) {
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            this.activeProviders.put(p.id, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Provider p) {
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            this.activeProviders.remove(p.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendUnusedNodes(int docId, Provider.SuspensionMode sm) {
        ArrayList<Provider<? extends AbstractNode>> tmp;
        docId = Math.min(docId, this.getOldestDocIdInProcessing());
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            tmp = new ArrayList<Provider<? extends AbstractNode>>(this.activeProviders.values());
        }
        for (Provider provider : tmp) {
            this.suspend(docId, provider, sm);
        }
    }

    public int getOldestDocIdInProcessing() {
        int oldestDocId = Integer.MAX_VALUE;
        for (Document doc : this.docs) {
            if (doc == null) continue;
            oldestDocId = Math.min(oldestDocId, doc.id);
        }
        return oldestDocId;
    }

    public void suspendAll(Provider.SuspensionMode sm) {
        this.suspendUnusedNodes(Integer.MAX_VALUE, sm);
    }

    private boolean suspend(int docId, Provider<? extends AbstractNode> p, Provider.SuspensionMode sm) {
        AbstractNode an = p.getIfNotSuspended();
        if (an != null && an.lastUsedDocumentId < docId) {
            p.suspend(sm);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProvider(Provider p) {
        Map<Integer, Provider<? extends AbstractNode>> map = this.activeProviders;
        synchronized (map) {
            this.activeProviders.remove(p.id);
        }
        map = this.providers;
        synchronized (map) {
            this.providers.remove(p.id);
        }
    }

    public static interface LinkerFactory {
        public Linker createLinker(Document var1);
    }

    public static interface WritableFactory {
        public Writable createObject();
    }
}

