/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.MultiRelation;
import network.aika.neuron.relation.PositionRelation;

public abstract class Relation
implements Comparable<Relation>,
Writable {
    public static Map<Integer, RelationFactory> relationRegistry = new TreeMap<Integer, RelationFactory>();
    public static Relation EQUALS = new MultiRelation(new PositionRelation.Equals(Activation.BEGIN, Activation.BEGIN), new PositionRelation.Equals(Activation.END, Activation.END, false, false));
    public static Relation BEGIN_EQUALS = new PositionRelation.Equals(Activation.BEGIN, Activation.BEGIN);
    public static Relation END_EQUALS = new PositionRelation.Equals(Activation.END, Activation.END);
    public static Relation BEGIN_TO_END_EQUALS = new PositionRelation.Equals(Activation.BEGIN, Activation.END);
    public static Relation END_TO_BEGIN_EQUALS = new PositionRelation.Equals(Activation.END, Activation.BEGIN);
    public static Relation CONTAINS = new MultiRelation(new PositionRelation.LessThan(Activation.BEGIN, Activation.BEGIN, true), new PositionRelation.GreaterThan(Activation.END, Activation.END, true, false, false, Integer.MAX_VALUE));
    public static Relation CONTAINED_IN = new MultiRelation(new PositionRelation.GreaterThan(Activation.BEGIN, Activation.BEGIN, true), new PositionRelation.LessThan(Activation.END, Activation.END, true, false, false, Integer.MAX_VALUE));
    public static Relation OVERLAPS = new MultiRelation(new PositionRelation.LessThan(Activation.BEGIN, Activation.END, false), new PositionRelation.GreaterThan(Activation.END, Activation.BEGIN, false, false, false, Integer.MAX_VALUE));
    public static Relation BEFORE = new PositionRelation.LessThan(Activation.END, Activation.BEGIN, true);
    public static Relation AFTER = new PositionRelation.GreaterThan(Activation.BEGIN, Activation.END, true);
    public static Relation ANY = new Any();
    protected boolean optional;
    protected boolean follow = true;

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isFollow() {
        return this.follow;
    }

    @Override
    public int compareTo(Relation rel) {
        return Integer.compare(this.getType(), rel.getType());
    }

    public static void registerRelation(int relationType, RelationFactory rf) {
        relationRegistry.put(relationType, rf);
    }

    public abstract int getType();

    public abstract boolean test(Activation var1, Activation var2);

    public abstract Relation invert();

    public abstract void mapSlots(Map<Integer, Position> var1, Activation var2);

    public abstract void linksOutputs(Set<Integer> var1);

    public abstract Relation setOptionalAndFollow(boolean var1, boolean var2);

    public Relation() {
    }

    public Relation(boolean optional, boolean follow) {
        this.optional = optional;
        this.follow = follow;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.getType());
        out.writeBoolean(this.optional);
        out.writeBoolean(this.follow);
    }

    public static Relation read(DataInput in, Model m) throws IOException {
        RelationFactory rf = relationRegistry.get(in.readInt());
        Relation rel = rf.create();
        rel.readFields(in, m);
        return rel;
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.optional = in.readBoolean();
        this.follow = in.readBoolean();
    }

    public abstract boolean isExact();

    public abstract Stream<Activation> getActivations(INeuron var1, Activation var2);

    public boolean isConvertible() {
        return !this.optional && this.follow;
    }

    public static void addRelation(Map<Integer, Relation> relMap, Integer synId, Integer targetSynId, Neuron n, Relation r) {
        Synapse s;
        if (targetSynId == -1 && ((s = n.getSynapseById(synId)) == null || r.isExact() && s.isDisjunction && !s.inactive)) {
            return;
        }
        relMap.put(synId, r);
    }

    public static Map<Integer, Relation> getRelationsMap(int synapseId, Neuron n) {
        if (synapseId == -1) {
            INeuron in = (INeuron)n.get();
            if (in.outputRelations == null) {
                in.outputRelations = new TreeMap<Integer, Relation>();
            }
            return in.outputRelations;
        }
        Synapse s = n.getSynapseById(synapseId);
        return s.relations;
    }

    public abstract void registerRequiredSlots(Neuron var1);

    public static class Any
    extends Relation {
        public static int ID = 100;

        public Any() {
        }

        public Any(boolean optional, boolean follow) {
            super(optional, follow);
        }

        @Override
        public int getType() {
            return ID;
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return true;
        }

        @Override
        public Relation invert() {
            return this;
        }

        @Override
        public void mapSlots(Map<Integer, Position> slots, Activation act) {
        }

        @Override
        public void linksOutputs(Set<Integer> outputs) {
        }

        @Override
        public boolean isExact() {
            return false;
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            INeuron.ThreadState th = n.getThreadState(linkedAct.doc.threadId, false);
            if (th == null || th.isEmpty()) {
                return Stream.empty();
            }
            return th.getActivations();
        }

        @Override
        public boolean isConvertible() {
            return true;
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new Any(optional, follow);
        }

        @Override
        public void registerRequiredSlots(Neuron input) {
        }

        static {
            Any.registerRelation(ID, () -> ANY);
        }
    }

    public static class Builder
    implements Neuron.Builder {
        private int from;
        private int to;
        private Relation relation;

        public Builder setFrom(int synapseId) {
            assert (synapseId >= -1);
            this.from = synapseId;
            return this;
        }

        public Builder setTo(int synapseId) {
            assert (synapseId >= -1);
            this.to = synapseId;
            return this;
        }

        public Builder setRelation(Relation rel) {
            this.relation = rel;
            return this;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void connect(Neuron n) {
            Map<Integer, Relation> fromRel = Relation.getRelationsMap(this.from, n);
            Map<Integer, Relation> toRel = Relation.getRelationsMap(this.to, n);
            Relation rel = this.getRelation();
            if (this.from != this.to) {
                Relation.addRelation(fromRel, this.to, this.from, n, rel);
                Relation.addRelation(toRel, this.from, this.to, n, rel.invert());
            } else {
                MultiRelation mr = new MultiRelation(Arrays.asList(rel, rel.invert()));
                Relation.addRelation(fromRel, this.to, this.from, n, mr);
            }
        }

        @Override
        public void registerSynapseIds(Neuron n) {
            n.registerSynapseId(this.from);
            n.registerSynapseId(this.to);
        }
    }

    public static interface RelationFactory {
        public Relation create();
    }
}

