/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import network.aika.AbstractNode;
import network.aika.Model;
import network.aika.Provider;
import network.aika.lattice.Converter;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.NodeQueue;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Candidate;
import network.aika.neuron.activation.Linker;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.SearchNode;
import network.aika.neuron.activation.UpperBoundQueue;
import network.aika.neuron.activation.ValueQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Document
implements Comparable<Document> {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    public static int CLEANUP_INTERVAL = 500;
    public static int MAX_ROUND = 20;
    public static int ROUND_LIMIT = -1;
    public static boolean INCREMENTAL_MODE = false;
    private final int id;
    private final StringBuilder content;
    private long visitedCounter = 1L;
    private int activationIdCounter = 0;
    private int nodeActivationIdCounter = 0;
    public int searchNodeIdCounter = 0;
    public int searchStepCounter = 0;
    public int positionIdCounter = 0;
    private Model model;
    private int threadId;
    private NodeQueue nodeQueue = new NodeQueue(this);
    private ValueQueue valueQueue = new ValueQueue();
    private UpperBoundQueue ubQueue = new UpperBoundQueue();
    private Linker linker;
    private TreeMap<Integer, Position> positions = new TreeMap();
    private TreeSet<Node> activatedNodes = new TreeSet();
    private TreeSet<INeuron> activatedNeurons = new TreeSet();
    private TreeSet<INeuron> finallyActivatedNeurons = new TreeSet();
    private TreeSet<Activation> inputNeuronActivations = new TreeSet();
    private TreeMap<INeuron, Set<Synapse>> modifiedWeights = new TreeMap();
    private TreeMap<ActKey, Activation> activationsBySlotAndPosition = new TreeMap((ak1, ak2) -> {
        int r = Integer.compare(ak1.slot, ak2.slot);
        if (r != 0) {
            return r;
        }
        r = Position.compare(ak1.pos, ak2.pos);
        if (r != 0) {
            return r;
        }
        r = ak1.neuron.compareTo(ak2.neuron);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    });
    private TreeMap<ActKey, Activation> activationsByPosition = new TreeMap((ak1, ak2) -> {
        int r = Position.compare(ak1.pos, ak2.pos);
        if (r != 0) {
            return r;
        }
        r = ak1.neuron.compareTo(ak2.neuron);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    });
    private TreeMap<Integer, Activation> activationsById = new TreeMap();
    private int lastProcessedActivationId = -1;
    public TreeSet<Node> addedNodes = new TreeSet();
    public ArrayList<NodeActivation> addedNodeActivations = new ArrayList();
    public SearchNode selectedSearchNode;
    public ArrayList<Candidate> candidates = new ArrayList();
    public long createV;
    public static Comparator<Activation> ACTIVATIONS_OUTPUT_COMPARATOR = (act1, act2) -> {
        int r = Position.compare(act1.getSlot(Activation.BEGIN), act2.getSlot(Activation.BEGIN));
        if (r != 0) {
            return r;
        }
        r = act1.getINeuron().compareTo(act2.getINeuron());
        if (r != 0) {
            return r;
        }
        return Integer.compare(act1.getId(), act2.getId());
    };

    public Document(int id, String content, Model model, int threadId) {
        this.id = id;
        this.content = new StringBuilder(content);
        this.model = model;
        this.threadId = threadId;
        this.linker = model.getLinkerFactory().createLinker(this);
    }

    public int getId() {
        return this.id;
    }

    public Model getModel() {
        return this.model;
    }

    public Linker getLinker() {
        return this.linker;
    }

    public ValueQueue getValueQueue() {
        return this.valueQueue;
    }

    public long getNewVisitedId() {
        return this.visitedCounter++;
    }

    public int getNewActivationId() {
        return this.activationIdCounter++;
    }

    public int getNewNodeActivationId() {
        return this.nodeActivationIdCounter++;
    }

    public void addActivatedNode(Node n) {
        this.activatedNodes.add(n);
    }

    public void addInputNeuronActivation(Activation act) {
        this.inputNeuronActivations.add(act);
    }

    public void addFinallyActivatedNeuron(INeuron n) {
        this.finallyActivatedNeurons.add(n);
    }

    public void addActivatedNeuron(INeuron n) {
        this.activatedNeurons.add(n);
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void append(String txt) {
        this.content.append(txt);
    }

    public char charAt(int i) {
        return this.content.charAt(i);
    }

    public String getContent() {
        return this.content.toString();
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content.toString();
    }

    public UpperBoundQueue getUpperBoundQueue() {
        return this.ubQueue;
    }

    public NodeQueue getNodeQueue() {
        return this.nodeQueue;
    }

    public Position lookupFinalPosition(int pos) {
        Position p = this.positions.get(pos);
        if (p == null) {
            p = new Position(this, pos);
            this.positions.put(pos, p);
        }
        return p;
    }

    public String getText(Position begin, Position end) {
        if (begin == null || end == null) {
            return "";
        }
        return this.getText(begin.getFinalPosition(), end.getFinalPosition());
    }

    public String getText(Integer begin, Integer end) {
        if (begin != null && end != null) {
            return this.content.substring(Math.max(0, Math.min(begin, this.length())), Math.max(0, Math.min(end, this.length())));
        }
        return "";
    }

    public void addActivation(Activation act) {
        for (Map.Entry<Integer, Position> me : act.slots.entrySet()) {
            Position pos = me.getValue();
            if (pos == null || pos.getFinalPosition() == null) continue;
            ActKey dak = new ActKey(me.getKey(), pos, act.getINeuron(), act.getId());
            this.activationsBySlotAndPosition.put(dak, act);
            this.activationsByPosition.put(dak, act);
        }
        this.activationsById.put(act.getId(), act);
    }

    public Collection<Activation> getActivations(boolean onlyFinal) {
        if (!onlyFinal) {
            return this.activationsById.values();
        }
        return this.activationsById.values().stream().filter(act -> act.isFinalActivation()).collect(Collectors.toList());
    }

    public Collection<Activation> getActivationsByPosition(int fromSlot, Position fromPos, boolean fromInclusive, int toSlot, Position toPos, boolean toInclusive) {
        return this.activationsBySlotAndPosition.subMap(new ActKey(fromSlot, fromPos, INeuron.MIN_NEURON, Integer.MIN_VALUE), fromInclusive, new ActKey(toSlot, toPos, INeuron.MAX_NEURON, Integer.MAX_VALUE), toInclusive).values();
    }

    public Collection<Activation> getActivationsByPosition(Position fromPos, boolean fromInclusive, Position toPos, boolean toInclusive) {
        return this.activationsByPosition.subMap(new ActKey(-1, fromPos, INeuron.MIN_NEURON, Integer.MIN_VALUE), fromInclusive, new ActKey(-1, toPos, INeuron.MAX_NEURON, Integer.MAX_VALUE), toInclusive).values();
    }

    public Activation getNextActivation(Activation currentAct) {
        Map.Entry<Integer, Activation> me = currentAct == null ? this.activationsById.firstEntry() : this.activationsById.higherEntry(currentAct.getId());
        return me != null ? me.getValue() : null;
    }

    public int getNumberOfActivations() {
        return this.activationsById.size();
    }

    @Override
    public int compareTo(Document doc) {
        return Integer.compare(this.id, doc.id);
    }

    public void propagate() {
        boolean flag = true;
        while (flag) {
            this.nodeQueue.process();
            flag = this.ubQueue.process();
        }
    }

    public void generateCandidates() {
        TreeSet<Candidate> tmp = new TreeSet<Candidate>();
        int i = 0;
        if (!INCREMENTAL_MODE) {
            this.candidates.clear();
        }
        for (Activation act : this.activationsById.subMap(INCREMENTAL_MODE ? this.lastProcessedActivationId : -1, false, Integer.MAX_VALUE, true).values()) {
            if (act.decision != SearchNode.Decision.UNKNOWN || !(act.upperBound > 0.0)) continue;
            SearchNode.invalidateCachedDecision(act);
            tmp.add(new Candidate(act, i++));
            this.lastProcessedActivationId = Math.max(this.lastProcessedActivationId, act.getId());
        }
        long v = this.visitedCounter++;
        for (Activation act : this.inputNeuronActivations) {
            act.markedHasCandidate = v;
        }
        while (!tmp.isEmpty()) {
            int oldSize = tmp.size();
            for (Candidate c : tmp) {
                if (!c.checkDependenciesSatisfied(v)) continue;
                tmp.remove(c);
                c.setId(this.candidates.size());
                this.candidates.add(c);
                c.getActivation().markedHasCandidate = v;
                break;
            }
            if (tmp.size() != oldSize) continue;
            log.error("Cycle detected in the activations that is not marked recurrent.");
            throw new RuntimeException("Cycle detected in the activations that is not marked recurrent.");
        }
    }

    public void process() {
        this.process(null);
    }

    public void process(Long timeoutInMilliSeconds) throws SearchNode.TimeoutException {
        this.linker.lateLinking();
        this.inputNeuronActivations.forEach(act -> this.valueQueue.propagateActivationValue(0, (Activation)act));
        this.generateCandidates();
        SearchNode rootNode = null;
        if (this.selectedSearchNode == null || !INCREMENTAL_MODE) {
            rootNode = this.selectedSearchNode = new SearchNode(this, null, null, 0);
        }
        SearchNode.search(this, this.selectedSearchNode, this.visitedCounter++, timeoutInMilliSeconds);
        for (Activation act2 : this.activationsById.values()) {
            if (!act2.isFinalActivation()) continue;
            this.finallyActivatedNeurons.add(act2.getINeuron());
        }
        if (SearchNode.COMPUTE_SOFT_MAX) {
            SearchNode.computeCachedFactor(rootNode);
            this.computeSoftMax(rootNode);
        }
    }

    private void computeSoftMax(SearchNode rootNode) {
        for (Activation act : this.activationsById.values()) {
            double offset = Double.MAX_VALUE;
            for (Activation.Option option : act.options) {
                offset = Math.min(offset, Math.log(option.cacheFactor) + option.weight);
            }
            double norm = 0.0;
            for (Activation.Option option : act.options) {
                norm += Math.exp(Math.log(option.cacheFactor) + option.weight - offset);
            }
            for (Activation.Option option : act.options) {
                if (option.decision != SearchNode.Decision.SELECTED) continue;
                option.p = Math.exp(Math.log(option.cacheFactor) + option.weight - offset) / norm;
            }
        }
    }

    public void dumpDebugCandidateStatistics() {
        for (Candidate c : this.candidates) {
            log.info(c.toString());
        }
    }

    public void notifyWeightModified(Synapse synapse) {
        Set<Synapse> is = this.modifiedWeights.get(synapse.getOutput().get());
        if (is == null) {
            is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_COMP);
            this.modifiedWeights.put((INeuron)synapse.getOutput().get(), is);
        }
        is.add(synapse);
    }

    public void commit() {
        this.modifiedWeights.forEach((n, inputSyns) -> {
            n.commit((Collection<Synapse>)inputSyns);
            Converter.convert(this.threadId, this, n, inputSyns);
        });
        this.modifiedWeights.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActivations() {
        this.activatedNeurons.forEach(n -> n.clearActivations(this));
        this.activatedNodes.forEach(n -> n.clearActivations(this));
        this.activationsById.clear();
        this.addedNodeActivations.clear();
        this.activatedNeurons.clear();
        this.activatedNodes.clear();
        this.addedNodes.clear();
        if (this.model.lastCleanup[this.threadId] + CLEANUP_INTERVAL < this.id) {
            ArrayList<Provider<? extends AbstractNode>> tmp;
            this.model.lastCleanup[this.threadId] = this.id;
            Map<Integer, Provider<? extends AbstractNode>> map = this.model.activeProviders;
            synchronized (map) {
                tmp = new ArrayList<Provider<? extends AbstractNode>>(this.model.activeProviders.values());
            }
            tmp.forEach(np -> {
                Object an = np.getIfNotSuspended();
                if (an != null && an instanceof Node) {
                    Node n = (Node)an;
                    n.clearThreadState(this.threadId, this.id - CLEANUP_INTERVAL);
                }
            });
        }
        this.model.docs[this.threadId] = null;
    }

    public String generateOutputText() {
        int oldLength = this.length();
        TreeSet<Position> queue = new TreeSet<Position>(Comparator.comparingInt(p -> p.getId()));
        for (Activation act2 : this.activationsById.values()) {
            if (act2.getINeuron().getOutputText() == null || act2.getSlot(Activation.BEGIN).getFinalPosition() == null || act2.getSlot(Activation.END).getFinalPosition() != null) continue;
            queue.add(act2.getSlot(Activation.BEGIN));
        }
        while (!queue.isEmpty()) {
            Position pos = queue.pollFirst();
            pos.getActivations(Activation.BEGIN).filter(act -> act.getINeuron().getOutputText() != null && act.isFinalActivation()).forEach(act -> {
                String outText = act.getINeuron().getOutputText();
                Position nextPos = act.getSlot(Activation.END);
                nextPos.setFinalPosition(pos.getFinalPosition() + outText.length());
                this.content.replace(act.getSlot(Activation.BEGIN).getFinalPosition(), act.getSlot(Activation.END).getFinalPosition(), outText);
                queue.add(nextPos);
            });
        }
        return this.content.substring(oldLength, this.length());
    }

    public String activationsToString() {
        TreeSet<Activation> acts = new TreeSet<Activation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        acts.addAll(this.activationsById.values());
        StringBuilder sb = new StringBuilder();
        sb.append("Id -");
        sb.append(" Decision -");
        sb.append(" Range | Text Snippet");
        sb.append(" | Identity -");
        sb.append(" Neuron Label -");
        sb.append(" Upper Bound -");
        sb.append(" Value | Net | Weight -");
        sb.append(" Input Value |");
        sb.append(" Target Value");
        sb.append("\n");
        sb.append("\n");
        for (Activation act : acts) {
            if (act.upperBound <= 0.0 && (act.targetValue == null || act.targetValue <= 0.0)) continue;
            sb.append(act.toStringDetailed());
            sb.append("\n");
        }
        if (this.selectedSearchNode != null) {
            sb.append("\n Final SearchNode:" + this.selectedSearchNode.getId() + "  WeightSum:" + this.selectedSearchNode.getAccumulatedWeight() + "\n");
        }
        return sb.toString();
    }

    public void dumpOscillatingActivations() {
        this.activatedNeurons.stream().flatMap(n -> n.getActivations(this, false)).filter(act -> act.rounds.getLastRound() != null && act.rounds.getLastRound() > MAX_ROUND - 5).forEach(act -> {
            log.error(act.getId() + " " + act.slotsToString() + " " + act.decision + " " + act.rounds);
            log.error(act.linksToString());
            log.error("");
        });
    }

    private static class ActKey {
        int slot;
        Position pos;
        INeuron neuron;
        int actId;

        public ActKey(int slot, Position pos, INeuron neuron, int actId) {
            this.slot = slot;
            this.pos = pos;
            this.neuron = neuron;
            this.actId = actId;
        }
    }
}

