/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import network.aika.AbstractNode;
import network.aika.ActivationFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.PassiveInputFunction;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.Utils;
import network.aika.Writable;
import network.aika.lattice.InputNode;
import network.aika.lattice.OrNode;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.SearchNode;
import network.aika.neuron.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INeuron
extends AbstractNode<Neuron>
implements Comparable<INeuron> {
    private static final Logger log = LoggerFactory.getLogger(INeuron.class);
    public static boolean ALLOW_WEAK_NEGATIVE_WEIGHTS = false;
    public static double WEIGHT_TOLERANCE = 0.001;
    public static final INeuron MIN_NEURON = new INeuron();
    public static final INeuron MAX_NEURON = new INeuron();
    String label;
    Type type;
    private String outputText;
    private volatile double bias;
    private volatile double biasDelta;
    private SynapseSummary synapseSummary = new SynapseSummary();
    public Set<Integer> slotHasInputs = new TreeSet<Integer>();
    public Set<Integer> slotRequired = new TreeSet<Integer>();
    private Writable extension;
    ActivationFunction activationFunction;
    private volatile int synapseIdCounter = 0;
    private Map<Integer, Relation> outputRelations = new TreeMap<Integer, Relation>();
    TreeMap<Synapse, Synapse> inputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
    TreeMap<Synapse, Synapse> outputSynapses = new TreeMap(Synapse.OUTPUT_SYNAPSE_COMP);
    TreeMap<Synapse, Synapse> passiveInputSynapses = null;
    private Provider<InputNode> outputNode;
    private Provider<OrNode> inputNode;
    ReadWriteLock lock = new ReadWriteLock();
    PassiveInputFunction passiveInputFunction = null;
    private ThreadState[] threads;

    public void setOutputNode(Provider<InputNode> node) {
        this.outputNode = node;
    }

    public String getLabel() {
        return this.label;
    }

    public Type getType() {
        return this.type;
    }

    public Provider<InputNode> getOutputNode() {
        return this.outputNode;
    }

    public Provider<OrNode> getInputNode() {
        return this.inputNode;
    }

    public SynapseSummary getSynapseSummary() {
        return this.synapseSummary;
    }

    public Map<Integer, Relation> getOutputRelations() {
        return this.outputRelations;
    }

    public Collection<Synapse> getInputSynapses() {
        return this.inputSynapses.values();
    }

    public Collection<Synapse> getPassiveInputSynapses() {
        if (this.passiveInputSynapses == null) {
            return Collections.emptyList();
        }
        return this.passiveInputSynapses.values();
    }

    public void addRequiredSlot(int slot) {
        this.slotRequired.add(slot);
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public <T extends Writable> T getExtension() {
        return (T)this.extension;
    }

    public boolean addActivation(Activation act) {
        ThreadState th = this.getThreadState(act.getThreadId(), true);
        boolean first = th.activationsBySlotAndPosition.isEmpty();
        Integer l = act.length();
        if (l != null) {
            th.minLength = Math.min(th.minLength, l);
            th.maxLength = Math.max(th.maxLength, l);
        }
        for (Map.Entry<Integer, Position> me : act.slots.entrySet()) {
            ActKey ak = new ActKey(me.getKey(), me.getValue(), act.getId());
            th.activationsBySlotAndPosition.put(ak, act);
            th.activations.put(act.getId(), act);
        }
        return first;
    }

    public Stream<Activation> getActivations(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return Stream.empty();
        }
        return th.activations.values().stream();
    }

    public boolean isEmpty(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return true;
        }
        return th.activationsBySlotAndPosition.isEmpty();
    }

    public int size(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return 0;
        }
        return th.activations.size();
    }

    public void clearActivations(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return;
        }
        th.activationsBySlotAndPosition.clear();
        th.activations.clear();
    }

    public Stream<Activation> getActivations(Document doc, int slot, Position pos, boolean onlyFinal) {
        return this.getActivations(doc, slot, pos, true, slot, pos, false).filter(act -> !onlyFinal || act.isFinalActivation());
    }

    public void clearActivations() {
        for (int i = 0; i < ((Neuron)this.provider).model.numberOfThreads; ++i) {
            this.clearActivations(i);
        }
    }

    public void clearActivations(int threadId) {
        ThreadState th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.activationsBySlotAndPosition.clear();
        th.activations.clear();
    }

    public Stream<Activation> getActivations(Document doc, int fromSlot, Position fromPos, boolean fromInclusive, int toSlot, Position toPos, boolean toInclusive) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return Stream.empty();
        }
        return th.activationsBySlotAndPosition.subMap(new ActKey(fromSlot, fromPos, Integer.MIN_VALUE), fromInclusive, new ActKey(toSlot, toPos, Integer.MAX_VALUE), toInclusive).values().stream();
    }

    public Stream<Activation> getActivations(Document doc, boolean onlyFinal) {
        return onlyFinal ? this.getActivations(doc).filter(act -> act.isFinalActivation()) : this.getActivations(doc);
    }

    public Collection<Activation> getActivations(Document doc, SortedMap<Integer, Position> slots) {
        Integer firstSlot = slots.firstKey();
        Position firstPos = (Position)slots.get(firstSlot);
        return this.getActivations(doc, firstSlot, firstPos, true, firstSlot, firstPos, true).filter(act -> {
            for (Map.Entry me : slots.entrySet()) {
                Position pos = (Position)me.getValue();
                if (pos.getFinalPosition() == null || pos.compare(act.getSlot((Integer)me.getKey())) == 0) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private ThreadState getThreadState(int threadId, boolean create) {
        ThreadState th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState();
        }
        th.lastUsed = ((Neuron)this.provider).model.docIdCounter.get();
        return th;
    }

    private INeuron() {
    }

    public INeuron(Model m, String label, String outputText, Type type, ActivationFunction actF) {
        this.label = label;
        this.type = type;
        this.activationFunction = actF;
        this.setOutputText(outputText);
        if (m.getNeuronExtensionFactory() != null) {
            this.extension = m.getNeuronExtensionFactory().createObject();
        }
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Neuron(m, this);
        OrNode node = new OrNode(m);
        InputNode iNode = new InputNode(m);
        node.setOutputNeuron((Neuron)this.provider);
        this.inputNode = node.getProvider();
        iNode.setInputNeuron((Neuron)this.provider);
        this.outputNode = iNode.getProvider();
        this.setModified();
        iNode.setModified();
    }

    public void setOutputText(String outputText) {
        this.outputText = outputText;
        this.slotRequired.add(Activation.BEGIN);
        this.slotRequired.add(Activation.END);
    }

    public String getOutputText() {
        return this.outputText;
    }

    public Activation addInput(Document doc, Activation.Builder input) {
        Integer firstSlot = input.positions.firstKey();
        Position firstPos = doc.lookupFinalPosition((Integer)input.positions.get(firstSlot));
        Activation act = null;
        block0: for (Activation a : this.getActivations(doc, firstSlot, firstPos, true, firstSlot, firstPos, true).collect(Collectors.toList())) {
            for (Map.Entry<Integer, Integer> me : input.positions.entrySet()) {
                Position pos = a.getSlot(me.getKey());
                if (pos != null && me.getValue().compareTo(pos.getFinalPosition()) == 0) continue;
                continue block0;
            }
            act = a;
        }
        if (act == null) {
            act = new Activation(doc, this, input.getSlots(doc));
        }
        Activation.State s = new Activation.State(input.value, input.value, input.net, 0.0, input.fired, 0.0);
        act.rounds.set(0, s);
        if (SearchNode.COMPUTE_SOFT_MAX) {
            Activation activation = act;
            Objects.requireNonNull(activation);
            Activation.Option o = activation.new Activation.Option(-1, SearchNode.Decision.SELECTED);
            o.p = 1.0;
            o.state = s;
            act.options = new ArrayList<Activation.Option>();
            act.options.add(o);
        }
        act.inputValue = input.value;
        act.upperBound = input.value;
        act.lowerBound = input.value;
        act.finalDecision = act.inputDecision = SearchNode.Decision.SELECTED;
        act.setDecision(act.inputDecision, doc.getNewVisitedId());
        act.setTargetValue(input.targetValue);
        doc.addInputNeuronActivation(act);
        doc.addFinallyActivatedNeuron(act.getINeuron());
        doc.getLinker().linkInput(act);
        doc.getLinker().process();
        this.propagate(act);
        doc.propagate();
        return act;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Collection<Synapse> modifiedSynapses) {
        this.synapseSummary.updateNeuronBias(this.biasDelta);
        for (Synapse s : modifiedSynapses) {
            INeuron in = (INeuron)s.getInput().get();
            in.lock.acquireWriteLock();
            try {
                this.synapseSummary.updateSynapse(s);
                s.commit();
            }
            finally {
                in.lock.releaseWriteLock();
            }
            if (!s.isZero()) continue;
            s.unlink();
        }
        this.bias += this.biasDelta;
        this.biasDelta = 0.0;
        this.setModified();
    }

    public boolean checkRequiredSlots(Document doc, SortedMap<Integer, Position> slots) {
        for (Integer slot : this.slotRequired) {
            if (slots.containsKey(slot)) continue;
            if (!this.slotHasInputs.contains(slot)) {
                slots.put(slot, new Position(doc));
                continue;
            }
            return true;
        }
        return false;
    }

    public Activation lookupActivation(Document doc, SortedMap<Integer, Position> slots, Predicate<Activation.Link> filter) {
        return this.getActivations(doc, slots).stream().filter(act -> act.match(filter)).findFirst().orElse(null);
    }

    public void remove() {
        this.clearActivations();
        for (Synapse s : this.inputSynapses.values()) {
            INeuron in = (INeuron)s.getInput().get();
            ((Neuron)in.provider).lock.acquireWriteLock();
            ((Neuron)in.provider).inMemoryOutputSynapses.remove(s);
            ((Neuron)in.provider).lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            INeuron out = (INeuron)s.getOutput().get();
            out.lock.acquireWriteLock();
            out.inputSynapses.remove(s);
            out.lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    public synchronized int getNewSynapseId() {
        this.setModified();
        return this.synapseIdCounter++;
    }

    public synchronized void registerSynapseId(Integer synId) {
        if (synId >= this.synapseIdCounter) {
            this.setModified();
            this.synapseIdCounter = synId + 1;
        }
    }

    public void propagate(Activation act) {
        Document doc = act.getDocument();
        this.outputNode.get(doc).addActivation(act);
    }

    @Override
    public int compareTo(INeuron n) {
        if (this == n) {
            return 0;
        }
        if (this == MIN_NEURON) {
            return -1;
        }
        if (n == MIN_NEURON) {
            return 1;
        }
        if (this == MAX_NEURON) {
            return 1;
        }
        if (n == MAX_NEURON) {
            return -1;
        }
        if (((Neuron)this.provider).id < ((Neuron)n.provider).id) {
            return -1;
        }
        if (((Neuron)this.provider).id > ((Neuron)n.provider).id) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(true);
        out.writeBoolean(this.label != null);
        if (this.label != null) {
            out.writeUTF(this.label);
        }
        out.writeBoolean(this.type != null);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        }
        out.writeBoolean(this.outputText != null);
        if (this.outputText != null) {
            out.writeUTF(this.outputText);
        }
        out.writeBoolean(this.extension != null);
        if (this.extension != null) {
            this.extension.write(out);
        }
        out.writeDouble(this.bias);
        this.synapseSummary.write(out);
        out.writeUTF(this.activationFunction.name());
        out.writeInt(this.slotHasInputs.size());
        for (Integer n : this.slotHasInputs) {
            out.writeInt(n);
        }
        out.writeInt(this.slotRequired.size());
        for (Integer n : this.slotRequired) {
            out.writeInt(n);
        }
        out.writeInt(this.outputNode.id);
        out.writeBoolean(this.inputNode != null);
        if (this.inputNode != null) {
            out.writeInt(this.inputNode.id);
        }
        out.writeInt(this.synapseIdCounter);
        for (Synapse synapse : this.inputSynapses.values()) {
            if (synapse.getInput() == null) continue;
            out.writeBoolean(true);
            synapse.write(out);
            out.writeBoolean(this.passiveInputSynapses != null && this.passiveInputSynapses.containsKey(synapse));
        }
        out.writeBoolean(false);
        for (Synapse synapse : this.outputSynapses.values()) {
            if (synapse.getOutput() == null) continue;
            out.writeBoolean(true);
            synapse.write(out);
        }
        out.writeBoolean(false);
        if (this.outputRelations != null) {
            out.writeInt(this.outputRelations.size());
            for (Map.Entry entry : this.outputRelations.entrySet()) {
                out.writeInt((Integer)entry.getKey());
                ((Relation)entry.getValue()).write(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int i;
        if (in.readBoolean()) {
            this.label = in.readUTF();
        }
        if (in.readBoolean()) {
            this.type = Type.valueOf(in.readUTF());
        }
        if (in.readBoolean()) {
            this.outputText = in.readUTF();
        }
        if (in.readBoolean()) {
            this.extension = m.getNeuronExtensionFactory().createObject();
            this.extension.readFields(in, m);
        }
        this.bias = in.readDouble();
        this.synapseSummary = SynapseSummary.read(in, m);
        this.activationFunction = ActivationFunction.valueOf(in.readUTF());
        int l = in.readInt();
        for (i = 0; i < l; ++i) {
            this.slotHasInputs.add(in.readInt());
        }
        l = in.readInt();
        for (i = 0; i < l; ++i) {
            this.slotRequired.add(in.readInt());
        }
        this.outputNode = m.lookupNodeProvider(in.readInt());
        if (in.readBoolean()) {
            Integer nId = in.readInt();
            this.inputNode = m.lookupNodeProvider(nId);
        }
        this.synapseIdCounter = in.readInt();
        while (in.readBoolean()) {
            Synapse syn = Synapse.read(in, m);
            this.inputSynapses.put(syn, syn);
            if (!in.readBoolean()) continue;
            this.registerPassiveInputSynapse(syn);
        }
        while (in.readBoolean()) {
            Synapse syn = Synapse.read(in, m);
            this.outputSynapses.put(syn, syn);
        }
        l = in.readInt();
        if (l > 0) {
            this.outputRelations = new TreeMap<Integer, Relation>();
            for (int i2 = 0; i2 < l; ++i2) {
                Integer relId = in.readInt();
                Relation r = Relation.read(in, m);
                this.outputRelations.put(relId, r);
            }
        }
        this.passiveInputFunction = m.passiveActivationFunctions.get(((Neuron)this.provider).id);
    }

    @Override
    public void suspend() {
        for (Synapse s : this.inputSynapses.values()) {
            s.getInput().removeInMemoryOutputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.getOutput().removeInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryInputSynapses.values()) {
            s.getInput().removeInMemoryOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            s.getOutput().removeInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    @Override
    public void reactivate() {
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).inMemoryInputSynapses.values()) {
            s.getInput().addInMemoryOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).inMemoryOutputSynapses.values()) {
            s.getOutput().addInMemoryInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
        for (Synapse s : this.inputSynapses.values()) {
            s.getInput().addInMemoryOutputSynapse(s);
            if (s.getInput().isSuspended()) continue;
            s.getOutput().addInMemoryInputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.getOutput().addInMemoryInputSynapse(s);
            if (s.getOutput().isSuspended()) continue;
            s.getInput().addInMemoryOutputSynapse(s);
        }
    }

    public void setBias(double b) {
        this.biasDelta = b - this.bias;
    }

    public void updateBiasDelta(double biasDelta) {
        this.biasDelta += biasDelta;
    }

    public double getBias() {
        return this.bias;
    }

    public double getNewBias() {
        return this.bias + this.biasDelta;
    }

    public void register(Activation act) {
        Document doc = act.getDocument();
        if (this.addActivation(act)) {
            doc.addActivatedNeuron(act.getINeuron());
        }
        for (Map.Entry<Integer, Position> me : act.slots.entrySet()) {
            me.getValue().addActivation(me.getKey(), act);
        }
        doc.addActivation(act);
    }

    public static INeuron readNeuron(DataInput in, Neuron p) throws IOException {
        INeuron n = new INeuron();
        n.provider = p;
        n.threads = new ThreadState[p.model.numberOfThreads];
        n.readFields(in, p.model);
        return n;
    }

    public boolean isPassiveInputNeuron() {
        return this.passiveInputFunction != null;
    }

    public void registerPassiveInputSynapse(Synapse s) {
        if (this.passiveInputSynapses == null) {
            this.passiveInputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
        }
        this.passiveInputSynapses.put(s, s);
    }

    public String toString() {
        return this.label;
    }

    public String toStringWithSynapses() {
        TreeSet<Synapse> is = new TreeSet<Synapse>((s1, s2) -> {
            int r = Double.compare(s2.getWeight(), s1.getWeight());
            if (r != 0) {
                return r;
            }
            return Integer.compare(s1.getInput().id, s2.getInput().id);
        });
        is.addAll(this.inputSynapses.values());
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("<");
        sb.append("B:");
        sb.append(Utils.round(this.bias));
        for (Synapse s : is) {
            sb.append(", ");
            sb.append(Utils.round(s.getWeight()));
            sb.append(":");
            sb.append(s.getInput().toString());
        }
        sb.append(">");
        return sb.toString();
    }

    public static class SynapseSummary
    implements Writable {
        private volatile double biasSum;
        private volatile double posDirSum;
        private volatile double negDirSum;
        private volatile double negRecSum;
        private volatile double posRecSum;
        private volatile double posPassiveSum;
        private volatile int numDisjunctiveSynapses = 0;

        public double getBiasSum() {
            return this.biasSum;
        }

        public double getPosDirSum() {
            return this.posDirSum;
        }

        public double getNegDirSum() {
            return this.negDirSum;
        }

        public double getNegRecSum() {
            return this.negRecSum;
        }

        public double getPosRecSum() {
            return this.posRecSum;
        }

        public double getPosPassiveSum() {
            return this.posPassiveSum;
        }

        public int getNumDisjunctiveSynapses() {
            return this.numDisjunctiveSynapses;
        }

        public void updateNeuronBias(double biasDelta) {
            this.biasSum += biasDelta;
        }

        public void updateSynapse(Synapse s) {
            if (!s.isInactive()) {
                this.biasSum -= s.getBias();
                this.biasSum += s.getNewBias();
                this.updateSum(s.isRecurrent(), s.isNegative(), -(s.getLimit() * s.getWeight()));
                this.updateSum(s.isRecurrent(), s.getNewWeight() <= 0.0, s.getNewLimit() * s.getNewWeight());
                if (((INeuron)s.getInput().get()).isPassiveInputNeuron() && !s.isNegative()) {
                    this.posPassiveSum -= !s.isNegative() ? s.getLimit() * s.getWeight() : 0.0;
                    this.posPassiveSum += s.getNewWeight() > 0.0 ? s.getNewLimit() * s.getNewWeight() : 0.0;
                }
                if (!s.isRecurrent()) {
                    if (!s.isDisjunction(Synapse.State.OLD) && s.isDisjunction(Synapse.State.NEW)) {
                        ++this.numDisjunctiveSynapses;
                    } else if (s.isDisjunction(Synapse.State.OLD) && !s.isDisjunction(Synapse.State.NEW)) {
                        --this.numDisjunctiveSynapses;
                    }
                }
            }
            assert (Double.isFinite(this.biasSum));
        }

        private void updateSum(boolean rec, boolean neg, double delta) {
            if (!rec) {
                if (!neg) {
                    this.posDirSum += delta;
                } else {
                    this.negDirSum += delta;
                }
            } else if (!neg) {
                this.posRecSum += delta;
            } else {
                this.negRecSum += delta;
            }
        }

        public static SynapseSummary read(DataInput in, Model m) throws IOException {
            SynapseSummary ss = new SynapseSummary();
            ss.readFields(in, m);
            return ss;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeDouble(this.biasSum);
            out.writeDouble(this.posDirSum);
            out.writeDouble(this.negDirSum);
            out.writeDouble(this.negRecSum);
            out.writeDouble(this.posRecSum);
            out.writeDouble(this.posPassiveSum);
            out.writeInt(this.numDisjunctiveSynapses);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.biasSum = in.readDouble();
            this.posDirSum = in.readDouble();
            this.negDirSum = in.readDouble();
            this.negRecSum = in.readDouble();
            this.posRecSum = in.readDouble();
            this.posPassiveSum = in.readDouble();
            this.numDisjunctiveSynapses = in.readInt();
        }
    }

    public static class ActKey
    implements Comparable<ActKey> {
        int slot;
        Position pos;
        int actId;

        public ActKey(int slot, Position pos, int actId) {
            this.slot = slot;
            this.pos = pos;
            this.actId = actId;
        }

        @Override
        public int compareTo(ActKey ak) {
            int r = Integer.compare(this.slot, ak.slot);
            if (r != 0) {
                return r;
            }
            r = this.pos.compare(ak.pos);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.actId, ak.actId);
        }
    }

    private static class ThreadState {
        public long lastUsed;
        private TreeMap<ActKey, Activation> activationsBySlotAndPosition;
        private TreeMap<Integer, Activation> activations;
        public int minLength = Integer.MAX_VALUE;
        public int maxLength = 0;

        public ThreadState() {
            this.activationsBySlotAndPosition = new TreeMap();
            this.activations = new TreeMap();
        }
    }

    public static enum Type {
        INPUT,
        EXCITATORY,
        INHIBITORY;

    }
}

