/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.Iterator;
import java.util.Map;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.SearchNode;

public class Candidate
implements Comparable<Candidate> {
    SearchNode currentSearchNode;
    SearchNode.Decision cachedDecision = SearchNode.Decision.UNKNOWN;
    boolean repeat = false;
    double alternativeCachedWeightExpSum;
    SearchNode cachedSearchNode;
    SearchNode bestChildNode;
    Activation activation;
    int[] debugCounts = new int[3];
    int[] debugDecisionCounts = new int[3];
    int[] debugComputed = new int[3];
    int id;
    int sequence = 0;

    public Candidate(Activation act, int id) {
        this.activation = act;
        this.id = id;
        act.candidate = this;
        this.sequence = act.getSequence();
    }

    public void setId(int id) {
        this.id = id;
    }

    public Activation getActivation() {
        return this.activation;
    }

    public boolean isConflicting() {
        return !this.activation.getConflicts().isEmpty();
    }

    public boolean checkDependenciesSatisfied(long v) {
        return !this.activation.getInputLinks(false).anyMatch(l -> l.getInput().markedHasCandidate != v && !l.isRecurrent() && l.getInput().upperBound > 0.0);
    }

    public String toString() {
        return " ACT:" + this.activation.getId() + " " + this.activation.slotsToString() + " " + this.activation.identityToString() + " " + this.activation.getLabel() + " CID:" + this.id + " CD:" + this.cachedDecision + " REPEAT:" + this.repeat + " CONFLICT:" + this.isConflicting() + " LIMITED:" + this.debugCounts[SearchNode.DebugState.LIMITED.ordinal()] + " CACHED:" + this.debugCounts[SearchNode.DebugState.CACHED.ordinal()] + " EXPLORE:" + this.debugCounts[SearchNode.DebugState.EXPLORE.ordinal()] + " SELECTED:" + this.debugDecisionCounts[0] + " EXCLUDED:" + this.debugDecisionCounts[1] + " SIM-CACHED:" + this.debugComputed[0] + " SIM-COMPUTED:" + this.debugComputed[1] + " MODIFIED:" + this.debugComputed[2];
    }

    @Override
    public int compareTo(Candidate c) {
        int r;
        if (!this.isConflicting() && c.isConflicting()) {
            return -1;
        }
        if (this.isConflicting() && !c.isConflicting()) {
            return 1;
        }
        Iterator<Map.Entry<Integer, Position>> ita = this.activation.slots.entrySet().iterator();
        Iterator<Map.Entry<Integer, Position>> itb = c.activation.slots.entrySet().iterator();
        while (ita.hasNext() || itb.hasNext()) {
            Map.Entry<Integer, Position> meb;
            Map.Entry<Integer, Position> mea = ita.hasNext() ? ita.next() : null;
            Map.Entry<Integer, Position> entry = meb = itb.hasNext() ? itb.next() : null;
            if (mea == null && meb == null) break;
            if (mea == null && meb != null) {
                return -1;
            }
            if (mea != null && meb == null) {
                return 1;
            }
            r = Integer.compare(mea.getKey(), meb.getKey());
            if (r != 0) {
                return r;
            }
            r = Position.compare(this.activation.getSlot(mea.getKey()), c.activation.getSlot(meb.getKey()));
            if (r == 0) continue;
            return r;
        }
        if ((r = Integer.compare(this.sequence, c.sequence)) != 0) {
            return r;
        }
        return Integer.compare(this.id, c.id);
    }
}

