/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.Model;
import network.aika.Provider;
import network.aika.Writable;
import network.aika.lattice.InputNode;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.relation.Relation;

class AndNode
extends Node<AndNode, AndActivation> {
    List<Entry> parents;

    public AndNode() {
        this.parents = new ArrayList<Entry>();
    }

    public AndNode(Model m, int level, List<Entry> parents) {
        super(m, level);
        this.parents = parents;
    }

    private void init() {
        for (Entry e : this.parents) {
            e.rv.child = this.provider;
            Node pn = e.rv.parent.get();
            pn.addAndChild(e.ref, e.rv);
            pn.setModified();
        }
    }

    @Override
    protected void propagate(AndActivation act) {
        if (this.andChildren != null) {
            for (Link fl : act.inputs) {
                if (fl == null) continue;
                NodeActivation<?> pAct = fl.input;
                for (Link sl : pAct.outputsToAndNode.values()) {
                    AndActivation secondAct = sl.output;
                    if (act == secondAct) continue;
                    this.applyIntern(act, fl.refAct, fl.ref, fl.rv, secondAct, sl.refAct, sl.ref, sl.rv);
                }
            }
        }
        this.propagateToOrNode(act);
    }

    @Override
    public void cleanup() {
        if (!this.isRemoved && !this.isRequired()) {
            this.remove();
            for (Entry e : this.parents) {
                e.rv.parent.get().cleanup();
            }
        }
    }

    @Override
    void processActivation(AndActivation act) {
        if (act.isComplete()) {
            super.processActivation(act);
        }
    }

    private void applyIntern(AndActivation act, InputNode.InputActivation refAct, Refinement ref, RefValue rv, NodeActivation secondAct, InputNode.InputActivation secondRefAct, Refinement secondRef, RefValue secondRv) {
        Document doc = act.getDocument();
        this.lock.acquireReadLock();
        block0: for (Map.Entry me : this.andChildren.subMap(new Refinement(RelationsMap.MIN, secondRef.input), new Refinement(RelationsMap.MAX, secondRef.input)).entrySet()) {
            Refinement nRef = me.getKey();
            RefValue nRv = (RefValue)me.getValue();
            if (!nRef.contains(secondRef, rv)) continue;
            AndNode nlNode = nRv.child.get(doc);
            AndActivation nlAct = this.lookupAndActivation(act, nRef);
            if (nlAct == null) {
                nlAct = new AndActivation(doc, nlNode);
                nlAct.link(nRef, nRv, secondRefAct, act);
            }
            ((AndNode)nlAct.getNode()).addActivation(nlAct);
            for (Entry secondNE : nlNode.parents) {
                if (secondNE.rv.parent.get(doc) != secondAct.getNode() || !secondNE.ref.contains(ref, secondRv)) continue;
                nlAct.link(secondNE.ref, secondNE.rv, refAct, secondAct);
                continue block0;
            }
        }
        this.lock.releaseReadLock();
    }

    private AndActivation lookupAndActivation(NodeActivation<?> input, Refinement ref) {
        for (Link l : input.outputsToAndNode.values()) {
            if (l.ref.compareTo(ref) != 0) continue;
            return l.output;
        }
        return null;
    }

    @Override
    RefValue expand(int threadId, Document doc, Refinement firstRef) {
        if (!firstRef.isConvertible()) {
            return null;
        }
        RefValue firstRV = this.getAndChild(firstRef);
        if (firstRV != null) {
            return firstRV;
        }
        int firstRefOffset = this.level;
        Integer[] firstOffsets = new Integer[this.level];
        for (int i = 0; i < firstOffsets.length; ++i) {
            firstOffsets[i] = i;
        }
        ArrayList<Entry> nextLevelParents = new ArrayList<Entry>();
        for (Entry firstParent : this.parents) {
            Refinement secondParentRef;
            Node parentNode = firstParent.rv.parent.get(doc);
            RefValue secondParentRV = parentNode.expand(threadId, doc, secondParentRef = new Refinement(this.getParentRelations(firstRef, firstParent), firstRef.input));
            if (secondParentRV == null) continue;
            Refinement secondRef = new Refinement(AndNode.getRelations(firstRef, firstParent, secondParentRV), firstParent.ref.input);
            RefValue secondRV = new RefValue(AndNode.getOffsets(firstRefOffset, firstParent, secondParentRV), firstOffsets[firstParent.rv.refOffset], secondParentRV.child);
            nextLevelParents.add(new Entry(secondRef, secondRV));
        }
        firstRV = new RefValue(firstOffsets, firstRefOffset, this.provider);
        nextLevelParents.add(new Entry(firstRef, firstRV));
        return AndNode.createAndNode(this.provider.model, doc, nextLevelParents, this.level + 1) ? firstRV : null;
    }

    private RelationsMap getParentRelations(Refinement firstRef, Entry firstParent) {
        Relation[] secondParentRelations = new Relation[firstRef.relations.length() - 1];
        for (int i = 0; i < firstRef.relations.length(); ++i) {
            Integer j = firstParent.rv.reverseOffsets[i];
            if (j == null) continue;
            secondParentRelations[j.intValue()] = firstRef.relations.get(i);
        }
        return new RelationsMap(secondParentRelations);
    }

    private static RelationsMap getRelations(Refinement firstRef, Entry firstParent, RefValue secondParentRV) {
        Relation[] secondRelations = new Relation[firstParent.ref.relations.length() + 1];
        for (int i = 0; i < firstParent.ref.relations.length(); ++i) {
            int j = secondParentRV.offsets[i];
            secondRelations[j] = firstParent.ref.relations.get(i);
        }
        Relation rel = firstRef.relations.get(firstParent.rv.refOffset);
        if (rel != null) {
            secondRelations[secondParentRV.refOffset] = rel.invert();
        }
        return new RelationsMap(secondRelations);
    }

    private static Integer[] getOffsets(int firstRefOffset, Entry firstParent, RefValue secondParentRV) {
        Integer[] secondOffsets = new Integer[secondParentRV.offsets.length + 1];
        for (int i = 0; i < firstParent.rv.reverseOffsets.length; ++i) {
            Integer j = firstParent.rv.reverseOffsets[i];
            if (j == null) continue;
            secondOffsets[secondParentRV.offsets[j.intValue()].intValue()] = i;
        }
        secondOffsets[secondParentRV.refOffset] = firstRefOffset;
        return secondOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createAndNode(Model m, Document doc, List<Entry> parents, int level) {
        if (parents != null) {
            TreeSet<Provider<? extends Node>> parentsForLocking = new TreeSet<Provider<? extends Node>>();
            for (Entry entry : parents) {
                parentsForLocking.add(entry.rv.parent);
            }
            for (Provider provider : parentsForLocking) {
                ((Node)provider.get()).lock.acquireWriteLock();
            }
            try {
                AndNode nln = new AndNode(m, level, parents);
                nln.init();
                nln.postCreate(doc);
            }
            catch (Throwable throwable) {
                for (Provider provider : parentsForLocking) {
                    ((Node)provider.get()).lock.releaseWriteLock();
                }
                throw throwable;
            }
            for (Provider provider : parentsForLocking) {
                ((Node)provider.get()).lock.releaseWriteLock();
            }
        }
        return true;
    }

    @Override
    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        super.changeNumberOfNeuronRefs(threadId, v, d);
        this.parents.forEach(e -> e.rv.parent.get().changeNumberOfNeuronRefs(threadId, v, d));
    }

    @Override
    public void reprocessInputs(Document doc) {
        for (Entry e : this.parents) {
            Node pn = e.rv.parent.get();
            for (NodeActivation act : pn.getActivations(doc)) {
                act.repropagateV = this.markedCreated;
                ((Node)act.getNode()).propagate((NodeActivation)act);
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (Entry e : this.parents) {
            Node pn = e.rv.parent.get();
            pn.lock.acquireWriteLock();
            pn.removeAndChild(e.ref);
            pn.setModified();
            pn.lock.releaseWriteLock();
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND(" + this.level + ")[");
        boolean first = true;
        for (Entry e : this.parents) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(e.ref);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(65);
        super.write(out);
        out.writeInt(this.parents.size());
        for (Entry e : this.parents) {
            e.ref.write(out);
            e.rv.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            Refinement ref = Refinement.read(in, m);
            RefValue rv = RefValue.read(in, m);
            this.parents.add(new Entry(ref, rv));
        }
    }

    public static class Link {
        public Refinement ref;
        public RefValue rv;
        public NodeActivation<?> input;
        public InputNode.InputActivation refAct;
        public AndActivation output;

        public Link(Refinement ref, RefValue rv, InputNode.InputActivation refAct, NodeActivation<?> input, AndActivation output) {
            this.ref = ref;
            this.rv = rv;
            this.refAct = refAct;
            this.input = input;
            this.output = output;
        }
    }

    public static class AndActivation
    extends NodeActivation<AndNode> {
        public Link[] inputs;

        public AndActivation(Document doc, AndNode node) {
            super(doc, node);
            this.inputs = new Link[node.level];
        }

        public void link(Refinement ref, RefValue rv, InputNode.InputActivation refAct, NodeActivation<?> input) {
            Link l;
            this.inputs[rv.refOffset] = l = new Link(ref, rv, refAct, input, this);
            input.outputsToAndNode.put(this.id, l);
        }

        @Override
        public Activation getInputActivation(int i) {
            Link l = this.inputs[i];
            if (l != null) {
                return l.refAct.input;
            }
            for (int j = 0; j < this.inputs.length; ++j) {
                if (j == i || (l = this.inputs[j]) == null) continue;
                return l.input.getInputActivation(l.rv.reverseOffsets[i]);
            }
            return null;
        }

        public boolean isComplete() {
            int numberOfLinks = 0;
            for (Link l : this.inputs) {
                if (l == null) continue;
                ++numberOfLinks;
            }
            return ((AndNode)this.getNode()).parents.size() == numberOfLinks;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("A-ACT(");
            boolean first = true;
            for (int i = 0; i < this.inputs.length; ++i) {
                Activation iAct = this.getInputActivation(i);
                if (iAct == null) continue;
                if (!first) {
                    sb.append(",");
                }
                sb.append(i + ":" + iAct.getLabel() + " " + iAct.slotsToString() + " (" + iAct.getId() + ")");
                first = false;
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class Entry {
        public Refinement ref;
        public RefValue rv;

        public Entry(Refinement ref, RefValue rv) {
            this.ref = ref;
            this.rv = rv;
        }
    }

    public static class RefValue
    implements Writable {
        public Integer[] offsets;
        public Integer[] reverseOffsets;
        public int refOffset;
        public Provider<? extends Node> parent;
        public Provider<AndNode> child;

        private RefValue() {
        }

        public RefValue(Integer[] offsets, int refOffset, Provider<? extends Node> parent) {
            this.offsets = offsets;
            this.reverseOffsets = new Integer[offsets.length + 1];
            for (int i = 0; i < offsets.length; ++i) {
                this.reverseOffsets[offsets[i].intValue()] = i;
            }
            this.refOffset = refOffset;
            this.parent = parent;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.offsets.length);
            for (int i = 0; i < this.offsets.length; ++i) {
                Integer ofs = this.offsets[i];
                out.writeBoolean(ofs != null);
                out.writeInt(ofs);
            }
            out.writeInt(this.refOffset);
            out.writeInt(this.parent.id);
            out.writeInt(this.child.id);
        }

        public static RefValue read(DataInput in, Model m) throws IOException {
            RefValue rv = new RefValue();
            rv.readFields(in, m);
            return rv;
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            int l = in.readInt();
            this.offsets = new Integer[l];
            this.reverseOffsets = new Integer[l + 1];
            for (int i = 0; i < l; ++i) {
                Integer ofs;
                if (!in.readBoolean()) continue;
                this.offsets[i] = ofs = Integer.valueOf(in.readInt());
                this.reverseOffsets[ofs.intValue()] = i;
            }
            this.refOffset = in.readInt();
            this.parent = m.lookupNodeProvider(in.readInt());
            this.child = m.lookupNodeProvider(in.readInt());
        }
    }

    public static class RelationsMap
    implements Comparable<RelationsMap>,
    Writable {
        public static final RelationsMap MIN = new RelationsMap();
        public static final RelationsMap MAX = new RelationsMap();
        public Relation[] relations;

        public RelationsMap() {
        }

        public RelationsMap(Relation[] relations) {
            this.relations = relations;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.relations.length);
            for (int i = 0; i < this.relations.length; ++i) {
                Relation rel = this.relations[i];
                out.writeBoolean(rel != null);
                if (rel == null) continue;
                rel.write(out);
            }
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            int l = in.readInt();
            this.relations = new Relation[l];
            for (int i = 0; i < l; ++i) {
                if (!in.readBoolean()) continue;
                this.relations[i] = Relation.read(in, m);
            }
        }

        public static RelationsMap read(DataInput in, Model m) throws IOException {
            RelationsMap k = new RelationsMap();
            k.readFields(in, m);
            return k;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.relations.length; ++i) {
                Relation rel = this.relations[i];
                if (rel == null) continue;
                sb.append(i + ":" + rel + ", ");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(RelationsMap rm) {
            if (this == MIN) {
                return -1;
            }
            if (rm == MIN) {
                return 1;
            }
            if (this == MAX) {
                return 1;
            }
            if (rm == MAX) {
                return -1;
            }
            int r = Integer.compare(this.relations.length, rm.relations.length);
            if (r != 0) {
                return r;
            }
            for (int i = 0; i < this.relations.length; ++i) {
                Relation ra = this.relations[i];
                Relation rb = rm.relations[i];
                if (ra == null && rb == null) continue;
                if (ra == null && rb != null) {
                    return -1;
                }
                if (ra != null && rb == null) {
                    return 1;
                }
                r = ra.compareTo(rb);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }

        public int length() {
            return this.relations.length;
        }

        public Relation get(int i) {
            return this.relations[i];
        }

        public int size() {
            if (this.relations.length == 0) {
                return 0;
            }
            int count = 0;
            for (int i = 0; i < this.relations.length; ++i) {
                if (this.relations[i] == null) continue;
                ++count;
            }
            return count;
        }

        public boolean isExact() {
            for (Relation rel : this.relations) {
                if (rel.isExact()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Refinement
    implements Comparable<Refinement>,
    Writable {
        public RelationsMap relations;
        public Provider<InputNode> input;

        private Refinement() {
        }

        public Refinement(RelationsMap relations, Provider<InputNode> input) {
            this.relations = relations;
            this.input = input;
        }

        public boolean isConvertible() {
            for (Relation rel : this.relations.relations) {
                if (rel == null || !rel.isConvertible()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.relations);
            sb.append(this.input.get().logicToString());
            sb.append(")");
            return sb.toString();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.relations.write(out);
            out.writeInt(this.input.id);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.relations = RelationsMap.read(in, m);
            this.input = m.lookupNodeProvider(in.readInt());
        }

        public static Refinement read(DataInput in, Model m) throws IOException {
            Refinement k = new Refinement();
            k.readFields(in, m);
            return k;
        }

        @Override
        public int compareTo(Refinement ref) {
            int r = this.input.compareTo(ref.input);
            if (r != 0) {
                return r;
            }
            return this.relations.compareTo(ref.relations);
        }

        public boolean contains(Refinement ref, RefValue rv) {
            for (int i = 0; i < ref.relations.length(); ++i) {
                Relation ra = ref.relations.get(i);
                Relation rb = this.relations.get(rv.offsets[i]);
                if (ra == null && rb != null || ra != null && rb == null) {
                    return false;
                }
                if (ra == null || rb == null || ra.compareTo(rb) == 0) continue;
                return false;
            }
            return true;
        }
    }
}

