/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public abstract class AncestorRelation
extends Relation {
    public static AncestorRelation COMMON_ANCESTOR = new CommonAncestor();
    public static AncestorRelation IS_DESCENDANT_OF = new IsDescendantOf();
    public static AncestorRelation IS_ANCESTOR_OF = new IsAncestorOf();
    public static AncestorRelation NOT_DESCENDANT_OF = new NotDescendantOf();
    public static AncestorRelation NOT_ANCESTOR_OF = new NotAncestorOf();

    AncestorRelation() {
    }

    @Override
    public void registerRequiredSlots(Neuron input) {
    }

    private static void collectCommonAncestor(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (linkedAct.getVisitedId() == v) {
            return;
        }
        AncestorRelation.collectContains(results, n, linkedAct, v);
        linkedAct.getInputLinks(false).filter(l -> l.isIdentity()).forEach(l -> AncestorRelation.collectCommonAncestor(results, n, l.getInput(), v));
    }

    private static void collectContains(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (!linkedAct.checkVisited(v)) {
            return;
        }
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getOutputLinks().filter(l -> l.isIdentity()).forEach(l -> AncestorRelation.collectContains(results, n, l.getOutput(), v));
    }

    private static void collectContainedIn(Collection<Activation> results, INeuron n, Activation linkedAct, long v) {
        if (!linkedAct.checkVisited(v)) {
            return;
        }
        if (linkedAct.getINeuron() == n) {
            results.add(linkedAct);
        }
        linkedAct.getInputLinks(false).filter(l -> l.isIdentity()).forEach(l -> AncestorRelation.collectContainedIn(results, n, l.getInput(), v));
    }

    @Override
    public void mapSlots(Map<Integer, Position> slots, Activation act) {
    }

    @Override
    public void linksOutputs(Set<Integer> results) {
    }

    private static boolean contains(Activation actA, Activation actB, long v) {
        if (!actA.checkVisited(v)) {
            return false;
        }
        if (actA == actB) {
            return true;
        }
        return actA.getInputLinks(false).filter(l -> l.isIdentity()).anyMatch(l -> AncestorRelation.contains(l.getInput(), actB, v));
    }

    private static boolean hasCommonAncestor(Activation act, Activation linkedAct) {
        long v = act.getNewVisitedId();
        AncestorRelation.markAncestors(linkedAct, v);
        return AncestorRelation.hasCommonAncestor(act, v, act.getNewVisitedId());
    }

    private static void markAncestors(Activation act, long v) {
        if (!act.checkVisited(v)) {
            return;
        }
        act.markedAncDesc = v;
        act.getInputLinks(false).filter(l -> l.isIdentity()).forEach(l -> AncestorRelation.markAncestors(l.getInput(), v));
    }

    private static void markDescendants(Activation act, long v) {
        if (!act.checkVisited(v)) {
            return;
        }
        act.markedAncDesc = v;
        act.getOutputLinks().filter(l -> l.isIdentity()).forEach(l -> AncestorRelation.markDescendants(l.getInput(), v));
    }

    private static boolean hasCommonAncestor(Activation act, long v1, long v2) {
        if (!act.checkVisited(v2)) {
            return false;
        }
        if (act.markedAncDesc == v1) {
            return true;
        }
        return act.getInputLinks(false).filter(l -> l.isIdentity()).anyMatch(l -> AncestorRelation.hasCommonAncestor(l.getInput(), v1, v2));
    }

    @Override
    public boolean isExact() {
        return false;
    }

    public static class NotAncestorOf
    extends AncestorRelation {
        public static int TYPE = 54;

        public NotAncestorOf() {
        }

        public NotAncestorOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new NotDescendantOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new NotAncestorOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return !AncestorRelation.contains(linkedAct, act, act.getNewVisitedId());
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            long v = linkedAct.getNewVisitedId();
            AncestorRelation.markAncestors(linkedAct, v);
            return n.getActivations(linkedAct.getDocument()).filter(act -> act.markedAncDesc != v);
        }

        public String toString() {
            return "NOT-ANCESTOR-OF";
        }

        static {
            NotAncestorOf.registerRelation(TYPE, () -> NOT_ANCESTOR_OF);
        }
    }

    public static class NotDescendantOf
    extends AncestorRelation {
        public static int TYPE = 53;

        public NotDescendantOf() {
        }

        public NotDescendantOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new NotAncestorOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new NotDescendantOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return !AncestorRelation.contains(act, linkedAct, act.getNewVisitedId());
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            long v = linkedAct.getNewVisitedId();
            AncestorRelation.markDescendants(linkedAct, v);
            return n.getActivations(linkedAct.getDocument()).filter(act -> act.markedAncDesc != v);
        }

        public String toString() {
            return "NOT-DESCENDANT-OF";
        }

        static {
            NotDescendantOf.registerRelation(TYPE, () -> NOT_DESCENDANT_OF);
        }
    }

    public static class IsAncestorOf
    extends AncestorRelation {
        public static int TYPE = 52;

        public IsAncestorOf() {
        }

        public IsAncestorOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new IsDescendantOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new IsAncestorOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return AncestorRelation.contains(linkedAct, act, act.getNewVisitedId());
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            ArrayList<Activation> results = new ArrayList<Activation>();
            AncestorRelation.collectContainedIn(results, n, linkedAct, linkedAct.getNewVisitedId());
            return results.stream();
        }

        public String toString() {
            return "ANCESTOR-OF";
        }

        static {
            IsAncestorOf.registerRelation(TYPE, () -> IS_ANCESTOR_OF);
        }
    }

    public static class IsDescendantOf
    extends AncestorRelation {
        public static int TYPE = 51;

        public IsDescendantOf() {
        }

        public IsDescendantOf(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new IsAncestorOf(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new IsDescendantOf(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return AncestorRelation.contains(act, linkedAct, act.getNewVisitedId());
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            ArrayList<Activation> results = new ArrayList<Activation>();
            AncestorRelation.collectContains(results, n, linkedAct, linkedAct.getNewVisitedId());
            return results.stream();
        }

        public String toString() {
            return "DESCENDANT-OF";
        }

        static {
            IsDescendantOf.registerRelation(TYPE, () -> IS_DESCENDANT_OF);
        }
    }

    public static class CommonAncestor
    extends AncestorRelation {
        public static int TYPE = 50;

        public CommonAncestor() {
        }

        public CommonAncestor(boolean optional, boolean follow) {
            this.optional = optional;
            this.follow = follow;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new CommonAncestor(this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new CommonAncestor(optional, follow);
        }

        @Override
        public boolean test(Activation act, Activation linkedAct) {
            return AncestorRelation.hasCommonAncestor(act, linkedAct);
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            if (!this.follow) {
                return Stream.empty();
            }
            ArrayList<Activation> results = new ArrayList<Activation>();
            AncestorRelation.collectCommonAncestor(results, n, linkedAct, linkedAct.getNewVisitedId());
            return results.stream();
        }

        public String toString() {
            return "COMMON-ANCESTOR";
        }

        static {
            CommonAncestor.registerRelation(TYPE, () -> COMMON_ANCESTOR);
        }
    }
}

