/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class MultiRelation
extends Relation {
    public static final int ID = 1;
    private List<Relation> relations;

    public MultiRelation() {
        this.relations = new ArrayList<Relation>();
    }

    public MultiRelation(boolean optional, boolean follow, List<Relation> relations) {
        super(optional, follow);
        this.relations = relations;
    }

    public MultiRelation(Relation ... rels) {
        this.relations = Arrays.asList(rels);
    }

    public MultiRelation(List<Relation> rels) {
        this.relations = rels;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct) {
        for (Relation rel : this.relations) {
            if (rel.test(act, linkedAct)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Relation invert() {
        ArrayList<Relation> invRels = new ArrayList<Relation>();
        for (Relation rel : this.relations) {
            invRels.add(rel.invert());
        }
        return new MultiRelation(this.optional, this.follow, invRels);
    }

    @Override
    public Relation setOptionalAndFollow(boolean optional, boolean follow) {
        return new MultiRelation(optional, follow, this.relations);
    }

    @Override
    public void mapSlots(Map<Integer, Position> slots, Activation act) {
        for (Relation rel : this.relations) {
            rel.mapSlots(slots, act);
        }
    }

    @Override
    public void linksOutputs(Set<Integer> results) {
        for (Relation rel : this.relations) {
            rel.linksOutputs(results);
        }
    }

    @Override
    public boolean isExact() {
        for (Relation rel : this.relations) {
            if (!rel.isExact()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
        if (!this.follow) {
            return Stream.empty();
        }
        if (this.relations.isEmpty()) {
            return n.getActivations(linkedAct.getDocument());
        }
        return this.relations.stream().flatMap(r -> r.getActivations(n, linkedAct)).filter(act -> {
            for (Relation rel : this.relations) {
                if (rel.test((Activation)act, linkedAct)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public boolean isConvertible() {
        for (Relation rel : this.relations) {
            if (!rel.isConvertible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerRequiredSlots(Neuron input) {
        for (Relation rel : this.relations) {
            rel.registerRequiredSlots(input);
        }
    }

    @Override
    public int compareTo(Relation rel) {
        int r = super.compareTo(rel);
        if (r != 0) {
            return r;
        }
        MultiRelation mr = (MultiRelation)rel;
        r = Integer.compare(this.relations.size(), mr.relations.size());
        if (r != 0) {
            return r;
        }
        for (int i = 0; i < this.relations.size(); ++i) {
            Relation b;
            Relation a = this.relations.get(i);
            r = a.compareTo(b = mr.relations.get(i));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.relations.size());
        for (Relation rel : this.relations) {
            rel.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            this.relations.add(Relation.read(in, m));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MULTI(");
        boolean first = true;
        for (Relation rel : this.relations) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(rel.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        MultiRelation.registerRelation(1, () -> new MultiRelation());
    }
}

