/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

public enum ActivationFunction {
    RECTIFIED_SCALED_LOGISTIC_SIGMOID(x -> Math.max(0.0, 2.0 * ActivationFunction.sigmoid(x) - 1.0)),
    RECTIFIED_HYPERBOLIC_TANGENT(x -> Math.max(0.0, Math.tanh(x))),
    RECTIFIED_LINEAR_UNIT(x -> Math.max(0.0, x)),
    LIMITED_RECTIFIED_LINEAR_UNIT(x -> Math.max(0.0, Math.min(1.0, x)));

    Function f;

    private ActivationFunction(Function f) {
        this.f = f;
    }

    public double f(double x) {
        return this.f.f(x);
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.pow(Math.E, -x));
    }

    static interface Function {
        public double f(double var1);
    }
}

