/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import network.aika.AbstractNode;
import network.aika.Document;
import network.aika.Model;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.lattice.AndNode;
import network.aika.lattice.InputNode;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.OrNode;

public abstract class Node<T extends Node, A extends NodeActivation<T>>
extends AbstractNode<Provider<T>>
implements Comparable<Node> {
    public static final Node MIN_NODE = new InputNode();
    public static final Node MAX_NODE = new InputNode();
    TreeMap<AndNode.Refinement, AndNode.RefValue> andChildren;
    TreeSet<OrNode.OrEntry> orChildren;
    int level;
    private AtomicInteger numberOfNeuronRefs = new AtomicInteger(0);
    volatile boolean isRemoved;
    protected ReadWriteLock lock = new ReadWriteLock();
    private ThreadState<A>[] threads;
    long markedCreated;

    protected abstract void propagate(A var1);

    private ThreadState<A> getThreadState(int threadId, boolean create) {
        ThreadState<A> th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState();
        }
        th.lastUsed = this.provider.model.docIdCounter.get();
        return th;
    }

    public void clearThreadState(int threadId, int deleteDocId) {
        ThreadState<A> th = this.threads[threadId];
        if (th != null && th.lastUsed < (long)deleteDocId) {
            this.threads[threadId] = null;
        }
    }

    abstract AndNode.RefValue expand(int var1, Document var2, AndNode.Refinement var3);

    public abstract void reprocessInputs(Document var1);

    public abstract void cleanup();

    public abstract String logicToString();

    protected Node() {
    }

    public Node(Model m, int level) {
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Provider<Node>(m, this);
        this.level = level;
        this.setModified();
    }

    public void postCreate(Document doc) {
        if (doc != null) {
            this.markedCreated = doc.createV;
            doc.addedNodes.add(this);
        }
    }

    void addOrChild(OrNode.OrEntry rv) {
        this.lock.acquireWriteLock();
        if (this.orChildren == null) {
            this.orChildren = new TreeSet();
        }
        this.orChildren.add(rv);
        this.lock.releaseWriteLock();
    }

    void removeOrChild(OrNode.OrEntry rv) {
        this.lock.acquireWriteLock();
        if (this.orChildren != null) {
            this.orChildren.remove(rv);
            if (this.orChildren.isEmpty()) {
                this.orChildren = null;
            }
        }
        this.lock.releaseWriteLock();
    }

    void addAndChild(AndNode.Refinement ref, AndNode.RefValue child) {
        if (this.andChildren == null) {
            this.andChildren = new TreeMap();
        }
        if (!this.andChildren.containsKey(ref)) {
            this.andChildren.put(ref, child);
        }
    }

    void removeAndChild(AndNode.Refinement ref) {
        if (this.andChildren != null) {
            this.andChildren.remove(ref);
            if (this.andChildren.isEmpty()) {
                this.andChildren = null;
            }
        }
    }

    void processActivation(A act) {
        this.register(act);
        this.propagate(act);
    }

    public void register(A act) {
        if (((NodeActivation)act).registered) {
            return;
        }
        Document doc = ((NodeActivation)act).getDocument();
        assert (((NodeActivation)act).getNode() == this);
        ThreadState<A> th = this.getThreadState(doc.getThreadId(), true);
        if (th.doc == null) {
            th.doc = doc;
            doc.addActivatedNode((Node)((NodeActivation)act).getNode());
        }
        if (th.doc != doc) {
            throw new Model.StaleDocumentException();
        }
        th.activations.add(act);
        doc.addedNodeActivations.add((NodeActivation)act);
        ((NodeActivation)act).registered = true;
    }

    public void clearActivations(Document doc) {
        this.clearActivations(doc.getThreadId());
    }

    public void clearActivations(int threadId) {
        ThreadState<A> th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.activations.clear();
        th.added.clear();
        th.doc = null;
    }

    public void clearActivations() {
        for (int i = 0; i < this.provider.model.numberOfThreads; ++i) {
            this.clearActivations(i);
        }
    }

    public void processChanges(Document doc) {
        ThreadState<A> th = this.getThreadState(doc.getThreadId(), true);
        List tmpAdded = th.added;
        th.added = new ArrayList();
        tmpAdded.forEach(act -> this.processActivation(act));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void propagateToOrNode(NodeActivation inputAct) {
        Document doc = inputAct.getDocument();
        try {
            this.lock.acquireReadLock();
            if (this.orChildren != null) {
                for (OrNode.OrEntry oe : this.orChildren) {
                    oe.child.get(doc).addActivation(oe, inputAct);
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void addActivation(A act) {
        ThreadState<A> th = this.getThreadState(((NodeActivation)act).getThreadId(), true);
        if (th.doc == null) {
            th.doc = ((NodeActivation)act).doc;
            ((NodeActivation)act).doc.addActivatedNode((Node)((NodeActivation)act).getNode());
        }
        if (th.doc != ((NodeActivation)act).doc) {
            throw new Model.StaleDocumentException();
        }
        th.added.add(act);
        ((NodeActivation)act).getDocument().getNodeQueue().add(this);
    }

    public void remove() {
        assert (!this.isRemoved);
        this.lock.acquireWriteLock();
        this.setModified();
        while (this.andChildren != null && !this.andChildren.isEmpty()) {
            this.andChildren.firstEntry().getValue().child.get().remove();
        }
        while (this.orChildren != null && !this.orChildren.isEmpty()) {
            this.orChildren.pollFirst().child.get().remove();
        }
        this.lock.releaseWriteLock();
        this.isRemoved = true;
    }

    AndNode.RefValue getAndChild(AndNode.Refinement ref) {
        this.lock.acquireReadLock();
        AndNode.RefValue result = this.andChildren != null ? this.andChildren.get(ref) : null;
        this.lock.releaseReadLock();
        return result;
    }

    public boolean isRequired() {
        return this.numberOfNeuronRefs.get() > 0;
    }

    protected void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        ThreadState<A> th = this.getThreadState(threadId, true);
        if (th.visited == v) {
            return;
        }
        th.visited = v;
        this.numberOfNeuronRefs.addAndGet(d);
    }

    public Collection<A> getActivations(Document doc) {
        ThreadState<A> th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        return th.activations;
    }

    public String getNeuronLabel() {
        return "";
    }

    public boolean isQueued(int threadId, long queueId) {
        ThreadState<A> th = this.getThreadState(threadId, true);
        if (!th.isQueued) {
            th.isQueued = true;
            th.queueId = queueId;
        }
        return false;
    }

    public void setNotQueued(int threadId) {
        ThreadState<A> th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.isQueued = false;
    }

    public static int compareRank(int threadId, Node n1, Node n2) {
        int r = Integer.compare(n1.level, n2.level);
        if (r != 0) {
            return r;
        }
        ThreadState th1 = n1.getThreadState(threadId, true);
        ThreadState th2 = n2.getThreadState(threadId, true);
        return Long.compare(th1.queueId, th2.queueId);
    }

    public String toString() {
        if (this == MIN_NODE) {
            return "MIN_NODE";
        }
        if (this == MAX_NODE) {
            return "MAX_NODE";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNeuronLabel());
        sb.append(" - ");
        sb.append(this.logicToString());
        return sb.toString();
    }

    @Override
    public int compareTo(Node n) {
        if (this == n) {
            return 0;
        }
        if (this == MIN_NODE) {
            return -1;
        }
        if (n == MIN_NODE) {
            return 1;
        }
        if (this == MAX_NODE) {
            return 1;
        }
        if (n == MAX_NODE) {
            return -1;
        }
        return this.provider.compareTo(n.provider);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.level);
        out.writeInt(this.numberOfNeuronRefs.get());
        if (this.andChildren != null) {
            out.writeInt(this.andChildren.size());
            for (Map.Entry<AndNode.Refinement, AndNode.RefValue> me : this.andChildren.entrySet()) {
                me.getKey().write(out);
                me.getValue().write(out);
            }
        } else {
            out.writeInt(0);
        }
        if (this.orChildren != null) {
            out.writeInt(this.orChildren.size());
            for (OrNode.OrEntry oe : this.orChildren) {
                oe.write(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int i;
        this.level = in.readInt();
        this.numberOfNeuronRefs.set(in.readInt());
        int s = in.readInt();
        for (i = 0; i < s; ++i) {
            this.addAndChild(AndNode.Refinement.read(in, m), AndNode.RefValue.read(in, m));
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            if (this.orChildren == null) {
                this.orChildren = new TreeSet();
            }
            this.orChildren.add(OrNode.OrEntry.read(in, m));
        }
        this.threads = new ThreadState[m.numberOfThreads];
    }

    public static Node readNode(DataInput in, Provider p) throws IOException {
        char type = in.readChar();
        Node n = null;
        switch (type) {
            case 'I': {
                n = new InputNode();
                break;
            }
            case 'A': {
                n = new AndNode();
                break;
            }
            case 'O': {
                n = new OrNode();
            }
        }
        n.provider = p;
        n.readFields(in, p.model);
        return n;
    }

    private static class ThreadState<A extends NodeActivation> {
        public long lastUsed;
        public Document doc;
        public List<A> added = new ArrayList<A>();
        public List<A> activations = new ArrayList<A>();
        public long visited;
        public boolean isQueued = false;
        public long queueId;
    }
}

