/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import network.aika.ActivationFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.PassiveInputFunction;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.lattice.Converter;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class Neuron
extends Provider<INeuron> {
    public static final Neuron MIN_NEURON = new Neuron(null, Integer.MIN_VALUE);
    public static final Neuron MAX_NEURON = new Neuron(null, Integer.MAX_VALUE);
    ReadWriteLock lock = new ReadWriteLock();
    NavigableMap<Integer, Synapse> inputSynapsesById = new TreeMap<Integer, Synapse>();
    NavigableMap<Synapse, Synapse> inMemoryInputSynapses = new TreeMap<Synapse, Synapse>(Synapse.INPUT_SYNAPSE_COMP);
    NavigableMap<Synapse, Synapse> inMemoryOutputSynapses = new TreeMap<Synapse, Synapse>(Synapse.OUTPUT_SYNAPSE_COMP);

    public Neuron(Model m, int id) {
        super(m, id);
    }

    public Neuron(Model m, INeuron n) {
        super(m, n);
    }

    public String getLabel() {
        return ((INeuron)this.get()).getLabel();
    }

    public Activation addInput(Document doc, int begin, int end) {
        return this.addInput(doc, new Activation.Builder().setRange(begin, end));
    }

    public Activation addInput(Document doc, Activation.Builder inputAct) {
        return ((INeuron)this.get(doc)).addInput(doc, inputAct);
    }

    public static Neuron init(Neuron n, Builder ... inputs) {
        return Neuron.init(null, n, inputs);
    }

    public static Neuron init(Document doc, Neuron n, Builder ... inputs) {
        if (n.init(doc, null, null, null, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs))) {
            return n;
        }
        return null;
    }

    public static Neuron init(Neuron n, double bias, INeuron.Type type, Builder ... inputs) {
        return Neuron.init(n, bias, type, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs));
    }

    public static Neuron init(Document doc, Neuron n, double bias, INeuron.Type type, Builder ... inputs) {
        return Neuron.init(doc, n, bias, null, type, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs));
    }

    public static Neuron init(Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, Builder ... inputs) {
        return Neuron.init(n, bias, activationFunction, type, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs));
    }

    public static Neuron init(Document doc, Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, Builder ... inputs) {
        return Neuron.init(doc, n, bias, activationFunction, type, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs));
    }

    public static Neuron init(Neuron n, double bias, INeuron.Type type, Collection<Synapse.Builder> synapseBuilders, Collection<Relation.Builder> relationBuilders) {
        return Neuron.init(n, bias, null, type, synapseBuilders, relationBuilders);
    }

    public static Neuron init(Neuron n, double bias, INeuron.Type type, Collection<Builder> inputs) {
        return Neuron.init(n, bias, null, type, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs));
    }

    public static Neuron init(Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, Collection<Synapse.Builder> synapseBuilders, Collection<Relation.Builder> relationBuilders) {
        if (n.init(null, bias, activationFunction, type, synapseBuilders, relationBuilders)) {
            return n;
        }
        return null;
    }

    public static Neuron init(Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, Collection<Builder> inputs) {
        if (n.init(null, bias, activationFunction, type, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs))) {
            return n;
        }
        return null;
    }

    public static Neuron init(Document doc, Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, Collection<Synapse.Builder> synapseBuilders, Collection<Relation.Builder> relationBuilders) {
        if (n.init(doc, bias, activationFunction, type, synapseBuilders, relationBuilders)) {
            return n;
        }
        return null;
    }

    public static Neuron init(Document doc, Neuron n, double bias, ActivationFunction activationFunction, INeuron.Type type, Collection<Builder> inputs) {
        if (n.init(doc, bias, activationFunction, type, Neuron.getSynapseBuilders(inputs), Neuron.getRelationBuilders(inputs))) {
            return n;
        }
        return null;
    }

    private boolean init(Document doc, Double bias, ActivationFunction activationFunction, INeuron.Type type, Collection<Synapse.Builder> synapseBuilders, Collection<Relation.Builder> relationBuilders) {
        INeuron n = (INeuron)this.get();
        if (activationFunction != null) {
            n.activationFunction = activationFunction;
        }
        if (type != null) {
            n.type = type;
        }
        if (bias != null) {
            n.setBias(bias);
        }
        ArrayList<Synapse> modifiedSynapses = new ArrayList<Synapse>();
        synapseBuilders.forEach(input -> {
            Synapse s = input.getSynapse(this);
            s.update(doc, input.weight, input.bias, input.limit);
            modifiedSynapses.add(s);
        });
        modifiedSynapses.forEach(s -> s.link());
        relationBuilders.forEach(input -> input.connect(this));
        n.commit(modifiedSynapses);
        return Converter.convert(this.model.defaultThreadId, doc, n, modifiedSynapses);
    }

    public PassiveInputFunction getPassiveInputFunction() {
        return ((INeuron)this.get()).passiveInputFunction;
    }

    public void setPassiveInputFunction(PassiveInputFunction f) {
        ((INeuron)this.get()).passiveInputFunction = f;
        this.model.passiveActivationFunctions.put(this.id, f);
        for (Synapse s : ((INeuron)this.get()).outputSynapses.values()) {
            ((INeuron)s.getOutput().get()).registerPassiveInputSynapse(s);
        }
    }

    public void setOutputText(String outputText) {
        ((INeuron)this.get()).setOutputText(outputText);
    }

    public Synapse getSynapseById(int synapseId) {
        return (Synapse)this.inputSynapsesById.get(synapseId);
    }

    public Stream<Activation> getActivations(Document doc, boolean onlyFinal) {
        INeuron n = (INeuron)this.getIfNotSuspended();
        if (n == null) {
            return Stream.empty();
        }
        return n.getActivations(doc, onlyFinal);
    }

    public Stream<Activation> getActivations(Document doc, int slot, Position pos, boolean onlyFinal) {
        INeuron n = (INeuron)this.getIfNotSuspended();
        if (n == null) {
            return Stream.empty();
        }
        return n.getActivations(doc, slot, pos, onlyFinal);
    }

    public Activation getActivation(Document doc, int begin, int end, boolean onlyFinal) {
        return this.getActivations(doc, Activation.BEGIN, doc.lookupFinalPosition(begin), onlyFinal).filter(act -> act.getSlot(Activation.END).getFinalPosition() == end).findFirst().orElse(null);
    }

    public Synapse selectInputSynapse(Neuron inputNeuron, Predicate<Synapse> filter) {
        this.lock.acquireWriteLock();
        Synapse synapse = this.inMemoryInputSynapses.subMap(new Synapse(inputNeuron, this, Integer.MIN_VALUE), true, new Synapse(inputNeuron, this, Integer.MAX_VALUE), true).keySet().stream().filter(filter).findAny().orElse(null);
        this.lock.releaseWriteLock();
        return synapse;
    }

    void addInMemoryInputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.put(s, s);
        this.inputSynapsesById.put(s.getId(), s);
        this.lock.releaseWriteLock();
    }

    void removeInMemoryInputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.remove(s);
        this.inputSynapsesById.remove(s.getId());
        this.lock.releaseWriteLock();
    }

    void addInMemoryOutputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.put(s, s);
        this.lock.releaseWriteLock();
    }

    void removeInMemoryOutputSynapse(Synapse s) {
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.remove(s);
        this.lock.releaseWriteLock();
    }

    @Override
    public String toString() {
        if (this == MIN_NEURON) {
            return "MIN_NEURON";
        }
        if (this == MAX_NEURON) {
            return "MAX_NEURON";
        }
        return super.toString();
    }

    public int getNewSynapseId() {
        return ((INeuron)this.get()).getNewSynapseId();
    }

    public void registerSynapseId(int synId) {
        ((INeuron)this.get()).registerSynapseId(synId);
    }

    public Collection<Synapse> getInMemoryInputSynapses() {
        return this.inMemoryInputSynapses.values();
    }

    public Collection<Synapse> getInMemoryOutputSynapses() {
        return this.inMemoryOutputSynapses.values();
    }

    private static Collection<Synapse.Builder> getSynapseBuilders(Collection<Builder> builders) {
        ArrayList<Synapse.Builder> result = new ArrayList<Synapse.Builder>();
        for (Builder b : builders) {
            if (!(b instanceof Synapse.Builder)) continue;
            result.add((Synapse.Builder)b);
        }
        return result;
    }

    private static Collection<Relation.Builder> getRelationBuilders(Collection<Builder> builders) {
        ArrayList<Relation.Builder> result = new ArrayList<Relation.Builder>();
        for (Builder b : builders) {
            if (!(b instanceof Relation.Builder)) continue;
            result.add((Relation.Builder)b);
        }
        return result;
    }

    private static Collection<Synapse.Builder> getSynapseBuilders(Builder ... builders) {
        ArrayList<Synapse.Builder> result = new ArrayList<Synapse.Builder>();
        for (Builder b : builders) {
            if (!(b instanceof Synapse.Builder)) continue;
            result.add((Synapse.Builder)b);
        }
        return result;
    }

    private static Collection<Relation.Builder> getRelationBuilders(Builder ... builders) {
        ArrayList<Relation.Builder> result = new ArrayList<Relation.Builder>();
        for (Builder b : builders) {
            if (!(b instanceof Relation.Builder)) continue;
            result.add((Relation.Builder)b);
        }
        return result;
    }

    public static interface Builder {
        public void registerSynapseIds(Neuron var1);
    }
}

