/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.DistanceFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.relation.Relation;

public class Synapse
implements Writable {
    public static final int OUTPUT = -1;
    public static double DISJUNCTION_THRESHOLD = 0.6;
    public static double CONJUNCTION_THRESHOLD = 0.4;
    public static double TOLERANCE = 1.0E-7;
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.input.compareTo(s2.input);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.output.compareTo(s2.output);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    private Neuron input;
    private Neuron output;
    private Integer id;
    private boolean isRecurrent;
    private boolean identity;
    private Map<Integer, Relation> relations = new TreeMap<Integer, Relation>();
    private DistanceFunction distanceFunction = null;
    private Writable extension;
    private boolean inactive;
    private double weight;
    private double weightDelta;
    private double bias;
    private double biasDelta;
    private double limit = 1.0;
    private double limitDelta;
    private boolean isConjunction;
    private boolean isDisjunction;

    public Synapse() {
    }

    public Synapse(Neuron input, Neuron output, Integer id) {
        this.id = id;
        this.input = input;
        this.output = output;
        if (output.model.getSynapseExtensionFactory() != null) {
            this.extension = output.model.getSynapseExtensionFactory().createObject();
        }
    }

    public Neuron getInput() {
        return this.input;
    }

    public Neuron getOutput() {
        return this.output;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean isRecurrent() {
        return this.isRecurrent;
    }

    public void setRecurrent(boolean recurrent) {
        this.isRecurrent = recurrent;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public Map<Integer, Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(Map<Integer, Relation> relations) {
        this.relations = relations;
    }

    public DistanceFunction getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public <T extends Writable> T getExtension() {
        return (T)this.extension;
    }

    public void setExtension(Writable extension) {
        this.extension = extension;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public boolean isConjunction() {
        return this.isConjunction;
    }

    public boolean isDisjunction() {
        return this.isDisjunction;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getBias() {
        return this.bias;
    }

    public double getLimit() {
        return this.limit;
    }

    public double getNewWeight() {
        return this.weight + this.weightDelta;
    }

    public double getNewBias() {
        return this.bias + this.biasDelta;
    }

    public double getNewLimit() {
        return this.limit + this.limitDelta;
    }

    public void link() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = ((Neuron)in.getProvider()).id < ((Neuron)out.getProvider()).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        this.input.lock.acquireWriteLock();
        this.input.inMemoryOutputSynapses.put(this, this);
        this.input.lock.releaseWriteLock();
        this.output.lock.acquireWriteLock();
        this.output.inMemoryInputSynapses.put(this, this);
        this.output.inputSynapsesById.put(this.id, this);
        this.output.lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        this.isConjunction = this.isConjunction(State.NEW);
        if (this.isConjunction) {
            out.inputSynapses.put(this, this);
            out.setModified();
        }
        this.isDisjunction = this.isDisjunction(State.NEW);
        if (this.isDisjunction) {
            in.outputSynapses.put(this, this);
            in.setModified();
        }
        out.registerSynapseId(this.id);
        if (in.isPassiveInputNeuron()) {
            out.registerPassiveInputSynapse(this);
        }
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    public void relink() {
        boolean newIsDisjunction;
        boolean newIsConjunction = this.isConjunction(State.NEW);
        if (newIsConjunction != this.isConjunction) {
            INeuron in = (INeuron)this.input.get();
            INeuron out = (INeuron)this.output.get();
            boolean dir = ((Neuron)in.getProvider()).id < ((Neuron)out.getProvider()).id;
            (dir ? in : out).lock.acquireWriteLock();
            (dir ? out : in).lock.acquireWriteLock();
            this.isConjunction = newIsConjunction;
            if (this.isConjunction) {
                out.inputSynapses.put(this, this);
                out.setModified();
            } else {
                out.inputSynapses.remove(this);
                out.setModified();
            }
            (dir ? in : out).lock.releaseWriteLock();
            (dir ? out : in).lock.releaseWriteLock();
        }
        if ((newIsDisjunction = this.isDisjunction(State.NEW)) != this.isDisjunction) {
            INeuron in = (INeuron)this.input.get();
            INeuron out = (INeuron)this.output.get();
            boolean dir = ((Neuron)in.getProvider()).id < ((Neuron)out.getProvider()).id;
            (dir ? in : out).lock.acquireWriteLock();
            (dir ? out : in).lock.acquireWriteLock();
            this.isDisjunction = newIsDisjunction;
            if (this.isDisjunction) {
                in.outputSynapses.put(this, this);
                in.setModified();
            } else {
                in.outputSynapses.remove(this);
                in.setModified();
            }
            (dir ? in : out).lock.releaseWriteLock();
            (dir ? out : in).lock.releaseWriteLock();
        }
    }

    public void unlink() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = this.input.id < ((Neuron)out.getProvider()).id;
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        this.input.lock.acquireWriteLock();
        this.input.inMemoryOutputSynapses.remove(this);
        this.input.lock.releaseWriteLock();
        this.output.lock.acquireWriteLock();
        this.output.inMemoryInputSynapses.remove(this);
        this.output.inputSynapsesById.remove(this.id);
        this.output.lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    private void removeLinkInternal(INeuron in, INeuron out) {
        if (this.isConjunction(State.OLD) && out.inputSynapses.remove(this) != null) {
            out.setModified();
        }
        if (this.isDisjunction(State.OLD) && in.outputSynapses.remove(this) != null) {
            in.setModified();
        }
    }

    public double getMaxInputValue() {
        return this.limit * this.weight;
    }

    public boolean exists() {
        if (((INeuron)this.input.get()).outputSynapses.containsKey(this)) {
            return true;
        }
        return ((INeuron)this.output.get()).inputSynapses.containsKey(this);
    }

    public void commit() {
        this.weight += this.weightDelta;
        this.weightDelta = 0.0;
        this.bias += this.biasDelta;
        this.biasDelta = 0.0;
        this.limit += this.limitDelta;
        this.limitDelta = 0.0;
    }

    public boolean isZero() {
        return Math.abs(this.weight) < TOLERANCE && Math.abs(this.bias) < TOLERANCE;
    }

    public boolean isConjunction(State state) {
        double w = state == State.NEW ? (this.limit + this.limitDelta) * this.getNewWeight() : this.limit * this.weight;
        double b = state == State.NEW ? this.bias + this.biasDelta : this.bias;
        return w < 0.0 || w > 0.0 && -b / w >= CONJUNCTION_THRESHOLD;
    }

    public boolean isDisjunction(State state) {
        double w = state == State.NEW ? (this.limit + this.limitDelta) * this.getNewWeight() : this.limit * this.weight;
        double b = state == State.NEW ? this.bias + this.biasDelta : this.bias;
        return w > 0.0 && -b / w <= DISJUNCTION_THRESHOLD;
    }

    public void updateDelta(Document doc, double weightDelta, double biasDelta, double limitDelta) {
        this.weightDelta += weightDelta;
        this.biasDelta += biasDelta;
        this.limitDelta += limitDelta;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public void update(Document doc, double weight, double bias, double limit) {
        this.weightDelta = weight - this.weight;
        this.limitDelta = limit - this.limit;
        this.biasDelta = bias - this.bias;
        this.relink();
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public boolean isNegative() {
        return this.weight < 0.0;
    }

    public Relation getRelationById(Integer id) {
        return this.relations.get(id);
    }

    public String toString() {
        return "S ID:" + this.id + " NW:" + this.getNewWeight() + " NB:" + this.getNewBias() + " rec:" + this.isRecurrent + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeBoolean(this.isRecurrent);
        out.writeBoolean(this.identity);
        out.writeInt(this.input.id);
        out.writeInt(this.output.id);
        out.writeInt(this.relations.size());
        for (Map.Entry<Integer, Relation> me : this.relations.entrySet()) {
            out.writeInt(me.getKey());
            me.getValue().write(out);
        }
        out.writeBoolean(this.distanceFunction != null);
        if (this.distanceFunction != null) {
            out.writeUTF(this.distanceFunction.name());
        }
        out.writeDouble(this.weight);
        out.writeDouble(this.bias);
        out.writeDouble(this.limit);
        out.writeBoolean(this.isConjunction);
        out.writeBoolean(this.isDisjunction);
        out.writeBoolean(this.inactive);
        out.writeBoolean(this.extension != null);
        if (this.extension != null) {
            this.extension.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.id = in.readInt();
        this.isRecurrent = in.readBoolean();
        this.identity = in.readBoolean();
        this.input = m.lookupNeuron(in.readInt());
        this.output = m.lookupNeuron(in.readInt());
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            Integer relId = in.readInt();
            this.relations.put(relId, Relation.read(in, m));
        }
        if (in.readBoolean()) {
            this.distanceFunction = DistanceFunction.valueOf(in.readUTF());
        }
        this.weight = in.readDouble();
        this.bias = in.readDouble();
        this.limit = in.readDouble();
        this.isConjunction = in.readBoolean();
        this.isDisjunction = in.readBoolean();
        this.inactive = in.readBoolean();
        if (in.readBoolean()) {
            this.extension = m.getSynapseExtensionFactory().createObject();
            this.extension.readFields(in, m);
        }
    }

    public static Synapse read(DataInput in, Model m) throws IOException {
        Synapse s = new Synapse();
        s.readFields(in, m);
        return s;
    }

    public static Synapse createOrReplace(Document doc, Integer synapseId, Neuron inputNeuron, Neuron outputNeuron) {
        outputNeuron.get(doc);
        inputNeuron.get(doc);
        outputNeuron.lock.acquireWriteLock();
        Synapse synapse = (Synapse)outputNeuron.inputSynapsesById.get(synapseId);
        if (synapse != null) {
            synapse.unlink();
        }
        outputNeuron.lock.releaseWriteLock();
        if (synapse == null) {
            synapse = new Synapse(inputNeuron, outputNeuron, synapseId);
        } else {
            synapse.input = inputNeuron;
            synapse.output = outputNeuron;
        }
        if (synapseId == null) {
            synapse.id = ((INeuron)outputNeuron.get(doc)).getNewSynapseId();
        }
        synapse.link();
        return synapse;
    }

    public Set<Integer> linksOutput() {
        TreeSet<Integer> results = new TreeSet<Integer>();
        for (Map.Entry<Integer, Relation> me : this.relations.entrySet()) {
            Relation rel = me.getValue();
            if (me.getKey() != -1) continue;
            rel.linksOutputs(results);
        }
        return results;
    }

    public boolean linksAnyOutput() {
        Set<Integer> tmp = this.linksOutput();
        return !tmp.isEmpty();
    }

    public static class Builder
    implements Neuron.Builder {
        public boolean recurrent;
        public Neuron neuron;
        public double weight;
        public double bias;
        public double limit = 1.0;
        public DistanceFunction distanceFunction;
        public boolean identity;
        public Integer synapseId;

        public Builder setRecurrent(boolean recurrent) {
            this.recurrent = recurrent;
            return this;
        }

        public Builder setNeuron(Neuron neuron) {
            assert (neuron != null);
            this.neuron = neuron;
            return this;
        }

        public Builder setWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder setBias(double bias) {
            this.bias = bias;
            return this;
        }

        public Builder setLimit(double limit) {
            this.limit = limit;
            return this;
        }

        public Builder setDistanceFunction(DistanceFunction distFunc) {
            this.distanceFunction = distFunc;
            return this;
        }

        public Builder setIdentity(boolean identity) {
            this.identity = identity;
            return this;
        }

        public Builder setSynapseId(int synapseId) {
            assert (synapseId >= 0);
            this.synapseId = synapseId;
            return this;
        }

        @Override
        public void registerSynapseIds(Neuron n) {
            n.registerSynapseId(this.synapseId);
        }

        public Synapse getSynapse(Neuron outputNeuron) {
            Synapse s = Synapse.createOrReplace(null, this.synapseId, this.neuron, outputNeuron);
            s.isRecurrent = this.recurrent;
            s.identity = this.identity;
            s.distanceFunction = this.distanceFunction;
            return s;
        }
    }

    public static enum State {
        NEW,
        OLD;

    }
}

