/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.SearchNode;

public class ValueQueue {
    private final ArrayList<TreeSet<Activation>> queue = new ArrayList();
    private static Comparator<Activation> VALUE_QUEUE_COMP = (a, b) -> {
        int r = Integer.compare(a.getSequence(), b.getSequence());
        if (r != 0) {
            return r;
        }
        return Integer.compare(a.getId(), b.getId());
    };

    public void propagateActivationValue(int round, Activation act) {
        act.getOutputLinks().forEach(l -> this.add(l.isRecurrent() ? round + 1 : round, l.getOutput()));
    }

    private void add(Activation act) {
        if (act == null) {
            return;
        }
        this.add(0, act);
        act.getOutputLinks().filter(l -> l.isRecurrent()).forEach(l -> this.add(0, l.getOutput()));
    }

    public void add(int round, Activation act) {
        TreeSet<Activation> q;
        if (act.rounds.isQueued(round) || act.decision == SearchNode.Decision.UNKNOWN) {
            return;
        }
        if (round < this.queue.size()) {
            q = this.queue.get(round);
        } else {
            assert (round == this.queue.size());
            q = new TreeSet<Activation>(VALUE_QUEUE_COMP);
            this.queue.add(q);
        }
        act.rounds.setQueued(round, true);
        q.add(act);
    }

    public double process(Document doc, SearchNode sn) {
        long v = doc.getNewVisitedId();
        this.add(sn.getActivation());
        double delta = 0.0;
        for (int round = 0; round < this.queue.size(); ++round) {
            TreeSet<Activation> q = this.queue.get(round);
            while (!q.isEmpty()) {
                Activation act = q.pollFirst();
                act.rounds.setQueued(round, false);
                delta += act.process(sn, round, v);
            }
        }
        return delta;
    }
}

