/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import network.aika.Document;
import network.aika.Model;
import network.aika.Provider;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class InputNode
extends Node<InputNode, InputActivation> {
    public static int CHILD_NODE_THRESHOLD = 10;
    private Neuron inputNeuron;
    private TreeMap<AndNode.Refinement, AndNode.RefValue> nonExactAndChildren;

    public InputNode() {
    }

    public InputNode(Model m) {
        super(m, 1);
    }

    public void setInputNeuron(Neuron n) {
        this.inputNeuron = n;
    }

    @Override
    public void addActivation(Activation inputAct) {
        InputActivation act = new InputActivation(inputAct, this);
        this.addActivation(act);
    }

    @Override
    public void reprocessInputs(Document doc) {
        ((INeuron)this.inputNeuron.get(doc)).getActivations(doc, false).forEach(act -> {
            if (act.getUpperBound() > 0.0) {
                act.getINeuron().propagate((Activation)act);
            }
        });
    }

    @Override
    void addAndChild(AndNode.Refinement ref, AndNode.RefValue child) {
        super.addAndChild(ref, child);
        if (!ref.relations.isExact()) {
            if (this.nonExactAndChildren == null) {
                this.nonExactAndChildren = new TreeMap();
            }
            AndNode.RefValue n = this.nonExactAndChildren.put(ref, child);
            assert (n == null);
        }
    }

    @Override
    void removeAndChild(AndNode.Refinement ref) {
        super.removeAndChild(ref);
        if (!ref.relations.isExact() && this.nonExactAndChildren != null) {
            this.nonExactAndChildren.remove(ref);
            if (this.nonExactAndChildren.isEmpty()) {
                this.nonExactAndChildren = null;
            }
        }
    }

    @Override
    public AndNode.RefValue expand(int threadId, Document doc, AndNode.Refinement ref) {
        if (!ref.isConvertible()) {
            return null;
        }
        Relation rel = ref.relations.get(0);
        if (rel == null) {
            return null;
        }
        AndNode.RefValue rv = this.getAndChild(ref);
        if (rv != null) {
            return rv;
        }
        ArrayList<AndNode.Entry> nlParents = new ArrayList<AndNode.Entry>();
        AndNode.Refinement mirrorRef = new AndNode.Refinement(new AndNode.RelationsMap(new Relation[]{rel.invert()}), this.provider);
        nlParents.add(new AndNode.Entry(mirrorRef, new AndNode.RefValue(new Integer[]{1}, 0, ref.input)));
        rv = new AndNode.RefValue(new Integer[]{0}, 1, this.provider);
        nlParents.add(new AndNode.Entry(ref, rv));
        return AndNode.createAndNode(this.provider.getModel(), doc, nlParents, this.level + 1) ? rv : null;
    }

    @Override
    protected void propagate(InputActivation act) {
        try {
            this.lock.acquireReadLock();
            if (this.andChildren != null) {
                TreeMap children;
                if (this.andChildren.size() > CHILD_NODE_THRESHOLD) {
                    children = this.nonExactAndChildren;
                    this.propagateWithExactRelations(act);
                } else {
                    children = this.andChildren;
                }
                if (children != null) {
                    children.forEach((ref, rv) -> {
                        InputNode in = ref.input.getIfNotSuspended();
                        if (in != null) {
                            in.addNextLevelActivations((AndNode.Refinement)ref, rv.child.get(act.getDocument()), act);
                        }
                    });
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        this.propagateToOrNode(act);
    }

    private void propagateWithExactRelations(InputActivation act) {
        Activation iAct = act.input;
        Document doc = act.getDocument();
        for (Map.Entry<Integer, Position> me : iAct.getSlots().entrySet()) {
            for (Activation linkedAct : act.getDocument().getActivationsByPosition(me.getValue(), true, me.getValue(), true)) {
                Provider<InputNode> in = linkedAct.getINeuron().getOutputNode();
                for (Map.Entry mea : this.andChildren.subMap(new AndNode.Refinement(AndNode.RelationsMap.MIN, in), new AndNode.Refinement(AndNode.RelationsMap.MAX, in)).entrySet()) {
                    in.get(doc).addNextLevelActivations(mea.getKey(), ((AndNode.RefValue)mea.getValue()).child.get(doc), act);
                }
            }
        }
    }

    private void addNextLevelActivations(AndNode.Refinement ref, AndNode nln, InputActivation act) {
        Document doc = act.getDocument();
        if (((INeuron)this.inputNeuron.get()).isEmpty(doc)) {
            return;
        }
        Activation iAct = act.input;
        if (act.repropagateV != null && act.repropagateV != nln.markedCreated) {
            return;
        }
        ref.relations.get(0).getActivations((INeuron)this.inputNeuron.get(doc), iAct).filter(secondIAct -> secondIAct.getOutputNodeActivation() != null).map(secondIAct -> secondIAct.getOutputNodeActivation()).filter(secondAct -> secondAct != null && secondAct.registered).forEach(secondAct -> {
            AndNode.AndActivation oAct = new AndNode.AndActivation(doc, nln);
            for (AndNode.Entry e : nln.parents) {
                boolean match = e.ref.compareTo(ref) == 0;
                oAct.link(e.ref, e.rv, match ? secondAct : act, match ? act : secondAct);
            }
            nln.addActivation(oAct);
        });
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        sb.append("[");
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.getId());
            if (this.inputNeuron.getLabel() != null) {
                sb.append(",");
                sb.append(this.inputNeuron.getLabel());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(73);
        super.write(out);
        out.writeBoolean(this.inputNeuron != null);
        if (this.inputNeuron != null) {
            out.writeInt(this.inputNeuron.getId());
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        if (in.readBoolean()) {
            this.inputNeuron = m.lookupNeuron(in.readInt());
        }
    }

    public static class InputActivation
    extends NodeActivation<InputNode> {
        public Activation input;

        public InputActivation(Activation iAct, InputNode node) {
            super(iAct.getDocument(), node);
            this.input = iAct;
            iAct.setOutputNodeActivation(this);
        }

        @Override
        public Activation getInputActivation(int i) {
            assert (i == 0);
            return this.input;
        }

        public String toString() {
            return "I-ACT(" + this.input.getLabel() + " " + this.input.slotsToString() + ")";
        }
    }
}

