/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.util.TreeMap;
import network.aika.Document;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.OrNode;
import network.aika.neuron.activation.Activation;

public abstract class NodeActivation<T extends Node>
implements Comparable<NodeActivation<T>> {
    public final int id;
    private final T node;
    protected final Document doc;
    Long repropagateV;
    public boolean registered;
    TreeMap<Integer, AndNode.Link> outputsToAndNode = new TreeMap();
    TreeMap<Integer, OrNode.Link> outputsToOrNode = new TreeMap();

    public NodeActivation(Document doc, T node) {
        this.id = doc.getNewNodeActivationId();
        this.doc = doc;
        this.node = node;
    }

    public T getNode() {
        return this.node;
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getThreadId() {
        return this.doc.getThreadId();
    }

    public abstract Activation getInputActivation(int var1);

    @Override
    public int compareTo(NodeActivation<T> act) {
        return Integer.compare(this.id, act.id);
    }
}

