/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import network.aika.Document;
import network.aika.Model;
import network.aika.Provider;
import network.aika.Writable;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Linker;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrNode
extends Node<OrNode, OrActivation> {
    private static final Logger log = LoggerFactory.getLogger(OrNode.class);
    TreeSet<OrEntry> andParents = new TreeSet();
    private Neuron outputNeuron = null;

    public OrNode() {
    }

    public OrNode(Model m) {
        super(m, -1);
    }

    @Override
    public AndNode.RefValue expand(int threadId, Document doc, AndNode.Refinement ref) {
        throw new UnsupportedOperationException();
    }

    protected void addActivation(OrEntry oe, NodeActivation inputAct) {
        OrActivation orAct;
        Link ol = new Link(oe, inputAct);
        Document doc = inputAct.getDocument();
        INeuron n = (INeuron)this.outputNeuron.get(doc);
        Activation act = this.lookupActivation(ol, l -> {
            Synapse s = l.getSynapse();
            if (!s.isIdentity()) {
                return true;
            }
            Integer i = oe.revSynapseIds.get(s.getId());
            Activation iAct = doc.getLinker().computeInputActivation(s, inputAct.getInputActivation(i));
            return i != null && l.getInput() == iAct;
        });
        if (act == null) {
            orAct = new OrActivation(doc, this);
            this.register(orAct);
            act = new Activation(doc, n, this.getSlots(oe, inputAct));
            act.setInputNodeActivation(orAct);
            orAct.setOutputAct(act);
        }
        orAct = act.getInputNodeActivation();
        this.propagate(orAct);
        orAct.link(ol);
        ol.linkOutputActivation(act);
    }

    private Activation lookupActivation(Link ol, Predicate<Activation.Link> filter) {
        for (Activation.Link l : ol.getInputLinks(this.outputNeuron)) {
            Synapse syn = l.getSynapse();
            Map<Integer, Relation> rels = syn.getRelations();
            for (Map.Entry<Integer, Relation> me : rels.entrySet()) {
                Integer relSynId = me.getKey();
                Relation rel = me.getValue();
                Activation existingAct = null;
                if (relSynId != -1) {
                    Synapse s = this.outputNeuron.getSynapseById(relSynId);
                    if (s != null) {
                        existingAct = rel.invert().getActivations((INeuron)s.getInput().get(), l.getInput()).flatMap(act -> act.getOutputLinksBySynapse(s)).map(rl -> rl.getOutput()).findFirst().orElse(null);
                    }
                } else {
                    existingAct = rel.invert().getActivations((INeuron)this.outputNeuron.get(), l.getInput()).findFirst().orElse(null);
                }
                if (existingAct == null || !existingAct.match(filter)) continue;
                return existingAct;
            }
        }
        return null;
    }

    private SortedMap<Integer, Position> getSlots(OrEntry oe, NodeActivation inputAct) {
        TreeMap<Integer, Position> slots = new TreeMap<Integer, Position>();
        for (int i = 0; i < oe.synapseIds.length; ++i) {
            int synapseId = oe.synapseIds[i];
            Synapse s = this.outputNeuron.getSynapseById(synapseId);
            for (Map.Entry<Integer, Relation> me : s.getRelations().entrySet()) {
                Relation rel = me.getValue();
                if (me.getKey() != -1) continue;
                Activation iAct = inputAct.getInputActivation(i);
                rel.mapSlots(slots, iAct);
            }
        }
        return slots;
    }

    @Override
    protected void propagate(OrActivation act) {
        act.getDocument().getUpperBoundQueue().add(act.getOutputAct());
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reprocessInputs(Document doc) {
        for (OrEntry oe : this.andParents) {
            Node pn = oe.parent.get();
            for (NodeActivation act : pn.getActivations(doc)) {
                act.repropagateV = this.markedCreated;
                ((Node)act.getNode()).propagate((NodeActivation)act);
            }
        }
    }

    void addInput(int[] synapseIds, int threadId, Node in, boolean andMode) {
        this.provider.getModel();
        in.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), 1);
        OrEntry oe = new OrEntry(synapseIds, (Provider<? extends Node>)in.getProvider(), this.provider);
        in.addOrChild(oe);
        in.setModified();
        if (andMode) {
            this.lock.acquireWriteLock();
            this.setModified();
            this.andParents.add(oe);
            this.lock.releaseWriteLock();
        }
    }

    void remove(int threadId) {
        ((INeuron)this.outputNeuron.get()).remove();
        super.remove();
        try {
            this.lock.acquireReadLock();
            this.removeParents(threadId);
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    void removeParents(int threadId) {
        for (OrEntry oe : this.andParents) {
            Node pn = oe.parent.get();
            this.provider.getModel();
            pn.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), -1);
            pn.removeOrChild(oe);
            pn.setModified();
        }
        this.andParents.clear();
    }

    @Override
    protected void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        for (OrEntry oe : this.andParents) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(oe.parent.get().logicToString());
            if (i > 2) {
                sb.append(",...");
                break;
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(79);
        super.write(out);
        out.writeInt(this.outputNeuron.getId());
        out.writeInt(this.andParents.size());
        for (OrEntry oe : this.andParents) {
            oe.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.outputNeuron = m.lookupNeuron(in.readInt());
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            this.andParents.add(OrEntry.read(in, m));
        }
    }

    @Override
    public String getNeuronLabel() {
        String l = this.outputNeuron.getLabel();
        return l != null ? l : "";
    }

    public void setOutputNeuron(Neuron n) {
        this.outputNeuron = n;
    }

    public Neuron getOutputNeuron() {
        return this.outputNeuron;
    }

    protected static class Link {
        public OrEntry oe;
        private NodeActivation<?> input;
        private OrActivation output;

        public Link(OrEntry oe, NodeActivation<?> input) {
            this.oe = oe;
            this.input = input;
        }

        public int size() {
            return this.oe.synapseIds.length;
        }

        public int get(int i) {
            return this.oe.synapseIds[i];
        }

        void linkOutputActivation(Activation act) {
            Linker l = act.getDocument().getLinker();
            for (int i = 0; i < this.size(); ++i) {
                int synId = this.get(i);
                Synapse s = act.getSynapseById(synId);
                Activation iAct = this.input.getInputActivation(i);
                l.link(s, iAct, act);
            }
            l.process();
        }

        Collection<Activation.Link> getInputLinks(Neuron n) {
            ArrayList<Activation.Link> inputActs = new ArrayList<Activation.Link>();
            for (int i = 0; i < this.size(); ++i) {
                int synId = this.get(i);
                Synapse s = n.getSynapseById(synId);
                Activation iAct = this.input.getInputActivation(i);
                inputActs.add(new Activation.Link(s, iAct, null));
            }
            return inputActs;
        }

        public void setOutput(OrActivation output) {
            this.output = output;
        }
    }

    public static class OrActivation
    extends NodeActivation<OrNode> {
        private Map<Integer, Link> orInputs = new TreeMap<Integer, Link>();
        private Activation outputAct;

        public OrActivation(Document doc, OrNode node) {
            super(doc, node);
        }

        public Activation getOutputAct() {
            return this.outputAct;
        }

        public void setOutputAct(Activation outputAct) {
            this.outputAct = outputAct;
        }

        @Override
        public Activation getInputActivation(int i) {
            throw new UnsupportedOperationException();
        }

        public void link(Link l) {
            l.setOutput(this);
            this.orInputs.put(l.input.id, l);
            l.input.outputsToOrNode.put(this.id, l);
        }
    }

    static class OrEntry
    implements Comparable<OrEntry>,
    Writable {
        int[] synapseIds;
        TreeMap<Integer, Integer> revSynapseIds = new TreeMap();
        Provider<? extends Node> parent;
        Provider<OrNode> child;

        private OrEntry() {
        }

        public OrEntry(int[] synapseIds, Provider<? extends Node> parent, Provider<OrNode> child) {
            this.synapseIds = synapseIds;
            for (int ofs = 0; ofs < synapseIds.length; ++ofs) {
                this.revSynapseIds.put(synapseIds[ofs], ofs);
            }
            this.parent = parent;
            this.child = child;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeInt(this.synapseIds.length);
            for (int i = 0; i < this.synapseIds.length; ++i) {
                Integer ofs = this.synapseIds[i];
                out.writeBoolean(ofs != null);
                out.writeInt(ofs);
            }
            out.writeInt(this.parent.getId());
            out.writeInt(this.child.getId());
        }

        public static OrEntry read(DataInput in, Model m) throws IOException {
            OrEntry rv = new OrEntry();
            rv.readFields(in, m);
            return rv;
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            int l = in.readInt();
            this.synapseIds = new int[l];
            for (int i = 0; i < l; ++i) {
                if (!in.readBoolean()) continue;
                Integer ofs = in.readInt();
                this.synapseIds[i] = ofs;
                this.revSynapseIds.put(ofs, i);
            }
            this.parent = m.lookupNodeProvider(in.readInt());
            this.child = m.lookupNodeProvider(in.readInt());
        }

        @Override
        public int compareTo(OrEntry oe) {
            int r = this.child.compareTo(oe.child);
            if (r != 0) {
                return r;
            }
            r = this.parent.compareTo(oe.parent);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.synapseIds.length, oe.synapseIds.length);
            if (r != 0) {
                return r;
            }
            for (int i = 0; i < this.synapseIds.length; ++i) {
                r = Integer.compare(this.synapseIds[i], oe.synapseIds[i]);
                if (r == 0) continue;
                return r;
            }
            return 0;
        }
    }
}

