/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import network.aika.AbstractNode;
import network.aika.ActivationFunction;
import network.aika.Document;
import network.aika.Model;
import network.aika.PassiveInputFunction;
import network.aika.Provider;
import network.aika.ReadWriteLock;
import network.aika.Utils;
import network.aika.Writable;
import network.aika.lattice.InputNode;
import network.aika.lattice.OrNode;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INeuron
extends AbstractNode<Neuron>
implements Comparable<INeuron> {
    private static final Logger log = LoggerFactory.getLogger(INeuron.class);
    public static boolean ALLOW_WEAK_NEGATIVE_WEIGHTS = false;
    public static double WEIGHT_TOLERANCE = 0.001;
    public static final INeuron MIN_NEURON = new INeuron();
    public static final INeuron MAX_NEURON = new INeuron();
    private String label;
    private Type type;
    private String outputText;
    private volatile double bias;
    private volatile double biasDelta;
    private SynapseSummary synapseSummary = new SynapseSummary();
    ActivationFunction activationFunction;
    private volatile int synapseIdCounter = 0;
    private Map<Integer, Relation> outputRelations = new TreeMap<Integer, Relation>();
    TreeMap<Synapse, Synapse> inputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
    TreeMap<Synapse, Synapse> outputSynapses = new TreeMap(Synapse.OUTPUT_SYNAPSE_COMP);
    TreeMap<Synapse, Synapse> passiveInputSynapses = null;
    private Provider<InputNode> outputNode;
    private Provider<OrNode> inputNode;
    ReadWriteLock lock = new ReadWriteLock();
    PassiveInputFunction passiveInputFunction = null;
    private ThreadState[] threads;

    public void setOutputNode(Provider<InputNode> node) {
        this.outputNode = node;
    }

    public Integer getId() {
        return ((Neuron)this.provider).getId();
    }

    public String getLabel() {
        return this.label;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type t) {
        this.type = t;
    }

    public Provider<InputNode> getOutputNode() {
        return this.outputNode;
    }

    public Provider<OrNode> getInputNode() {
        return this.inputNode;
    }

    public SynapseSummary getSynapseSummary() {
        return this.synapseSummary;
    }

    public Map<Integer, Relation> getOutputRelations() {
        return this.outputRelations;
    }

    public Collection<Synapse> getInputSynapses() {
        return this.inputSynapses.values();
    }

    public Synapse getMaxInputSynapse(Synapse.State state) {
        if (this.type != Type.EXCITATORY) {
            return null;
        }
        Synapse maxSyn = null;
        for (Synapse s : this.getInputSynapses()) {
            if (s.isInactive() || maxSyn != null && !(maxSyn.getNewWeight() < s.getNewWeight())) continue;
            maxSyn = s;
        }
        return maxSyn;
    }

    public Collection<Synapse> getOutputSynapses() {
        return this.outputSynapses.values();
    }

    public Collection<Synapse> getPassiveInputSynapses() {
        if (this.passiveInputSynapses == null) {
            return Collections.emptyList();
        }
        return this.passiveInputSynapses.values();
    }

    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(ActivationFunction actF) {
        this.activationFunction = actF;
    }

    public Stream<Activation> getActivations(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return Stream.empty();
        }
        return th.activations.values().stream();
    }

    public boolean isEmpty(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return true;
        }
        return th.activationsBySlotAndPosition.isEmpty();
    }

    public int size(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return 0;
        }
        return th.activations.size();
    }

    public void clearActivations(Document doc) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return;
        }
        th.activationsBySlotAndPosition.clear();
        th.activations.clear();
        th.doc = null;
    }

    public Stream<Activation> getActivations(Document doc, int slot, Position pos, boolean onlyFinal) {
        return this.getActivations(doc, slot, pos, true, slot, pos, false).filter(act -> !onlyFinal || act.isFinalActivation());
    }

    public void clearActivations() {
        for (int i = 0; i < ((Neuron)this.provider).getModel().numberOfThreads; ++i) {
            this.clearActivations(i);
        }
    }

    public void clearActivations(int threadId) {
        ThreadState th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.activationsBySlotAndPosition.clear();
        th.activations.clear();
        th.doc = null;
    }

    public Model getModel() {
        return ((Neuron)this.provider).getModel();
    }

    public Stream<Activation> getActivations(Document doc, int fromSlot, Position fromPos, boolean fromInclusive, int toSlot, Position toPos, boolean toInclusive) {
        ThreadState th = this.getThreadState(doc.getThreadId(), false);
        if (th == null) {
            return Stream.empty();
        }
        return th.activationsBySlotAndPosition.subMap(new ActKey(fromSlot, fromPos, Integer.MIN_VALUE), fromInclusive, new ActKey(toSlot, toPos, Integer.MAX_VALUE), toInclusive).values().stream();
    }

    public Stream<Activation> getActivations(Document doc, boolean onlyFinal) {
        return onlyFinal ? this.getActivations(doc).filter(act -> act.isFinalActivation()) : this.getActivations(doc);
    }

    public Collection<Activation> getActivations(Document doc, SortedMap<Integer, Position> slots) {
        Integer firstSlot = slots.firstKey();
        Position firstPos = (Position)slots.get(firstSlot);
        return this.getActivations(doc, firstSlot, firstPos, true, firstSlot, firstPos, true).filter(act -> {
            for (Map.Entry me : slots.entrySet()) {
                Position pos = (Position)me.getValue();
                if (pos.getFinalPosition() == null || pos.compare(act.lookupSlot((Integer)me.getKey())) == 0) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private ThreadState getThreadState(int threadId, boolean create) {
        ThreadState th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState();
        }
        th.lastUsed = ((Neuron)this.provider).getModel().docIdCounter.get();
        return th;
    }

    private INeuron() {
    }

    public INeuron(Neuron p) {
        this.provider = p;
        this.threads = new ThreadState[p.getModel().numberOfThreads];
    }

    public INeuron(Model m, String label, Type type, ActivationFunction actF) {
        this(m, label, null, type, actF);
    }

    public INeuron(Model m, String label, String outputText, Type type, ActivationFunction actF) {
        this.label = label;
        this.type = type;
        this.activationFunction = actF;
        this.setOutputText(outputText);
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Neuron(m, this);
        OrNode node = new OrNode(m);
        InputNode iNode = new InputNode(m);
        node.setOutputNeuron((Neuron)this.provider);
        this.inputNode = node.getProvider();
        iNode.setInputNeuron((Neuron)this.provider);
        this.outputNode = iNode.getProvider();
        this.setModified();
        iNode.setModified();
    }

    public void setOutputText(String outputText) {
        this.outputText = outputText;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public Activation addInput(Document doc, Activation.Builder input) {
        Activation act = this.getActivation(doc, input);
        if (act == null) {
            act = this.createActivation(doc, input.getSlots(doc));
        }
        act.setInputState(input);
        doc.addInputNeuronActivation(act);
        doc.addFinallyActivatedNeuron(act.getINeuron());
        this.propagate(act);
        doc.propagate();
        return act;
    }

    protected Activation createActivation(Document doc, Map<Integer, Position> slots) {
        return new Activation(doc, this, slots);
    }

    private Activation getActivation(Document doc, Activation.Builder input) {
        Integer firstSlot = input.positions.firstKey();
        Position firstPos = doc.lookupFinalPosition((Integer)input.positions.get(firstSlot));
        block0: for (Activation a : this.getActivations(doc, firstSlot, firstPos, true, firstSlot, firstPos, true).collect(Collectors.toList())) {
            for (Map.Entry<Integer, Integer> me : input.positions.entrySet()) {
                Position pos = a.lookupSlot(me.getKey());
                if (pos != null && me.getValue().compareTo(pos.getFinalPosition()) == 0) continue;
                continue block0;
            }
            return a;
        }
        return null;
    }

    public double getTotalBias(Synapse.State state) {
        switch (this.type) {
            case EXCITATORY: {
                return this.getBias(state) - this.synapseSummary.getPosSum(state);
            }
            case INHIBITORY: {
                return this.getBias(state);
            }
        }
        return this.getBias(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Collection<Synapse> modifiedSynapses) {
        for (Synapse s : modifiedSynapses) {
            INeuron in = (INeuron)s.getInput().get();
            in.lock.acquireWriteLock();
            try {
                this.synapseSummary.updateSynapse(s);
            }
            finally {
                in.lock.releaseWriteLock();
            }
        }
        this.bias += this.biasDelta;
        this.biasDelta = 0.0;
        for (Synapse s : modifiedSynapses) {
            s.commit();
        }
        this.synapseSummary.commit();
        this.setModified();
    }

    public void remove() {
        this.clearActivations();
        for (Synapse s : this.inputSynapses.values()) {
            INeuron in = (INeuron)s.getInput().get();
            ((Neuron)in.provider).lock.acquireWriteLock();
            ((Neuron)in.provider).activeOutputSynapses.remove(s);
            ((Neuron)in.provider).lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).activeOutputSynapses.values()) {
            INeuron out = (INeuron)s.getOutput().get();
            out.lock.acquireWriteLock();
            out.inputSynapses.remove(s);
            out.lock.releaseWriteLock();
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    public synchronized int getNewSynapseId() {
        this.setModified();
        return this.synapseIdCounter++;
    }

    public synchronized void registerSynapseId(Integer synId) {
        if (synId >= this.synapseIdCounter) {
            this.setModified();
            this.synapseIdCounter = synId + 1;
        }
    }

    public void propagate(Activation act) {
        Document doc = act.getDocument();
        this.outputNode.get(doc).addActivation(act);
    }

    @Override
    public int compareTo(INeuron n) {
        if (this == n) {
            return 0;
        }
        if (this == MIN_NEURON) {
            return -1;
        }
        if (n == MIN_NEURON) {
            return 1;
        }
        if (this == MAX_NEURON) {
            return 1;
        }
        if (n == MAX_NEURON) {
            return -1;
        }
        if (this.getId() < n.getId()) {
            return -1;
        }
        if (this.getId() > n.getId()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(true);
        out.writeBoolean(this.label != null);
        if (this.label != null) {
            out.writeUTF(this.label);
        }
        out.writeBoolean(this.type != null);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        }
        out.writeBoolean(this.outputText != null);
        if (this.outputText != null) {
            out.writeUTF(this.outputText);
        }
        out.writeDouble(this.bias);
        this.synapseSummary.write(out);
        out.writeBoolean(this.activationFunction != null);
        if (this.activationFunction != null) {
            out.writeUTF(this.activationFunction.name());
        }
        out.writeInt(this.outputNode.getId());
        out.writeBoolean(this.inputNode != null);
        if (this.inputNode != null) {
            out.writeInt(this.inputNode.getId());
        }
        out.writeInt(this.synapseIdCounter);
        for (Synapse synapse : this.inputSynapses.values()) {
            if (synapse.getInput() == null) continue;
            out.writeBoolean(true);
            this.getModel().writeSynapse(synapse, out);
            out.writeBoolean(this.passiveInputSynapses != null && this.passiveInputSynapses.containsKey(synapse));
        }
        out.writeBoolean(false);
        for (Synapse synapse : this.outputSynapses.values()) {
            if (synapse.getOutput() == null) continue;
            out.writeBoolean(true);
            this.getModel().writeSynapse(synapse, out);
        }
        out.writeBoolean(false);
        if (this.outputRelations != null) {
            out.writeInt(this.outputRelations.size());
            for (Map.Entry entry : this.outputRelations.entrySet()) {
                out.writeInt((Integer)entry.getKey());
                ((Relation)entry.getValue()).write(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        Synapse syn;
        if (in.readBoolean()) {
            this.label = in.readUTF();
        }
        if (in.readBoolean()) {
            this.type = Type.valueOf(in.readUTF());
        }
        if (in.readBoolean()) {
            this.outputText = in.readUTF();
        }
        this.bias = in.readDouble();
        this.synapseSummary = SynapseSummary.read(in, m);
        if (in.readBoolean()) {
            this.activationFunction = ActivationFunction.valueOf(in.readUTF());
        }
        this.outputNode = m.lookupNodeProvider(in.readInt());
        if (in.readBoolean()) {
            Integer nId = in.readInt();
            this.inputNode = m.lookupNodeProvider(nId);
        }
        this.synapseIdCounter = in.readInt();
        while (in.readBoolean()) {
            syn = m.readSynapse(in);
            this.inputSynapses.put(syn, syn);
            if (!in.readBoolean()) continue;
            this.registerPassiveInputSynapse(syn);
        }
        while (in.readBoolean()) {
            syn = m.readSynapse(in);
            this.outputSynapses.put(syn, syn);
        }
        int l = in.readInt();
        if (l > 0) {
            this.outputRelations = new TreeMap<Integer, Relation>();
            for (int i = 0; i < l; ++i) {
                Integer relId = in.readInt();
                Relation r = Relation.read(in, m);
                this.outputRelations.put(relId, r);
            }
        }
        this.passiveInputFunction = m.passiveActivationFunctions.get(this.getId());
    }

    @Override
    public void suspend() {
        for (Synapse s : this.inputSynapses.values()) {
            s.getInput().removeActiveOutputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.getOutput().removeActiveInputSynapse(s);
        }
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).activeInputSynapses.values()) {
            s.getInput().removeActiveOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).activeOutputSynapses.values()) {
            s.getOutput().removeActiveInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
    }

    @Override
    public void reactivate() {
        ((Neuron)this.provider).lock.acquireReadLock();
        for (Synapse s : ((Neuron)this.provider).activeInputSynapses.values()) {
            s.getInput().addActiveOutputSynapse(s);
        }
        for (Synapse s : ((Neuron)this.provider).activeOutputSynapses.values()) {
            s.getOutput().addActiveInputSynapse(s);
        }
        ((Neuron)this.provider).lock.releaseReadLock();
        for (Synapse s : this.inputSynapses.values()) {
            s.getInput().addActiveOutputSynapse(s);
            if (s.getInput().isSuspended()) continue;
            s.getOutput().addActiveInputSynapse(s);
        }
        for (Synapse s : this.outputSynapses.values()) {
            s.getOutput().addActiveInputSynapse(s);
            if (s.getOutput().isSuspended()) continue;
            s.getInput().addActiveOutputSynapse(s);
        }
    }

    public void setBias(double b) {
        this.biasDelta = b - this.bias;
    }

    public void updateBiasDelta(double biasDelta) {
        this.biasDelta += biasDelta;
    }

    public double getBias() {
        return this.bias;
    }

    private double getBias(Synapse.State state) {
        return state == Synapse.State.CURRENT ? this.bias : this.bias + this.biasDelta;
    }

    public double getNewBias() {
        return this.bias + this.biasDelta;
    }

    public double getBiasDelta() {
        return this.biasDelta;
    }

    public void register(Activation act) {
        Document doc = act.getDocument();
        ThreadState th = this.getThreadState(act.getThreadId(), true);
        if (th.doc == null) {
            th.doc = doc;
            doc.addActivatedNeuron(act.getINeuron());
        }
        if (th.doc != doc) {
            throw new Model.StaleDocumentException();
        }
        Integer l = act.length();
        if (l != null) {
            th.minLength = Math.min(th.minLength, l);
            th.maxLength = Math.max(th.maxLength, l);
        }
        for (Map.Entry<Integer, Position> me : act.getSlots().entrySet()) {
            ActKey ak = new ActKey(me.getKey(), me.getValue(), act.getId());
            th.activationsBySlotAndPosition.put(ak, act);
            th.activations.put(act.getId(), act);
        }
        for (Map.Entry<Integer, Position> me : act.getSlots().entrySet()) {
            me.getValue().addActivation(me.getKey(), act);
        }
        doc.addActivation(act);
    }

    public boolean isPassiveInputNeuron() {
        return this.passiveInputFunction != null;
    }

    public void registerPassiveInputSynapse(Synapse s) {
        if (this.passiveInputSynapses == null) {
            this.passiveInputSynapses = new TreeMap(Synapse.INPUT_SYNAPSE_COMP);
        }
        this.passiveInputSynapses.put(s, s);
    }

    public String toString() {
        return this.label;
    }

    public String toStringWithSynapses() {
        TreeSet<Synapse> is = new TreeSet<Synapse>((s1, s2) -> {
            int r = Double.compare(s2.getWeight(), s1.getWeight());
            if (r != 0) {
                return r;
            }
            return Integer.compare(s1.getInput().getId(), s2.getInput().getId());
        });
        is.addAll(this.inputSynapses.values());
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("<");
        sb.append("B:");
        sb.append(Utils.round(this.bias));
        for (Synapse s : is) {
            sb.append(", ");
            sb.append(Utils.round(s.getWeight()));
            sb.append(":");
            sb.append(s.getInput().toString());
        }
        sb.append(">");
        return sb.toString();
    }

    public static class SynapseSummary
    implements Writable {
        private volatile double posDirSum;
        private volatile double negDirSum;
        private volatile double negRecSum;
        private volatile double posRecSum;
        private volatile double posPassiveSum;
        private volatile double posDirSumDelta = 0.0;
        private volatile double negDirSumDelta = 0.0;
        private volatile double negRecSumDelta = 0.0;
        private volatile double posRecSumDelta = 0.0;
        private volatile double posPassiveSumDelta = 0.0;

        public double getPosDirSum() {
            return this.posDirSum;
        }

        public double getNegDirSum() {
            return this.negDirSum;
        }

        public double getNegRecSum() {
            return this.negRecSum;
        }

        public double getPosRecSum() {
            return this.posRecSum;
        }

        public double getPosPassiveSum() {
            return this.posPassiveSum;
        }

        public double getPosSum(Synapse.State state) {
            return this.getPosDirSum(state) + this.getPosRecSum(state);
        }

        private double getPosDirSum(Synapse.State state) {
            return state == Synapse.State.CURRENT ? this.posDirSum : this.posDirSum + this.posDirSumDelta;
        }

        private double getPosRecSum(Synapse.State state) {
            return state == Synapse.State.CURRENT ? this.posRecSum : this.posRecSum + this.posRecSumDelta;
        }

        private double getPosPassiveSum(Synapse.State state) {
            return state == Synapse.State.CURRENT ? this.posPassiveSum : this.posPassiveSum + this.posPassiveSumDelta;
        }

        public void updateSynapse(Synapse s) {
            if (!s.isInactive(Synapse.State.CURRENT)) {
                this.updateSynapse(Synapse.State.CURRENT, -1.0, s);
            }
            if (!s.isInactive(Synapse.State.NEXT)) {
                this.updateSynapse(Synapse.State.NEXT, 1.0, s);
            }
        }

        private void updateSynapse(Synapse.State state, double sign, Synapse s) {
            this.updateSum(s.isRecurrent(), s.isNegative(state), sign * (s.getLimit(state) * s.getWeight(state)));
            this.posDirSumDelta += sign * s.computeMaxRelationWeights();
            if (((INeuron)s.getInput().get()).isPassiveInputNeuron() && !s.isNegative(state)) {
                this.posPassiveSumDelta += sign * (!s.isNegative(state) ? s.getLimit(state) * s.getWeight(state) : 0.0);
            }
        }

        private void updateSum(boolean rec, boolean neg, double delta) {
            if (!rec) {
                if (!neg) {
                    this.posDirSumDelta += delta;
                } else {
                    this.negDirSumDelta += delta;
                }
            } else if (!neg) {
                this.posRecSumDelta += delta;
            } else {
                this.negRecSumDelta += delta;
            }
        }

        public void commit() {
            this.posDirSum += this.posDirSumDelta;
            this.negDirSum += this.negDirSumDelta;
            this.posRecSum += this.posRecSumDelta;
            this.negRecSum += this.negRecSumDelta;
            this.posPassiveSum += this.posPassiveSumDelta;
            this.posDirSumDelta = 0.0;
            this.negDirSumDelta = 0.0;
            this.negRecSumDelta = 0.0;
            this.posDirSumDelta = 0.0;
            this.posPassiveSumDelta = 0.0;
        }

        public static SynapseSummary read(DataInput in, Model m) throws IOException {
            SynapseSummary ss = new SynapseSummary();
            ss.readFields(in, m);
            return ss;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeDouble(this.posDirSum);
            out.writeDouble(this.negDirSum);
            out.writeDouble(this.negRecSum);
            out.writeDouble(this.posRecSum);
            out.writeDouble(this.posPassiveSum);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            this.posDirSum = in.readDouble();
            this.negDirSum = in.readDouble();
            this.negRecSum = in.readDouble();
            this.posRecSum = in.readDouble();
            this.posPassiveSum = in.readDouble();
        }
    }

    private static class ActKey
    implements Comparable<ActKey> {
        int slot;
        Position pos;
        int actId;

        public ActKey(int slot, Position pos, int actId) {
            this.slot = slot;
            this.pos = pos;
            this.actId = actId;
        }

        @Override
        public int compareTo(ActKey ak) {
            int r = Integer.compare(this.slot, ak.slot);
            if (r != 0) {
                return r;
            }
            r = this.pos.compare(ak.pos);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.actId, ak.actId);
        }
    }

    private static class ThreadState {
        public long lastUsed;
        public Document doc;
        private TreeMap<ActKey, Activation> activationsBySlotAndPosition;
        private TreeMap<Integer, Activation> activations;
        public int minLength = Integer.MAX_VALUE;
        public int maxLength = 0;

        public ThreadState() {
            this.activationsBySlotAndPosition = new TreeMap();
            this.activations = new TreeMap();
        }
    }

    public static enum Type {
        INPUT(ActivationFunction.NULL_FUNCTION),
        EXCITATORY(ActivationFunction.RECTIFIED_HYPERBOLIC_TANGENT),
        INHIBITORY(ActivationFunction.RECTIFIED_LINEAR_UNIT);

        private ActivationFunction defaultActivationFunction;

        private Type(ActivationFunction defaultActivationFunction) {
            this.defaultActivationFunction = defaultActivationFunction;
        }

        public ActivationFunction getDefaultActivationFunction() {
            return this.defaultActivationFunction;
        }
    }
}

