/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import network.aika.ActivationFunction;
import network.aika.Document;
import network.aika.Utils;
import network.aika.lattice.InputNode;
import network.aika.lattice.OrNode;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Candidate;
import network.aika.neuron.activation.Linker;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.SearchNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activation
implements Comparable<Activation> {
    public static int BEGIN = 0;
    public static int END = 1;
    public static final Comparator<Activation> ACTIVATION_ID_COMP = Comparator.comparingInt(act -> act.id);
    public static int MAX_SELF_REFERENCING_DEPTH = 5;
    public static int MAX_PREDECESSOR_DEPTH = 100;
    public static boolean DEBUG_OUTPUT = false;
    public static final Activation MIN_ACTIVATION = new Activation(Integer.MIN_VALUE);
    public static final Activation MAX_ACTIVATION = new Activation(Integer.MAX_VALUE);
    private static final Logger log = LoggerFactory.getLogger(Activation.class);
    private int id;
    private INeuron neuron;
    private Document doc;
    private long visited = 0L;
    private Map<Integer, Position> slots = new TreeMap<Integer, Position>();
    private OrNode.OrActivation inputNodeActivation;
    private InputNode.InputActivation outputNodeActivation;
    private TreeSet<Link> selectedInputLinks = new TreeSet<Link>(Link.INPUT_COMP);
    private TreeMap<Link, Link> inputLinks = new TreeMap(Link.INPUT_COMP);
    private TreeMap<Link, Link> outputLinks = new TreeMap(Link.OUTPUT_COMP);
    private Integer sequence;
    private double upperBound;
    private double lowerBound;
    private List<Option> options;
    Rounds rounds;
    Rounds finalRounds = this.rounds = new Rounds();
    boolean ubQueued = false;
    public long markedHasCandidate;
    private long currentStateV;
    private StateChange currentStateChange;
    long markedDirty;
    private long markedPredecessor;
    private Double targetValue;
    private Double inputValue;
    SearchNode.Decision inputDecision = SearchNode.Decision.UNKNOWN;
    SearchNode.Decision decision = SearchNode.Decision.UNKNOWN;
    SearchNode.Decision finalDecision = SearchNode.Decision.UNKNOWN;
    Candidate candidate;
    private long visitedState;
    public long markedAncDesc;
    public boolean blocked;
    private List<Activation> conflicts;

    private Activation(int id) {
        this.id = id;
    }

    public Activation(Document doc, INeuron neuron, Map<Integer, Position> slots) {
        this.id = doc.getNewActivationId();
        this.doc = doc;
        this.neuron = neuron;
        this.slots = slots;
        neuron.register(this);
    }

    public void setInputNodeActivation(OrNode.OrActivation inputNodeActivation) {
        this.inputNodeActivation = inputNodeActivation;
    }

    public OrNode.OrActivation getInputNodeActivation() {
        return this.inputNodeActivation;
    }

    public InputNode.InputActivation getOutputNodeActivation() {
        return this.outputNodeActivation;
    }

    public void setOutputNodeActivation(InputNode.InputActivation outputNodeActivation) {
        this.outputNodeActivation = outputNodeActivation;
    }

    public Map<Integer, Position> getSlots() {
        return this.slots;
    }

    public Position lookupSlot(int slot) {
        Position pos = this.slots.get(slot);
        if (pos == null) {
            pos = new Position(this.doc);
            this.slots.put(slot, pos);
        }
        return pos;
    }

    public Integer length() {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Position pos : this.slots.values()) {
            if (pos.getFinalPosition() == null) {
                return null;
            }
            min = Math.min(min, pos.getFinalPosition());
            max = Math.max(max, pos.getFinalPosition());
        }
        if (min > max) {
            return 0;
        }
        return max - min;
    }

    public int getId() {
        return this.id;
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getThreadId() {
        return this.doc.getThreadId();
    }

    public long getNewVisitedId() {
        return this.doc.getNewVisitedId();
    }

    public long getVisitedId() {
        return this.visited;
    }

    public boolean checkVisited(long v) {
        if (this.visited == v) {
            return false;
        }
        this.visited = v;
        return true;
    }

    public Collection<Option> getOptions() {
        if (this.options == null) {
            return Collections.emptyList();
        }
        return this.options;
    }

    public String getLabel() {
        return this.getINeuron().getLabel();
    }

    public INeuron.Type getType() {
        return this.getINeuron().getType();
    }

    public String getText() {
        return this.doc.getText(this.lookupSlot(BEGIN), this.lookupSlot(END));
    }

    public INeuron getINeuron() {
        return this.neuron;
    }

    public Neuron getNeuron() {
        return (Neuron)this.neuron.getProvider();
    }

    public Synapse getSynapseById(int synapseId) {
        return this.getNeuron().getSynapseById(synapseId);
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Double getTargetValue() {
        return this.targetValue;
    }

    public Double getInputValue() {
        return this.inputValue;
    }

    public SearchNode.Decision getInputDecision() {
        return this.inputDecision;
    }

    public SearchNode.Decision getDecision() {
        return this.decision;
    }

    public SearchNode.Decision getFinalDecision() {
        return this.finalDecision;
    }

    public void addLink(Linker.Direction dir, Link l) {
        switch (dir) {
            case INPUT: {
                this.outputLinks.put(l, l);
                break;
            }
            case OUTPUT: {
                if (l.input.decision == SearchNode.Decision.SELECTED) {
                    this.selectedInputLinks.add(l);
                }
                this.inputLinks.put(l, l);
            }
        }
    }

    public Link getLinkBySynapseId(int synapseId) {
        for (Link l : this.inputLinks.values()) {
            if (l.synapse.getId() != synapseId) continue;
            return l;
        }
        return null;
    }

    public Stream<Link> getInputLinks(boolean onlySelected) {
        return (onlySelected ? this.selectedInputLinks : this.inputLinks.values()).stream();
    }

    public Stream<Link> getOutputLinks() {
        return this.outputLinks.values().stream();
    }

    public Link getInputLink(Link l) {
        return this.inputLinks.get(l);
    }

    public Stream<Link> getInputLinksBySynapse(Synapse syn) {
        return this.inputLinks.subMap(new Link(syn, MIN_ACTIVATION, MIN_ACTIVATION), new Link(syn, MAX_ACTIVATION, MAX_ACTIVATION)).values().stream();
    }

    public Stream<Link> getOutputLinksBySynapse(Synapse syn) {
        return this.outputLinks.subMap(new Link(syn, MIN_ACTIVATION, MIN_ACTIVATION), new Link(syn, MAX_ACTIVATION, MAX_ACTIVATION)).values().stream();
    }

    public double process(SearchNode sn, int round, long v) throws OscillatingActivationsException, RecursiveDepthExceededException {
        double delta = 0.0;
        State s = this.inputValue != null ? new State(this.inputValue, this.inputValue, 0.0, 0.0, 0, 0.0) : this.computeValueAndWeight(round);
        if (round == 0 || !this.rounds.get(round).equalsWithWeights(s)) {
            this.saveOldState(sn.getModifiedActivations(), v);
            State oldState = this.rounds.get(round);
            boolean propagate = this.rounds.set(round, s) && (oldState == null || !oldState.equals(s));
            this.saveNewState();
            if (propagate) {
                if (round > Document.MAX_ROUND) {
                    throw new OscillatingActivationsException(this.doc.dumpOscillatingActivations());
                }
                if (Document.ROUND_LIMIT < 0 || round < Document.ROUND_LIMIT) {
                    this.doc.getValueQueue().propagateActivationValue(round, this);
                }
            }
            if (round == 0) {
                this.doc.getValueQueue().add(1, this);
            }
            if (this.rounds.getLastRound() != null && round >= this.rounds.getLastRound()) {
                delta += s.weight - oldState.weight;
            }
        }
        return delta;
    }

    public State computeValueAndWeight(int round) throws RecursiveDepthExceededException {
        double newWeight;
        INeuron n = this.getINeuron();
        INeuron.SynapseSummary ss = n.getSynapseSummary();
        double net = n.getTotalBias(Synapse.State.CURRENT);
        double posNet = n.getTotalBias(Synapse.State.CURRENT);
        int fired = -1;
        long v = this.doc.getNewVisitedId();
        this.markPredecessor(v, 0);
        for (InputState is : this.getInputStates(round, v)) {
            Synapse s = is.l.synapse;
            Activation iAct = is.l.input;
            if (iAct == this) continue;
            double x = Math.min(s.getLimit(), is.s.value) * s.getWeight();
            net += x;
            net += s.computeRelationWeights(is.l);
            if (!s.isNegative(Synapse.State.CURRENT)) {
                posNet += x;
            }
            if (s.isRecurrent() || s.isNegative(Synapse.State.CURRENT) || !(net >= 0.0) || fired >= 0) continue;
            fired = iAct.rounds.get((int)round).fired + 1;
        }
        for (Synapse s : n.getPassiveInputSynapses()) {
            double x = s.getWeight() * s.getInput().getPassiveInputFunction().getActivationValue(s, this);
            net += x;
            if (s.isNegative(Synapse.State.CURRENT)) continue;
            posNet += x;
        }
        double actValue = n.getActivationFunction().f(net);
        double posActValue = n.getActivationFunction().f(posNet);
        double w = Math.min(-ss.getNegRecSum(), net);
        double d = newWeight = this.decision == SearchNode.Decision.SELECTED ? Math.max(0.0, w) : 0.0;
        if (this.decision == SearchNode.Decision.SELECTED || INeuron.ALLOW_WEAK_NEGATIVE_WEIGHTS) {
            return new State(actValue, posActValue, net, posNet, -1, newWeight);
        }
        return new State(0.0, posActValue, 0.0, posNet, -1, newWeight);
    }

    public boolean isActiveable() {
        INeuron n = this.getINeuron();
        double net = n.getTotalBias(Synapse.State.CURRENT);
        for (Link l : this.inputLinks.values()) {
            if (l.isInactive()) continue;
            Synapse s = l.synapse;
            Activation iAct = l.input;
            if (iAct == this) continue;
            double iv = 0.0;
            if (!l.isNegative(Synapse.State.CURRENT) && l.input.decision != SearchNode.Decision.EXCLUDED) {
                iv = Math.min(l.synapse.getLimit(), l.input.upperBound);
            }
            double x = iv * s.getWeight();
            net += x;
            net += s.computeRelationWeights(l);
        }
        for (Synapse s : n.getPassiveInputSynapses()) {
            double x = s.getWeight() * s.getInput().getPassiveInputFunction().getActivationValue(s, this);
            net += x;
        }
        return net > 0.0;
    }

    public void processBounds() throws RecursiveDepthExceededException {
        double oldUpperBound = this.upperBound;
        this.computeBounds();
        if (Math.abs(this.upperBound - oldUpperBound) > 0.01) {
            for (Link l : this.outputLinks.values()) {
                this.doc.getUpperBoundQueue().add(l);
            }
        }
        if (oldUpperBound <= 0.0 && this.upperBound > 0.0 && !this.blocked) {
            this.getINeuron().propagate(this);
        }
    }

    public void computeBounds() throws RecursiveDepthExceededException {
        INeuron n = this.getINeuron();
        INeuron.SynapseSummary ss = n.getSynapseSummary();
        double ub = n.getTotalBias(Synapse.State.CURRENT) + ss.getPosRecSum();
        double lb = n.getTotalBias(Synapse.State.CURRENT) + ss.getPosRecSum();
        long v = this.doc.getNewVisitedId();
        this.markPredecessor(v, 0);
        for (Link l : this.inputLinks.values()) {
            Activation iAct;
            Synapse s = l.synapse;
            if (s.isInactive() || (iAct = l.input) == this) continue;
            double x = s.getWeight();
            if (s.isNegative(Synapse.State.CURRENT)) {
                if (!s.isRecurrent() && !iAct.checkSelfReferencing(false, 0, v)) {
                    ub += Math.min(s.getLimit(), iAct.lowerBound) * x;
                }
                lb += s.getLimit() * x;
                continue;
            }
            ub += Math.min(s.getLimit(), iAct.upperBound) * x;
            lb += Math.min(s.getLimit(), iAct.lowerBound) * x;
            double rlw = s.computeRelationWeights(l);
            ub += rlw;
            lb += rlw;
        }
        for (Synapse s : n.getPassiveInputSynapses()) {
            double x = s.getWeight() * s.getInput().getPassiveInputFunction().getActivationValue(s, this);
            ub += x;
            lb += x;
        }
        this.upperBound = n.getActivationFunction().f(ub);
        this.lowerBound = n.getActivationFunction().f(lb);
    }

    private static State getInitialState(SearchNode.Decision c) {
        return new State(c == SearchNode.Decision.SELECTED ? 1.0 : 0.0, 0.0, 0.0, 0.0, 0, 0.0);
    }

    private List<InputState> getInputStates(int round, long v) {
        ArrayList<InputState> tmp = new ArrayList<InputState>();
        Synapse lastSynapse = null;
        InputState maxInputState = null;
        for (Link l : this.inputLinks.values()) {
            if (l.isInactive()) continue;
            if (lastSynapse != null && lastSynapse != l.synapse) {
                tmp.add(maxInputState);
                maxInputState = null;
            }
            State s = l.input.getInputState(round, l.synapse, v);
            if (maxInputState == null || maxInputState.s.value < s.value) {
                maxInputState = new InputState(l, s);
            }
            lastSynapse = l.synapse;
        }
        if (maxInputState != null) {
            tmp.add(maxInputState);
        }
        return tmp;
    }

    public ActivationFunction getActivationFunction() {
        return this.getINeuron().getActivationFunction();
    }

    public boolean hasUndecidedPositiveFeedbackLinks() {
        return this.getInputLinks(false).anyMatch(l -> l.isRecurrent() && !l.isNegative(Synapse.State.CURRENT) && l.input.decision == SearchNode.Decision.UNKNOWN);
    }

    public boolean isOscillating() {
        return this.rounds.getLastRound() != null && this.rounds.getLastRound() > Document.MAX_ROUND - 5;
    }

    public void setInputState(Builder input) {
        State s = new State(input.value, input.value, input.net, 0.0, input.fired, 0.0);
        this.rounds.set(0, s);
        if (SearchNode.COMPUTE_SOFT_MAX) {
            Option o = new Option(-1, SearchNode.Decision.SELECTED);
            o.p = 1.0;
            o.state = s;
        }
        this.inputValue = input.value;
        this.upperBound = input.value;
        this.lowerBound = input.value;
        this.targetValue = input.targetValue;
        this.finalDecision = this.inputDecision = SearchNode.Decision.SELECTED;
        this.setDecision(this.inputDecision, this.doc.getNewVisitedId());
    }

    private State getInputState(int round, Synapse s, long v) {
        State is = State.ZERO;
        if (s.isRecurrent()) {
            if (!s.isNegative(Synapse.State.CURRENT) || !this.checkSelfReferencing(true, 0, v)) {
                is = round == 0 ? Activation.getInitialState(this.decision) : this.rounds.get(round - 1);
            }
        } else {
            is = this.rounds.get(round);
        }
        return is;
    }

    public List<Link> getFinalInputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.inputLinks.values()) {
            if (!l.input.isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public List<Link> getFinalOutputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.outputLinks.values()) {
            if (!l.output.isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public Collection<Activation> getConflicts() throws RecursiveDepthExceededException {
        if (this.conflicts != null) {
            return this.conflicts;
        }
        long v = this.doc.getNewVisitedId();
        this.markPredecessor(v, 0);
        this.conflicts = new ArrayList<Activation>();
        for (Link l : this.inputLinks.values()) {
            if (!l.isNegative(Synapse.State.CURRENT) || !l.isRecurrent()) continue;
            l.input.collectIncomingConflicts(this.conflicts, v);
        }
        this.collectOutgoingConflicts(this.conflicts, v);
        return this.conflicts;
    }

    private void collectIncomingConflicts(List<Activation> conflicts, long v) {
        if (this.markedPredecessor == v) {
            return;
        }
        switch (this.getType()) {
            case EXCITATORY: {
                conflicts.add(this);
                break;
            }
            case INHIBITORY: {
                for (Link l : this.inputLinks.values()) {
                    if (l.isNegative(Synapse.State.CURRENT) || l.isRecurrent()) continue;
                    l.input.collectIncomingConflicts(conflicts, v);
                }
                break;
            }
        }
    }

    private void collectOutgoingConflicts(List<Activation> conflicts, long v) {
        if (this.markedPredecessor == v) {
            return;
        }
        for (Link l : this.outputLinks.values()) {
            if (l.output.getType() != INeuron.Type.INHIBITORY) {
                if (!l.isNegative(Synapse.State.CURRENT) || !l.isRecurrent()) continue;
                conflicts.add(l.output);
                continue;
            }
            if (l.isNegative(Synapse.State.CURRENT) || l.isRecurrent()) continue;
            l.output.collectOutgoingConflicts(conflicts, v);
        }
    }

    public void adjustSelectedNeuronInputs(SearchNode.Decision d) {
        for (Link l : this.outputLinks.values()) {
            if (d == SearchNode.Decision.SELECTED) {
                l.output.selectedInputLinks.add(l);
                continue;
            }
            l.output.selectedInputLinks.remove(l);
        }
    }

    public boolean checkSelfReferencing(boolean onlySelected, int depth, long v) {
        if (this.markedPredecessor == v) {
            return true;
        }
        if (depth > MAX_SELF_REFERENCING_DEPTH) {
            return false;
        }
        for (Link l : onlySelected ? this.selectedInputLinks : this.inputLinks.values()) {
            if (l.synapse.isNegative(Synapse.State.CURRENT) || !l.input.checkSelfReferencing(onlySelected, depth + 1, v)) continue;
            return true;
        }
        return false;
    }

    public void setDecision(SearchNode.Decision newDecision, long v) {
        if (this.inputDecision != SearchNode.Decision.UNKNOWN && newDecision != this.inputDecision) {
            return;
        }
        if (newDecision == SearchNode.Decision.UNKNOWN && v != this.visitedState) {
            return;
        }
        if (this.decision == SearchNode.Decision.SELECTED != (newDecision == SearchNode.Decision.SELECTED)) {
            this.adjustSelectedNeuronInputs(newDecision);
        }
        this.decision = newDecision;
        this.visitedState = v;
    }

    public boolean isFinalActivation() {
        return this.getFinalState().value > 0.0;
    }

    public State getFinalState() {
        return this.finalRounds.getLast();
    }

    public double getValue() {
        return this.getFinalState().value;
    }

    public Integer getSequence() {
        if (this.sequence != null) {
            return this.sequence;
        }
        this.sequence = 0;
        this.inputLinks.values().stream().filter(l -> !l.isRecurrent()).forEach(l -> {
            this.sequence = Math.max(this.sequence, l.input.getSequence() + 1);
        });
        return this.sequence;
    }

    public void markDirty(long v) {
        this.markedDirty = Math.max(this.markedDirty, v);
    }

    public void markPredecessor(long v, int depth) throws RecursiveDepthExceededException {
        if (depth > MAX_PREDECESSOR_DEPTH) {
            throw new RecursiveDepthExceededException();
        }
        this.markedPredecessor = v;
        for (Link l : this.inputLinks.values()) {
            if (l.isNegative(Synapse.State.CURRENT) || l.isRecurrent()) continue;
            l.input.markPredecessor(v, depth + 1);
        }
    }

    public boolean match(Predicate<Link> filter) {
        Synapse ls = null;
        boolean matched = false;
        for (Link l : this.inputLinks.navigableKeySet()) {
            Synapse s = l.getSynapse();
            if (ls != null && ls != s) {
                if (!matched) {
                    return false;
                }
                matched = false;
            }
            if (filter.test(l)) {
                matched = true;
            }
            ls = s;
        }
        return matched;
    }

    public String toString() {
        return this.id + " " + this.getNeuron().getId() + ":" + this.getLabel() + " " + this.slotsToString() + " " + this.identityToString() + " -  UB:" + Utils.round(this.upperBound) + (String)(this.inputValue != null ? " IV:" + Utils.round(this.inputValue) : "") + (String)(this.targetValue != null ? " TV:" + Utils.round(this.targetValue) : "") + " V:" + Utils.round(this.rounds.getLast().value) + " FV:" + Utils.round(this.finalRounds.getLast().value);
    }

    public String toStringDetailed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id + " - ");
        sb.append(this.finalDecision + " - ");
        sb.append(this.slotsToString());
        sb.append(" \"");
        if (this.getINeuron().getOutputText() != null) {
            sb.append(Utils.collapseText(this.getINeuron().getOutputText(), 7));
        } else {
            sb.append(Utils.collapseText(this.doc.getText(this.lookupSlot(BEGIN), this.lookupSlot(END)), 7));
        }
        sb.append("\"");
        sb.append(this.identityToString());
        sb.append(" - ");
        sb.append(this.getLabel());
        if (DEBUG_OUTPUT) {
            sb.append(" - UB:");
            sb.append(Utils.round(this.upperBound));
        }
        if (SearchNode.COMPUTE_SOFT_MAX) {
            sb.append(" Exp:");
            sb.append(this.getExpectedState());
        }
        sb.append(" - ");
        if (this.isFinalActivation()) {
            State fs = this.getFinalState();
            sb.append(fs);
        }
        if (this.inputValue != null) {
            sb.append(" - IV:" + Utils.round(this.inputValue));
        }
        if (this.targetValue != null) {
            sb.append(" - TV:" + Utils.round(this.targetValue));
        }
        return sb.toString();
    }

    public State getExpectedState() {
        if (this.options == null) {
            return null;
        }
        double value = 0.0;
        double posValue = 0.0;
        double net = 0.0;
        double posNet = 0.0;
        for (Option option : this.options) {
            if (option.decision != SearchNode.Decision.SELECTED) continue;
            double p = option.p;
            State s = option.state;
            value += p * s.value;
            posValue += p * s.posValue;
            net += p * s.net;
            posNet += p * s.posNet;
        }
        return new State(value, posValue, net, posNet, 0, 0.0);
    }

    @Override
    public int compareTo(Activation act) {
        return Integer.compare(this.id, act.id);
    }

    public String slotsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Map.Entry<Integer, Position> me : this.slots.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(me.getKey());
            sb.append(":");
            sb.append(me.getValue());
        }
        sb.append(")");
        return sb.toString();
    }

    public String identityToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        boolean first = true;
        for (Link l : this.inputLinks.values()) {
            if (!l.isIdentity()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(l.input.id);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public String linksToString() {
        StringBuilder sb = new StringBuilder();
        for (Link l : this.inputLinks.values()) {
            sb.append("  " + l.input.getLabel() + "  W:" + l.synapse.getWeight() + "\n");
        }
        return sb.toString();
    }

    public void saveOldState(Map<Activation, StateChange> changes, long v) {
        StateChange sc = this.currentStateChange;
        if (sc == null || this.currentStateV != v) {
            sc = new StateChange();
            sc.oldRounds = this.rounds.copy();
            this.currentStateChange = sc;
            this.currentStateV = v;
            if (changes != null) {
                changes.put(sc.getActivation(), sc);
            }
        }
    }

    public void saveNewState() {
        StateChange sc = this.currentStateChange;
        sc.newRounds = this.rounds.copy();
        sc.newState = this.decision;
    }

    public static class RecursiveDepthExceededException
    extends RuntimeException {
        public RecursiveDepthExceededException() {
            super("MAX_PREDECESSOR_DEPTH limit exceeded. Probable cause is a non recurrent loop.");
        }
    }

    public static class OscillatingActivationsException
    extends RuntimeException {
        private String activationsDump;

        public OscillatingActivationsException(String activationsDump) {
            super("Maximum number of rounds reached. The network might be oscillating.");
            this.activationsDump = activationsDump;
        }

        public String getActivationsDump() {
            return this.activationsDump;
        }
    }

    public static class Builder {
        public SortedMap<Integer, Integer> positions = new TreeMap<Integer, Integer>();
        public double value = 1.0;
        public double net = 0.0;
        public Double targetValue;
        public int fired;

        public Builder setRange(int begin, int end) {
            this.setPosition(BEGIN, begin);
            this.setPosition(END, end);
            return this;
        }

        public Builder setPosition(int slot, int pos) {
            this.positions.put(slot, pos);
            return this;
        }

        public Builder setValue(double value) {
            this.value = value;
            return this;
        }

        public Builder setNet(double net) {
            this.net = net;
            return this;
        }

        public Builder setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public Builder setFired(int fired) {
            this.fired = fired;
            return this;
        }

        public Map<Integer, Position> getSlots(Document doc) {
            TreeMap<Integer, Position> slots = new TreeMap<Integer, Position>();
            for (Map.Entry<Integer, Integer> me : this.positions.entrySet()) {
                slots.put(me.getKey(), doc.lookupFinalPosition(me.getValue()));
            }
            return slots;
        }
    }

    public static class Link {
        private final Synapse synapse;
        private final Activation input;
        private final Activation output;
        public static Comparator<Link> INPUT_COMP = (l1, l2) -> {
            int r = Synapse.INPUT_SYNAPSE_COMP.compare(l1.synapse, l2.synapse);
            if (r != 0) {
                return r;
            }
            return Integer.compare(l1.input.id, l2.input.id);
        };
        public static Comparator<Link> OUTPUT_COMP = (l1, l2) -> {
            int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(l1.synapse, l2.synapse);
            if (r != 0) {
                return r;
            }
            return Integer.compare(l1.output.id, l2.output.id);
        };

        public Link(Synapse s, Activation input, Activation output) {
            this.synapse = s;
            this.input = input;
            this.output = output;
        }

        public Synapse getSynapse() {
            return this.synapse;
        }

        public Activation getInput() {
            return this.input;
        }

        public Activation getOutput() {
            return this.output;
        }

        public boolean isRecurrent() {
            return this.synapse.isRecurrent();
        }

        public boolean isIdentity() {
            return this.synapse.isIdentity();
        }

        public boolean isNegative(Synapse.State s) {
            return this.synapse.isNegative(s);
        }

        public boolean isInactive() {
            return this.synapse.isInactive();
        }

        public void link() {
            this.input.addLink(Linker.Direction.INPUT, this);
            this.output.addLink(Linker.Direction.OUTPUT, this);
        }

        public String toString() {
            return this.synapse + ": " + this.input + " --> " + this.output;
        }
    }

    public class Option
    implements Comparable<Option> {
        public int snId;
        public State state;
        public SearchNode.Decision decision;
        public double weight;
        public int cacheFactor = 1;
        public double p;
        public Map<Link, Option> inputOptions = new TreeMap<Link, Option>(Link.INPUT_COMP);
        public Map<Link, Option> outputOptions = new TreeMap<Link, Option>(Link.OUTPUT_COMP);

        public Option(int snId, SearchNode.Decision d) {
            this.snId = snId;
            this.state = Activation.this.rounds.getLast();
            this.decision = d;
            if (Activation.this.options == null) {
                Activation.this.options = new ArrayList<Option>();
            }
            Activation.this.options.add(this);
        }

        public void setWeight(double weight) {
            this.weight = weight;
            for (Link l : Activation.this.inputLinks.values()) {
                if (l.input.decision != SearchNode.Decision.SELECTED) continue;
                if (l.input.candidate != null) {
                    if (l.input.candidate.id >= Activation.this.candidate.id) continue;
                    SearchNode inputSN = l.input.candidate.currentSearchNode.getParent();
                    this.link(l, inputSN.getCurrentOption());
                    continue;
                }
                this.link(l, l.input.options.get(0));
            }
            for (Link l : Activation.this.outputLinks.values()) {
                if (l.input.decision != SearchNode.Decision.SELECTED || l.output.candidate == null || l.output.candidate.id >= Activation.this.candidate.id) continue;
                SearchNode outputSN = l.output.candidate.currentSearchNode.getParent();
                outputSN.getCurrentOption().link(l, this);
            }
        }

        public void link(Link l, Option in) {
            this.inputOptions.put(l, in);
            in.outputOptions.put(l, this);
        }

        public void setCacheFactor(int cf) {
            this.cacheFactor = cf;
        }

        public Activation getAct() {
            return Activation.this;
        }

        public String toString() {
            return " snId:" + this.snId + " d:" + this.decision + " cacheFactor:" + this.cacheFactor + " w:" + Utils.round(this.weight) + " p:" + this.p + " " + this.state;
        }

        @Override
        public int compareTo(Option o) {
            int r = Integer.compare(this.getAct().getId(), o.getAct().getId());
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.snId, o.snId);
        }
    }

    public class StateChange {
        public Rounds oldRounds;
        public Rounds newRounds;
        public SearchNode.Decision newState;

        public void restoreState(Mode m) {
            Activation.this.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public Activation getActivation() {
            return Activation.this;
        }
    }

    public static enum Mode {
        OLD,
        NEW;

    }

    public static class State {
        public final double value;
        public final double posValue;
        public final double net;
        public final double posNet;
        public final int fired;
        public final double weight;
        public static final State ZERO = new State(0.0, 0.0, 0.0, 0.0, -1, 0.0);

        public State(double value, double posValue, double net, double posNet, int fired, double weight) {
            assert (!Double.isNaN(value));
            this.value = value;
            this.posValue = posValue;
            this.net = net;
            this.posNet = posNet;
            this.fired = fired;
            this.weight = weight;
        }

        public boolean equals(State s) {
            return Math.abs(this.value - s.value) <= INeuron.WEIGHT_TOLERANCE;
        }

        public boolean equalsWithWeights(State s) {
            return this.equals(s) && Math.abs(this.weight - s.weight) <= INeuron.WEIGHT_TOLERANCE;
        }

        public String toString() {
            return "V:" + Utils.round(this.value) + (String)(DEBUG_OUTPUT ? " pV:" + Utils.round(this.posValue) : "") + " Net:" + Utils.round(this.net) + " W:" + Utils.round(this.weight);
        }
    }

    public static class Rounds {
        private boolean[] isQueued = new boolean[3];
        public TreeMap<Integer, State> rounds = new TreeMap();

        public Rounds() {
            this.rounds.put(0, State.ZERO);
        }

        public boolean set(int r, State s) {
            State lr = this.get(r - 1);
            if (lr != null && lr.equalsWithWeights(s)) {
                State or = this.rounds.get(r);
                if (or != null) {
                    this.rounds.remove(r);
                    return !or.equalsWithWeights(s);
                }
                return false;
            }
            State or = this.rounds.put(r, s);
            Iterator<Map.Entry<Integer, State>> it = this.rounds.tailMap(r + 1).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, State> me = it.next();
                if (!me.getValue().equalsWithWeights(s)) continue;
                it.remove();
            }
            return or == null || !or.equalsWithWeights(s);
        }

        public State get(int r) {
            Map.Entry<Integer, State> me = this.rounds.floorEntry(r);
            return me != null ? me.getValue() : null;
        }

        public Rounds copy() {
            Rounds nr = new Rounds();
            nr.rounds.putAll(this.rounds);
            return nr;
        }

        public Integer getLastRound() {
            return !this.rounds.isEmpty() ? this.rounds.lastKey() : null;
        }

        public State getLast() {
            return !this.rounds.isEmpty() ? this.rounds.lastEntry().getValue() : State.ZERO;
        }

        public void setQueued(int r, boolean v) {
            if (r >= this.isQueued.length) {
                this.isQueued = Arrays.copyOf(this.isQueued, this.isQueued.length * 2);
            }
            this.isQueued[r] = v;
        }

        public boolean isQueued(int r) {
            return r < this.isQueued.length ? this.isQueued[r] : false;
        }

        public void reset() {
            this.rounds.clear();
            this.rounds.put(0, State.ZERO);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.rounds.forEach((r, s) -> sb.append(r + ":" + s.value + " "));
            return sb.toString();
        }

        public boolean compare(Rounds r) {
            if (this.rounds.size() != r.rounds.size()) {
                return false;
            }
            for (Map.Entry<Integer, State> me : this.rounds.entrySet()) {
                State sa = me.getValue();
                State sb = r.rounds.get(me.getKey());
                if (sb != null && !(Math.abs(sa.value - sb.value) > 1.0E-7)) continue;
                return false;
            }
            return true;
        }

        public boolean isActive() {
            return this.rounds.size() <= 1 && this.getLast().value > 0.0;
        }
    }

    private static class InputState {
        Link l;
        State s;

        public InputState(Link l, State s) {
            this.l = l;
            this.s = s;
        }
    }
}

