/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayDeque;
import java.util.Map;
import network.aika.Document;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.relation.Relation;

public class Linker {
    private Document doc;
    private ArrayDeque<Activation.Link> queue = new ArrayDeque();

    public Linker(Document doc) {
        this.doc = doc;
    }

    public Activation computeInputActivation(Synapse s, Activation iAct) {
        return iAct;
    }

    private void linkOutputRelations(Activation act) {
        this.linkRelated(act, act, act.getINeuron().getOutputRelations());
    }

    public void linkInput(Activation act) {
        Document doc = act.getDocument();
        for (Synapse s : act.getNeuron().getActiveInputSynapses()) {
            for (Map.Entry<Integer, Relation> me : s.getRelations().entrySet()) {
                Relation rel = me.getValue();
                if (me.getKey() != -1) continue;
                rel.getActivations((INeuron)s.getInput().get(doc), act).forEach(iAct -> this.link(s, (Activation)iAct, act));
            }
        }
    }

    public void lateLinking() {
        int oldSize;
        do {
            oldSize = this.doc.getNumberOfActivations();
            Activation act = null;
            while ((act = this.doc.getNextActivation(act)) != null) {
                this.linkOutputRelations(act);
                act.getInputLinks(false).forEach(l -> this.addToQueue((Activation.Link)l));
            }
            this.doc.getLinker().process();
            this.doc.propagate();
        } while (oldSize != this.doc.getNumberOfActivations());
    }

    public void process() {
        while (!this.queue.isEmpty()) {
            Activation.Link l = this.queue.pollFirst();
            this.linkRelated(l.getInput(), l.getOutput(), l.getSynapse().getRelations());
        }
    }

    private void linkRelated(Activation rAct, Activation oAct, Map<Integer, Relation> relations) {
        Document doc = rAct.getDocument();
        for (Map.Entry<Integer, Relation> me : relations.entrySet()) {
            Synapse s;
            Relation rel = me.getValue();
            Integer relId = me.getKey();
            if (relId == -1 || (s = oAct.getSynapseById(relId)) == null) continue;
            rel.invert().getActivations((INeuron)s.getInput().get(doc), rAct).forEach(iAct -> this.link(s, (Activation)iAct, oAct));
        }
    }

    public void link(Synapse s, Activation iAct, Activation oAct) {
        Activation.Link el;
        if ((iAct = this.computeInputActivation(s, iAct)) == null || iAct.blocked || !this.checkRelations(s, iAct, oAct)) {
            return;
        }
        Activation.Link nl = new Activation.Link(s, iAct, oAct);
        if (oAct.getInputLink(nl) != null) {
            return;
        }
        if (s.isIdentity() && (el = oAct.getLinkBySynapseId(s.getId())) != null && el.getInput() != iAct) {
            return;
        }
        nl.link();
        this.addToQueue(nl);
    }

    private boolean checkRelations(Synapse s, Activation iAct, Activation oAct) {
        for (Map.Entry<Integer, Relation> me : s.getRelations().entrySet()) {
            Synapse relSyn;
            Integer relSynId = me.getKey();
            Relation rel = me.getValue();
            if (!(relSynId == -1 ? !rel.test(iAct, oAct, true) : (relSyn = oAct.getSynapseById(relSynId)) != null && oAct.getInputLinksBySynapse(relSyn).anyMatch(l -> !rel.test(iAct, l.getInput(), false)))) continue;
            return false;
        }
        return true;
    }

    private void addToQueue(Activation.Link l) {
        if (l == null) {
            return;
        }
        if (!l.getSynapse().isNegative(Synapse.State.CURRENT)) {
            this.queue.add(l);
        }
        this.doc.getUpperBoundQueue().add(l);
    }

    public static enum Direction {
        INPUT,
        OUTPUT;

    }
}

