/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.Utils;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Candidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static int MAX_SEARCH_STEPS = Integer.MAX_VALUE;
    public static boolean ENABLE_CACHING = true;
    public static boolean ENABLE_CACHING_COMPARISON = true;
    public static boolean OPTIMIZE_SEARCH = true;
    public static boolean COMPUTE_SOFT_MAX = false;
    private int id;
    private SearchNode excludedParent;
    private SearchNode selectedParent;
    private long visited;
    private Candidate candidate;
    private int level;
    private DebugState debugState;
    private double weightDelta;
    private double accumulatedWeight = 0.0;
    private Map<Activation, Activation.StateChange> modifiedActs = new TreeMap<Activation, Activation.StateChange>(Activation.ACTIVATION_ID_COMP);
    private Step step = Step.INIT;
    private Decision currentDecision = Decision.UNKNOWN;
    private Decision preDecision;
    private SearchNode selectedChild = null;
    private SearchNode excludedChild = null;
    private double selectedWeight = 0.0;
    private double excludedWeight = 0.0;
    private double selectedWeightSum = 0.0;
    private double excludedWeightSum = 0.0;
    private long processVisited;
    private boolean bestPath;
    private int cachedCount = 1;
    private int cachedFactor = 1;
    private Activation.Option option;
    private Decision skip = Decision.UNKNOWN;

    public SearchNode(Document doc, SearchNode selParent, SearchNode exclParent, int level) throws Activation.OscillatingActivationsException {
        this.id = doc.searchNodeIdCounter++;
        this.level = level;
        this.visited = doc.getNewVisitedId();
        this.selectedParent = selParent;
        this.excludedParent = exclParent;
        Candidate c = this.getParent() != null ? this.getParent().candidate : null;
        SearchNode csn = null;
        boolean modified = true;
        if (c != null) {
            c.currentSearchNode = this;
            csn = c.cachedSearchNode;
            if (csn == null || csn.getDecision() != this.getDecision()) {
                Activation act = c.activation;
                act.markDirty(this.visited);
                act.getOutputLinks().forEach(l -> l.getOutput().markDirty(this.visited));
            } else {
                modified = csn.isModified();
                if (modified) {
                    c.debugComputed[2] = c.debugComputed[2] + 1;
                }
            }
        }
        if (modified) {
            this.weightDelta = doc.getValueQueue().process(doc, this);
            this.markDirty();
            if (c != null) {
                c.cachedSearchNode = this;
            }
        } else if (ENABLE_CACHING) {
            c.cachedSearchNode.changeState(Activation.Mode.NEW);
            this.weightDelta = c.cachedSearchNode.weightDelta;
            for (Activation act : c.cachedSearchNode.modifiedActs.keySet()) {
                act.saveOldState(this.modifiedActs, doc.getNewVisitedId());
                act.saveNewState();
            }
        } else {
            this.weightDelta = doc.getValueQueue().process(doc, this);
            if (ENABLE_CACHING_COMPARISON && (Math.abs(this.weightDelta - csn.weightDelta) > 1.0E-5 || !this.compareNewState(csn))) {
                log.error("Cached search node activation do not match the newly computed results.");
                log.info("Computed results (" + this.weightDelta + "):");
                this.dumpDebugState();
                log.info("Cached results (" + csn.weightDelta + "):");
                csn.dumpDebugState();
                throw new RuntimeException("Comparison between cached and computed search node failed!");
            }
        }
        if (c != null) {
            int[] nArray = c.debugComputed;
            int n = modified ? 1 : 0;
            nArray[n] = nArray[n] + 1;
        }
        if (this.getParent() != null) {
            SearchNode pn = this.getParent();
            this.accumulatedWeight = this.weightDelta + pn.accumulatedWeight;
        }
    }

    public int getId() {
        return this.id;
    }

    public Activation.Option getOption() {
        return this.option;
    }

    public Map<Activation, Activation.StateChange> getModifiedActivations() {
        return this.modifiedActs;
    }

    public double getAccumulatedWeight() {
        return this.accumulatedWeight;
    }

    public Activation getActivation() {
        if (this.getParent() != null && this.getParent().candidate != null) {
            return this.getParent().candidate.activation;
        }
        return null;
    }

    public Activation.Option getCurrentOption() {
        switch (this.currentDecision) {
            case SELECTED: {
                return this.selectedChild.option;
            }
            case EXCLUDED: {
                return this.excludedChild.option;
            }
        }
        return null;
    }

    private boolean isModified() {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            if (sc.getActivation().markedDirty > this.visited || sc.newState != sc.getActivation().decision) {
                return true;
            }
            if (!sc.newRounds.isActive() || !sc.getActivation().getOutputLinks().anyMatch(l -> l.getOutput().decision != Decision.UNKNOWN && l.getOutput().markedDirty > this.visited)) continue;
            return true;
        }
        return false;
    }

    private void markDirty() {
        if (this.getParent() == null || this.getParent().candidate == null) {
            return;
        }
        SearchNode csn = this.getParent().candidate.cachedSearchNode;
        TreeSet<Activation> acts = new TreeSet<Activation>(Activation.ACTIVATION_ID_COMP);
        acts.addAll(this.modifiedActs.keySet());
        if (csn != null) {
            acts.addAll(csn.modifiedActs.keySet());
        }
        acts.forEach(act -> {
            Activation.StateChange scb;
            Activation.StateChange sca = this.modifiedActs.get(act);
            Activation.StateChange stateChange = scb = csn != null ? csn.modifiedActs.get(act) : null;
            if (sca == null || scb == null || !sca.newRounds.compare(scb.newRounds)) {
                act.getOutputLinks().forEach(l -> l.getOutput().markDirty(this.visited));
            }
        });
    }

    public boolean compareNewState(SearchNode cachedNode) {
        if (this.modifiedActs == null && cachedNode.modifiedActs == null) {
            return true;
        }
        if (this.modifiedActs == null || cachedNode.modifiedActs == null) {
            return false;
        }
        if (this.modifiedActs.size() != cachedNode.modifiedActs.size()) {
            return false;
        }
        for (Map.Entry<Activation, Activation.StateChange> me : this.modifiedActs.entrySet()) {
            Activation.StateChange sca = me.getValue();
            Activation.StateChange scb = cachedNode.modifiedActs.get(me.getKey());
            if (sca.newRounds.compare(scb.newRounds)) continue;
            return false;
        }
        return true;
    }

    public void dumpDebugState() {
        Object weights = "";
        Decision decision = Decision.UNKNOWN;
        for (SearchNode n = this; n != null && n.level >= 0; n = n.getParent()) {
            log.info(n.level + " " + n.debugState + " DECISION:" + decision + (String)weights + " " + (n.candidate != null ? n.candidate.toString() : "") + " MOD-ACTS:" + n.modifiedActs.size());
            decision = n.getDecision();
            weights = " AW:" + Utils.round(n.accumulatedWeight) + " DW:" + Utils.round(n.weightDelta);
        }
    }

    public static void search(Document doc, SearchNode root, long v, Long timeoutInMilliSeconds) throws TimeoutException, Activation.RecursiveDepthExceededException, Activation.OscillatingActivationsException {
        SearchNode sn = root;
        double returnWeight = 0.0;
        double returnWeightSum = 0.0;
        long startTime = System.currentTimeMillis();
        do {
            if (sn.processVisited != v) {
                sn.step = Step.INIT;
                sn.processVisited = v;
            }
            switch (sn.step) {
                case INIT: {
                    if (sn.level >= doc.candidates.size()) {
                        SearchNode.checkTimeoutCondition(timeoutInMilliSeconds, startTime);
                        returnWeightSum = returnWeight = sn.processResult(doc);
                        sn.step = Step.FINAL;
                        sn = sn.getParent();
                        break;
                    }
                    sn.initStep(doc);
                    sn.step = Step.PREPARE_SELECT;
                    break;
                }
                case PREPARE_SELECT: {
                    sn.step = sn.prepareSelectStep(doc) ? Step.SELECT : Step.PREPARE_EXCLUDE;
                    break;
                }
                case SELECT: {
                    sn.step = Step.POST_SELECT;
                    sn.currentDecision = Decision.SELECTED;
                    sn = sn.selectedChild;
                    break;
                }
                case POST_SELECT: {
                    sn.selectedWeight = returnWeight;
                    sn.selectedWeightSum = returnWeightSum;
                    if (COMPUTE_SOFT_MAX) {
                        sn.selectedChild.option.setWeight(returnWeightSum);
                    }
                    sn.postReturn(sn.selectedChild);
                    sn.step = Step.PREPARE_EXCLUDE;
                    break;
                }
                case PREPARE_EXCLUDE: {
                    sn.step = sn.prepareExcludeStep(doc) ? Step.EXCLUDE : Step.FINAL;
                    break;
                }
                case EXCLUDE: {
                    sn.step = Step.POST_EXCLUDE;
                    sn.currentDecision = Decision.EXCLUDED;
                    sn = sn.excludedChild;
                    break;
                }
                case POST_EXCLUDE: {
                    sn.excludedWeight = returnWeight;
                    sn.excludedWeightSum = returnWeightSum;
                    if (COMPUTE_SOFT_MAX) {
                        sn.excludedChild.option.setWeight(returnWeightSum);
                    }
                    sn.postReturn(sn.excludedChild);
                    sn.step = sn.candidate.repeat && OPTIMIZE_SEARCH ? Step.PREPARE_SELECT : Step.FINAL;
                    break;
                }
                case FINAL: {
                    returnWeight = sn.finalStep();
                    returnWeightSum = sn.getWeightSum();
                    sn.currentDecision = Decision.UNKNOWN;
                    SearchNode pn = sn.getParent();
                    if (pn != null) {
                        pn.skip = sn.getDecision();
                    }
                    sn = pn;
                    break;
                }
            }
        } while (sn != null);
    }

    private static void checkTimeoutCondition(Long timeoutInMilliSeconds, long startTime) throws TimeoutException {
        if (timeoutInMilliSeconds != null && System.currentTimeMillis() > startTime + timeoutInMilliSeconds) {
            throw new TimeoutException("Interpretation search took too long: " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    public double getWeightSum() {
        return this.selectedWeightSum + this.excludedWeightSum;
    }

    private void initStep(Document doc) throws Activation.RecursiveDepthExceededException {
        this.candidate = doc.candidates.get(this.level);
        boolean precondition = this.candidate.activation.isActiveable();
        this.preDecision = this.candidate.activation.inputDecision;
        if (this.preDecision == Decision.UNKNOWN && (!precondition || this.checkExcluded(this.candidate.activation))) {
            this.preDecision = Decision.EXCLUDED;
        }
        if (this.preDecision == Decision.UNKNOWN && !this.candidate.isConflicting() && !this.candidate.activation.hasUndecidedPositiveFeedbackLinks()) {
            this.preDecision = Decision.SELECTED;
        }
        if (this.preDecision == Decision.UNKNOWN && OPTIMIZE_SEARCH) {
            SearchNode asn;
            Decision cd = this.getCachedDecision();
            this.setWeightSum(cd, this.candidate.alternativeCachedWeightSum);
            if (COMPUTE_SOFT_MAX && cd != null && cd != Decision.UNKNOWN && (asn = this.candidate.cachedSearchNode.getAlternative()) != null) {
                ++asn.cachedCount;
            }
            this.preDecision = cd;
        }
        if (doc.searchStepCounter > MAX_SEARCH_STEPS) {
            this.dumpDebugState();
            throw new RuntimeException("Max search step exceeded.");
        }
        ++doc.searchStepCounter;
        this.storeDebugInfos();
    }

    public SearchNode getAlternative() {
        SearchNode pn = this.getParent();
        switch (this.getDecision()) {
            case SELECTED: {
                return pn.excludedChild;
            }
            case EXCLUDED: {
                return pn.selectedChild;
            }
        }
        return null;
    }

    private Decision getCachedDecision() {
        return this.preDecision != Decision.EXCLUDED ? this.candidate.cachedDecision : Decision.UNKNOWN;
    }

    private boolean prepareSelectStep(Document doc) throws Activation.OscillatingActivationsException {
        this.candidate.repeat = false;
        if (this.preDecision == Decision.EXCLUDED) {
            return false;
        }
        if (this.skip == Decision.SELECTED) {
            return false;
        }
        if (doc.getModel().getSkipSelectStep().evaluate(this.candidate.activation)) {
            return false;
        }
        this.candidate.activation.setDecision(Decision.SELECTED, this.visited);
        if (this.candidate.cachedDecision == Decision.UNKNOWN) {
            this.invalidateCachedDecisions();
        }
        this.selectedChild = new SearchNode(doc, this, this.excludedParent, this.level + 1);
        this.candidate.debugDecisionCounts[0] = this.candidate.debugDecisionCounts[0] + 1;
        if (COMPUTE_SOFT_MAX) {
            Activation activation = this.candidate.activation;
            Objects.requireNonNull(activation);
            this.selectedChild.option = activation.new Activation.Option(this.id, Decision.SELECTED);
        }
        return true;
    }

    private boolean prepareExcludeStep(Document doc) throws Activation.RecursiveDepthExceededException, Activation.OscillatingActivationsException {
        if (this.preDecision == Decision.SELECTED) {
            return false;
        }
        if (this.skip == Decision.EXCLUDED) {
            return false;
        }
        if (this.preDecision != Decision.EXCLUDED && this.generatesUnsuppressedExcluded() && !this.candidate.activation.hasUndecidedPositiveFeedbackLinks()) {
            return false;
        }
        this.candidate.activation.setDecision(Decision.EXCLUDED, this.visited);
        this.excludedChild = new SearchNode(doc, this.selectedParent, this, this.level + 1);
        this.candidate.debugDecisionCounts[1] = this.candidate.debugDecisionCounts[1] + 1;
        if (COMPUTE_SOFT_MAX) {
            Activation activation = this.candidate.activation;
            Objects.requireNonNull(activation);
            this.excludedChild.option = activation.new Activation.Option(this.id, Decision.EXCLUDED);
        }
        return true;
    }

    private boolean generatesUnsuppressedExcluded() throws Activation.RecursiveDepthExceededException {
        block0: for (Activation cAct : this.candidate.activation.getConflicts()) {
            if (cAct.decision != Decision.EXCLUDED || !cAct.isActiveable()) continue;
            for (Activation icAct : cAct.getConflicts()) {
                if (this.candidate.activation == icAct || icAct.decision == Decision.EXCLUDED) continue;
                continue block0;
            }
            return true;
        }
        for (Activation cAct : this.candidate.activation.getConflicts()) {
            if (cAct.decision == Decision.EXCLUDED) continue;
            return false;
        }
        return true;
    }

    private void postReturn(SearchNode child) {
        child.changeState(Activation.Mode.OLD);
        this.candidate.activation.setDecision(Decision.UNKNOWN, this.visited);
        this.candidate.activation.rounds.reset();
    }

    private double finalStep() {
        SearchNode cn;
        Decision d;
        Decision cd = this.getCachedDecision();
        if (cd == Decision.UNKNOWN) {
            Decision decision = this.preDecision != Decision.UNKNOWN ? this.preDecision : (d = this.selectedWeight >= this.excludedWeight ? Decision.SELECTED : Decision.EXCLUDED);
            if (this.preDecision != Decision.EXCLUDED) {
                this.candidate.cachedDecision = d;
                this.candidate.alternativeCachedWeightSum = this.getWeightSum(this.candidate.cachedDecision);
            }
        } else {
            d = cd;
        }
        SearchNode searchNode = cn = d == Decision.SELECTED ? this.selectedChild : this.excludedChild;
        if (cn != null && cn.bestPath) {
            this.candidate.bestChildNode = cn;
            this.bestPath = true;
        }
        if (!(COMPUTE_SOFT_MAX || this.bestPath && d == Decision.SELECTED)) {
            this.selectedChild = null;
        }
        if (!(COMPUTE_SOFT_MAX || this.bestPath && d == Decision.EXCLUDED)) {
            this.excludedChild = null;
        }
        return d == Decision.SELECTED ? this.selectedWeight : this.excludedWeight;
    }

    private void invalidateCachedDecisions() {
        this.candidate.activation.getOutputLinks().filter(l -> !l.isNegative(Synapse.State.CURRENT)).forEach(l -> SearchNode.invalidateCachedDecision(l.getOutput()));
    }

    public static void invalidateCachedDecision(Activation act) throws Activation.RecursiveDepthExceededException {
        Candidate pos = act.candidate;
        if (pos != null && pos.cachedDecision == Decision.EXCLUDED) {
            pos.cachedDecision = Decision.UNKNOWN;
            pos.repeat = true;
        }
        for (Activation c : act.getConflicts()) {
            Candidate neg = c.candidate;
            if (neg == null || neg.cachedDecision != Decision.SELECTED) continue;
            neg.cachedDecision = Decision.UNKNOWN;
        }
    }

    private double processResult(Document doc) {
        double accNW = this.accumulatedWeight;
        if (this.level > doc.selectedSearchNode.level || accNW > this.getSelectedAccumulatedWeight(doc)) {
            doc.selectedSearchNode = this;
            SearchNode.storeFinalState(this);
            this.bestPath = true;
        } else {
            this.bestPath = false;
        }
        return this.accumulatedWeight;
    }

    private static void storeFinalState(SearchNode sn) {
        while (sn != null) {
            if (sn.candidate != null) {
                Activation act = sn.candidate.activation;
                act.finalRounds = act.rounds.copy();
                act.finalDecision = act.decision;
            }
            sn = sn.getParent();
        }
    }

    public static void computeCachedFactor(SearchNode sn) {
        while (sn != null) {
            switch (sn.currentDecision) {
                case UNKNOWN: {
                    sn.currentDecision = Decision.SELECTED;
                    if (sn.selectedChild == null) break;
                    sn = sn.selectedChild;
                    sn.computeCacheFactor();
                    break;
                }
                case SELECTED: {
                    sn.currentDecision = Decision.EXCLUDED;
                    if (sn.excludedChild == null) break;
                    sn = sn.excludedChild;
                    sn.computeCacheFactor();
                    break;
                }
                case EXCLUDED: {
                    sn = sn.getParent();
                }
            }
        }
    }

    private double getWeightSum(Decision d) {
        switch (d) {
            case SELECTED: {
                return this.excludedWeightSum;
            }
            case EXCLUDED: {
                return this.selectedWeightSum;
            }
        }
        return 0.0;
    }

    private void setWeightSum(Decision d, double weightSum) {
        switch (d) {
            case SELECTED: {
                this.excludedWeightSum = weightSum;
                break;
            }
            case EXCLUDED: {
                this.selectedWeightSum = weightSum;
            }
        }
    }

    private void computeCacheFactor() {
        SearchNode pn = this.getParent();
        this.cachedFactor = (pn != null ? pn.cachedFactor : 1) * this.cachedCount;
        this.option.setCacheFactor(this.cachedFactor);
    }

    private double getSelectedAccumulatedWeight(Document doc) {
        return doc.selectedSearchNode != null ? doc.selectedSearchNode.accumulatedWeight : -1.0;
    }

    private boolean checkExcluded(Activation ref) throws Activation.RecursiveDepthExceededException {
        for (Activation cn : ref.getConflicts()) {
            if (cn.decision != Decision.SELECTED) continue;
            return true;
        }
        return false;
    }

    public String pathToString() {
        return (this.selectedParent != null ? this.selectedParent.pathToString() : "") + " - " + this.toString();
    }

    public String toString() {
        return "id:" + this.id + " actId:" + this.candidate.activation.getId() + " Decision:" + this.getDecision() + " curDec:" + this.currentDecision;
    }

    public void changeState(Activation.Mode m) {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode sn) {
        return Integer.compare(this.id, sn.id);
    }

    public SearchNode getParent() {
        return this.getDecision() == Decision.SELECTED ? this.selectedParent : this.excludedParent;
    }

    public Decision getDecision() {
        return this.excludedParent == null || this.selectedParent != null && this.selectedParent.id > this.excludedParent.id ? Decision.SELECTED : Decision.EXCLUDED;
    }

    private void storeDebugInfos() {
        this.debugState = this.preDecision != Decision.UNKNOWN ? DebugState.LIMITED : (this.getCachedDecision() != Decision.UNKNOWN ? DebugState.CACHED : DebugState.EXPLORE);
        int n = this.debugState.ordinal();
        this.candidate.debugCounts[n] = this.candidate.debugCounts[n] + 1;
    }

    public static interface SkipSelectStep {
        public boolean evaluate(Activation var1);
    }

    public static class TimeoutException
    extends RuntimeException {
        public TimeoutException(String message) {
            super(message);
        }
    }

    private static enum Step {
        INIT,
        PREPARE_SELECT,
        SELECT,
        POST_SELECT,
        PREPARE_EXCLUDE,
        EXCLUDE,
        POST_EXCLUDE,
        FINAL;

    }

    public static enum DebugState {
        CACHED,
        LIMITED,
        EXPLORE;

    }

    public static enum Decision {
        SELECTED('S'),
        EXCLUDED('E'),
        UNKNOWN('U');

        char s;

        private Decision(char s) {
            this.s = s;
        }
    }
}

