/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public abstract class PositionRelation
extends Relation {
    public int fromSlot;
    public int toSlot;

    public PositionRelation() {
    }

    public PositionRelation(int fromSlot, int toSlot) {
        this.fromSlot = fromSlot;
        this.toSlot = toSlot;
    }

    public PositionRelation(int fromSlot, int toSlot, boolean optional, boolean follow) {
        this.fromSlot = fromSlot;
        this.toSlot = toSlot;
        this.optional = optional;
        this.follow = follow;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct, boolean allowUndefined) {
        Position toPos = linkedAct.lookupSlot(this.toSlot);
        if (allowUndefined && toPos == null) {
            return true;
        }
        return this.optional || this.test(act.lookupSlot(this.fromSlot), toPos);
    }

    public abstract boolean test(Position var1, Position var2);

    @Override
    public void mapSlots(Map<Integer, Position> slots, Activation act) {
    }

    @Override
    public void linksOutputs(Set<Integer> results) {
        results.add(this.toSlot);
    }

    @Override
    public int compareTo(Relation rel) {
        int r = super.compareTo(rel);
        if (r != 0) {
            return r;
        }
        PositionRelation pr = (PositionRelation)rel;
        r = Integer.compare(this.fromSlot, pr.fromSlot);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.toSlot, pr.toSlot);
        return r;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.fromSlot);
        out.writeInt(this.toSlot);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.fromSlot = in.readInt();
        this.toSlot = in.readInt();
    }

    @Override
    public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
        Position pos = linkedAct.lookupSlot(this.toSlot);
        if (pos == null) {
            return Stream.empty();
        }
        return this.getActivations(n, pos).filter(act -> this.test((Activation)act, linkedAct, false));
    }

    public abstract Stream<Activation> getActivations(INeuron var1, Position var2);

    public static class GreaterThan
    extends PositionRelation {
        public static int TYPE = 11;
        private boolean orEquals;
        private int maxLength = Integer.MAX_VALUE;

        public GreaterThan() {
        }

        public GreaterThan(int fromSlot, int toSlot, boolean orEquals) {
            super(fromSlot, toSlot);
            this.orEquals = orEquals;
        }

        public GreaterThan(int fromSlot, int toSlot, boolean orEquals, boolean optional, boolean follow, int maxLength) {
            super(fromSlot, toSlot, optional, follow);
            this.orEquals = orEquals;
            this.maxLength = maxLength;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new LessThan(this.toSlot, this.fromSlot, this.orEquals, this.optional, this.follow, this.maxLength);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new GreaterThan(this.fromSlot, this.toSlot, this.orEquals, optional, follow, this.maxLength);
        }

        @Override
        public boolean isExact() {
            return false;
        }

        @Override
        public boolean test(Position a, Position b) {
            if (a == b) {
                return this.orEquals;
            }
            return a.getFinalPosition() != null && b.getFinalPosition() != null && a.getFinalPosition() > b.getFinalPosition() && a.getFinalPosition() - b.getFinalPosition() < this.maxLength;
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Position pos) {
            if (!this.follow) {
                return Stream.empty();
            }
            return n.getActivations(pos.getDocument(), this.fromSlot, pos, this.orEquals, this.fromSlot, new Position(pos.getDocument(), this.maxLength != Integer.MAX_VALUE ? pos.getFinalPosition() + this.maxLength : Integer.MAX_VALUE), true);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeBoolean(this.orEquals);
            out.writeInt(this.maxLength);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            super.readFields(in, m);
            this.orEquals = in.readBoolean();
            this.maxLength = in.readInt();
        }

        public String toString() {
            return "GT" + (this.orEquals ? "E" : "") + "(" + this.fromSlot + "," + this.toSlot + ")";
        }

        static {
            GreaterThan.registerRelation(TYPE, () -> new GreaterThan());
        }
    }

    public static class LessThan
    extends PositionRelation {
        public static int TYPE = 10;
        private boolean orEquals;
        private int maxLength = Integer.MAX_VALUE;

        public LessThan() {
        }

        public LessThan(int fromSlot, int toSlot, boolean orEquals) {
            super(fromSlot, toSlot);
            this.orEquals = orEquals;
        }

        public LessThan(int fromSlot, int toSlot, boolean orEquals, boolean optional, boolean follow, int maxLength) {
            super(fromSlot, toSlot, optional, follow);
            this.orEquals = orEquals;
            this.maxLength = maxLength;
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new GreaterThan(this.toSlot, this.fromSlot, this.orEquals, this.optional, this.follow, this.maxLength);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new LessThan(this.fromSlot, this.toSlot, this.orEquals, optional, follow, this.maxLength);
        }

        @Override
        public boolean isExact() {
            return false;
        }

        @Override
        public boolean test(Position a, Position b) {
            if (a == b) {
                return this.orEquals;
            }
            return a.getFinalPosition() != null && b.getFinalPosition() != null && a.getFinalPosition() < b.getFinalPosition() && b.getFinalPosition() - a.getFinalPosition() < this.maxLength;
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Position pos) {
            if (!this.follow) {
                return Stream.empty();
            }
            return n.getActivations(pos.getDocument(), this.fromSlot, new Position(pos.getDocument(), this.maxLength != Integer.MAX_VALUE ? pos.getFinalPosition() - this.maxLength : Integer.MIN_VALUE), true, this.fromSlot, pos, this.orEquals);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeBoolean(this.orEquals);
            out.writeInt(this.maxLength);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            super.readFields(in, m);
            this.orEquals = in.readBoolean();
            this.maxLength = in.readInt();
        }

        public String toString() {
            return "LT" + (this.orEquals ? "E" : "") + "(" + this.fromSlot + "," + this.toSlot + ")";
        }

        static {
            LessThan.registerRelation(TYPE, () -> new LessThan());
        }
    }

    public static class Equals
    extends PositionRelation {
        public static int TYPE = 0;

        public Equals() {
        }

        public Equals(int fromSlot, int toSlot) {
            super(fromSlot, toSlot);
        }

        public Equals(int fromSlot, int toSlot, boolean optional, boolean follow) {
            super(fromSlot, toSlot, optional, follow);
        }

        @Override
        public int getType() {
            return TYPE;
        }

        @Override
        public Relation invert() {
            return new Equals(this.toSlot, this.fromSlot, this.optional, this.follow);
        }

        @Override
        public Relation setOptionalAndFollow(boolean optional, boolean follow) {
            return new Equals(this.fromSlot, this.toSlot, optional, follow);
        }

        @Override
        public boolean test(Position a, Position b) {
            return a == b;
        }

        @Override
        public void mapSlots(Map<Integer, Position> slots, Activation act) {
            slots.put(this.toSlot, act.lookupSlot(this.fromSlot));
        }

        @Override
        public boolean isExact() {
            return true;
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Position pos) {
            if (!this.follow) {
                return Stream.empty();
            }
            return n.getActivations(pos.getDocument(), this.fromSlot, pos, true, this.fromSlot, pos, true);
        }

        public String toString() {
            return "EQUALS(" + this.fromSlot + "," + this.toSlot + ")";
        }

        static {
            Equals.registerRelation(TYPE, () -> new Equals());
        }
    }
}

