/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import network.aika.Document;
import network.aika.Utils;
import network.aika.lattice.activation.InputActivation;
import network.aika.lattice.activation.OrActivation;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.State;
import network.aika.neuron.activation.link.Direction;
import network.aika.neuron.activation.link.Link;
import network.aika.neuron.activation.search.Decision;
import network.aika.neuron.activation.search.Option;
import network.aika.neuron.activation.search.SearchNode;

public class Activation
implements Comparable<Activation> {
    public static int BEGIN = 0;
    public static int END = 1;
    public static final Comparator<Activation> ACTIVATION_ID_COMP = Comparator.comparingInt(act -> act.id);
    public static int MAX_SELF_REFERENCING_DEPTH = 5;
    public static boolean DEBUG_OUTPUT = false;
    public static final Activation MIN_ACTIVATION = new Activation(Integer.MIN_VALUE);
    public static final Activation MAX_ACTIVATION = new Activation(Integer.MAX_VALUE);
    private int id;
    private INeuron neuron;
    private Document doc;
    private long visited = 0L;
    private Map<Integer, Position> slots = new TreeMap<Integer, Position>();
    private OrActivation inputNodeActivation;
    private InputActivation outputNodeActivation;
    private TreeMap<Link, Link> inputLinks = new TreeMap(Link.INPUT_COMP);
    private TreeMap<Link, Link> outputLinks = new TreeMap(Link.OUTPUT_COMP);
    private double upperBound;
    private double lowerBound;
    public Option rootOption;
    public Option currentOption = this.rootOption = new Option(null, this, null);
    public Option finalOption;
    boolean ubQueued = false;
    private long markedHasCandidate;
    private Double targetValue;
    private Double inputValue;
    private Integer sequence;
    private Integer candidateId;
    public long markedAncDesc;
    public boolean blocked;
    public Decision cachedDecision = Decision.UNKNOWN;
    public double alternativeCachedWeightSum;
    public SearchNode cachedSearchNode;
    public SearchNode bestChildNode;
    public int[] debugCounts = new int[3];
    public int[] debugDecisionCounts = new int[3];
    public static Comparator<Activation> CANDIDATE_COMP = (act1, act2) -> {
        int r;
        Iterator<Map.Entry<Integer, Position>> ita = act1.getSlots().entrySet().iterator();
        Iterator<Map.Entry<Integer, Position>> itb = act2.getSlots().entrySet().iterator();
        while (ita.hasNext() || itb.hasNext()) {
            Map.Entry<Integer, Position> meb;
            Map.Entry<Integer, Position> mea = ita.hasNext() ? ita.next() : null;
            Map.Entry<Integer, Position> entry = meb = itb.hasNext() ? itb.next() : null;
            if (mea == null && meb == null) break;
            if (mea == null && meb != null) {
                return -1;
            }
            if (mea != null && meb == null) {
                return 1;
            }
            r = Integer.compare(mea.getKey(), meb.getKey());
            if (r != 0) {
                return r;
            }
            r = Position.compare(act1.lookupSlot(mea.getKey()), act2.lookupSlot(meb.getKey()));
            if (r == 0) continue;
            return r;
        }
        if ((r = Integer.compare(act1.getSequence(), act2.getSequence())) != 0) {
            return r;
        }
        return Integer.compare(act1.getCandidateId(), act2.getCandidateId());
    };

    private Activation(int id) {
        this.id = id;
    }

    public Activation(Document doc, INeuron neuron, Map<Integer, Position> slots) {
        this.id = doc.getNewActivationId();
        this.doc = doc;
        this.neuron = neuron;
        this.slots = slots;
        neuron.register(this);
    }

    public void setInputNodeActivation(OrActivation inputNodeActivation) {
        this.inputNodeActivation = inputNodeActivation;
    }

    public OrActivation getInputNodeActivation() {
        return this.inputNodeActivation;
    }

    public InputActivation getOutputNodeActivation() {
        return this.outputNodeActivation;
    }

    public void setOutputNodeActivation(InputActivation outputNodeActivation) {
        this.outputNodeActivation = outputNodeActivation;
    }

    public Map<Integer, Position> getSlots() {
        return this.slots;
    }

    public Position lookupSlot(int slot) {
        Position pos = this.slots.get(slot);
        if (pos == null) {
            pos = new Position(this.doc);
            this.slots.put(slot, pos);
        }
        return pos;
    }

    public Integer length() {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Position pos : this.slots.values()) {
            if (pos.getFinalPosition() == null) {
                return null;
            }
            min = Math.min(min, pos.getFinalPosition());
            max = Math.max(max, pos.getFinalPosition());
        }
        if (min > max) {
            return 0;
        }
        return max - min;
    }

    public int getId() {
        return this.id;
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getThreadId() {
        return this.doc.getThreadId();
    }

    public long getNewVisitedId() {
        return this.doc.getNewVisitedId();
    }

    public long getVisitedId() {
        return this.visited;
    }

    public boolean checkVisited(long v) {
        if (this.visited == v) {
            return false;
        }
        this.visited = v;
        return true;
    }

    public String getLabel() {
        return this.getINeuron().getLabel();
    }

    public INeuron.Type getType() {
        return this.getINeuron().getType();
    }

    public String getText() {
        return this.doc.getText(this.lookupSlot(BEGIN), this.lookupSlot(END));
    }

    public INeuron getINeuron() {
        return this.neuron;
    }

    public Neuron getNeuron() {
        return (Neuron)this.neuron.getProvider();
    }

    public Synapse getSynapseById(int synapseId) {
        return this.getNeuron().getSynapseById(synapseId);
    }

    public boolean checkDependenciesSatisfied(long v) {
        return !this.getInputLinks().anyMatch(l -> l.getInput().markedHasCandidate != v && !l.isRecurrent() && l.getInput().getUpperBound() > 0.0);
    }

    public void markHasCandidate(long v) {
        this.markedHasCandidate = v;
        for (Link l : this.outputLinks.values()) {
            if (l.getOutput().getType() != INeuron.Type.INHIBITORY) continue;
            l.getOutput().markHasCandidate(v);
        }
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double ub) {
        this.upperBound = ub;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lb) {
        this.lowerBound = lb;
    }

    public Double getTargetValue() {
        return this.targetValue;
    }

    public Double getInputValue() {
        return this.inputValue;
    }

    public Decision getDecision() {
        return this.currentOption.decision;
    }

    public Decision getNextDecision(Option parent, SearchNode sn) {
        if (sn == null) {
            return Decision.UNKNOWN;
        }
        if (this == sn.getActivation()) {
            return sn.getDecision();
        }
        return parent.decision;
    }

    public Decision getFinalDecision() {
        return this.finalOption.decision;
    }

    public void addLink(Direction dir, Link l) {
        this.getLinks(dir.getInverted()).put(l, l);
    }

    public TreeMap<Link, Link> getLinks(Direction dir) {
        switch (dir) {
            case INPUT: {
                return this.inputLinks;
            }
            case OUTPUT: {
                return this.outputLinks;
            }
        }
        return null;
    }

    public Link getLinkBySynapseId(int synapseId) {
        for (Link l : this.inputLinks.values()) {
            if (l.getSynapse().getId() != synapseId) continue;
            return l;
        }
        return null;
    }

    public Stream<Link> getInputLinks() {
        return this.inputLinks.values().stream();
    }

    public Stream<Link> getOutputLinks() {
        return this.outputLinks.values().stream();
    }

    public Link getInputLink(Link l) {
        return this.inputLinks.get(l);
    }

    public Stream<Link> getLinksBySynapse(Direction dir, Synapse syn) {
        return this.getLinks(dir).subMap(new Link(syn, MIN_ACTIVATION, MIN_ACTIVATION), new Link(syn, MAX_ACTIVATION, MAX_ACTIVATION)).values().stream();
    }

    public double process(SearchNode sn) throws OscillatingActivationsException, RecursiveDepthExceededException {
        State oldState = this.currentOption.getState();
        State s = this.computeValueAndWeight(sn);
        if (this.currentOption.searchNode != sn) {
            if (this.currentOption.decision != Decision.UNKNOWN && this.currentOption.getState().equalsWithWeights(s)) {
                return 0.0;
            }
            if (this == sn.getActivation() && s.getPreferredDecision() != sn.getDecision()) {
                return 0.0;
            }
            this.saveState(sn);
        }
        if (this.currentOption.setState(s)) {
            this.doc.getValueQueue().propagateActivationValue(this, sn, !oldState.lowerBoundEquals(s), !oldState.upperBoundEquals(s));
        }
        return s.weight - oldState.weight;
    }

    public State computeValueAndWeight(SearchNode sn) throws RecursiveDepthExceededException {
        double net;
        INeuron n = this.getINeuron();
        INeuron.SynapseSummary ss = n.getSynapseSummary();
        double netUB = net = n.getTotalBias(Synapse.State.CURRENT);
        Integer fired = null;
        for (InputState is : this.getInputStates(sn)) {
            Synapse s = is.l.getSynapse();
            Activation iAct = is.l.getInput();
            if (iAct == this) continue;
            double x = Math.min(s.getLimit(), is.s.value) * s.getWeight();
            net += x;
            netUB += Math.min(s.getLimit(), is.s.ub) * s.getWeight();
            net += s.computeRelationWeights(is.l);
            if (s.isRecurrent() || s.isNegative(Synapse.State.CURRENT)) continue;
            fired = Utils.max(fired, iAct.currentOption.getState().fired);
        }
        for (Synapse s : n.getPassiveInputSynapses()) {
            double x = s.getWeight() * s.getInput().getPassiveInputFunction().getActivationValue(s, this);
            net += x;
            netUB += x;
        }
        return new State(n.getActivationFunction().f(net), n.getActivationFunction().f(netUB), net, net > 0.0 ? Integer.valueOf((fired != null ? fired : 0) + (this.getType() == INeuron.Type.EXCITATORY ? 1 : 0)) : null, Math.max(0.0, Math.min(-ss.getNegRecSum(), net)));
    }

    public void processBounds() throws RecursiveDepthExceededException {
        double oldUpperBound = this.upperBound;
        this.computeBounds();
        if (Math.abs(this.upperBound - oldUpperBound) > 0.01) {
            for (Link l : this.outputLinks.values()) {
                this.doc.getUpperBoundQueue().add(l);
            }
        }
        if (oldUpperBound <= 0.0 && this.upperBound > 0.0 && !this.blocked) {
            this.getINeuron().propagate(this);
        }
    }

    public void computeBounds() throws RecursiveDepthExceededException {
        INeuron n = this.getINeuron();
        INeuron.SynapseSummary ss = n.getSynapseSummary();
        double ub = n.getTotalBias(Synapse.State.CURRENT) + ss.getPosRecSum();
        double lb = n.getTotalBias(Synapse.State.CURRENT) + ss.getPosRecSum();
        for (Link l : this.inputLinks.values()) {
            Activation iAct;
            Synapse s = l.getSynapse();
            if (s.isInactive() || (iAct = l.getInput()) == this) continue;
            double x = s.getWeight();
            if (s.isNegative(Synapse.State.CURRENT)) {
                if (!s.isRecurrent()) {
                    ub += Math.min(s.getLimit(), iAct.lowerBound) * x;
                }
                lb += s.getLimit() * x;
                continue;
            }
            ub += Math.min(s.getLimit(), iAct.upperBound) * x;
            lb += Math.min(s.getLimit(), iAct.lowerBound) * x;
            double rlw = s.computeRelationWeights(l);
            ub += rlw;
            lb += rlw;
        }
        for (Synapse s : n.getPassiveInputSynapses()) {
            double x = s.getWeight() * s.getInput().getPassiveInputFunction().getActivationValue(s, this);
            ub += x;
            lb += x;
        }
        this.upperBound = n.getActivationFunction().f(ub);
        this.lowerBound = n.getActivationFunction().f(lb);
    }

    private List<InputState> getInputStates(SearchNode sn) {
        ArrayList<InputState> tmp = new ArrayList<InputState>();
        Synapse lastSynapse = null;
        InputState maxInputState = null;
        for (Link l : this.inputLinks.values()) {
            if (l.isInactive()) continue;
            if (lastSynapse != null && lastSynapse != l.getSynapse()) {
                tmp.add(maxInputState);
                maxInputState = null;
            }
            State s = l.getInput().getInputState(l.getSynapse(), this, sn);
            if (maxInputState == null || maxInputState.s.value < s.value) {
                maxInputState = new InputState(l, s);
            }
            lastSynapse = l.getSynapse();
        }
        if (maxInputState != null) {
            tmp.add(maxInputState);
        }
        return tmp;
    }

    public void setInputState(Builder input) {
        this.rootOption.decision = Decision.SELECTED;
        this.rootOption.p = 1.0;
        this.rootOption.setState(new State(input.value, input.value, input.net, input.fired, 0.0));
        this.currentOption = this.rootOption;
        this.finalOption = this.rootOption;
        this.inputValue = input.value;
        this.upperBound = input.value;
        this.lowerBound = input.value;
        this.targetValue = input.targetValue;
    }

    private State getInputState(Synapse s, Activation act, SearchNode sn) {
        State is = this.currentOption.getState();
        if (s.isNegative(Synapse.State.CURRENT)) {
            is = !this.checkSelfReferencing(act) ? new State(is.ub, is.value, 0.0, null, 0.0) : State.ZERO;
        }
        if (act.getType() == INeuron.Type.INHIBITORY) {
            return is;
        }
        Decision nd = act.getNextDecision(act.currentOption, sn);
        if (nd == Decision.SELECTED) {
            return new State(is.ub, is.ub, 0.0, 0, 0.0);
        }
        if (nd == Decision.EXCLUDED) {
            return new State(is.value, is.value, 0.0, 0, 0.0);
        }
        return null;
    }

    public boolean needsPropagation(SearchNode sn, boolean lowerBoundChange, boolean upperBoundChange) {
        if (this.getType() == INeuron.Type.INHIBITORY) {
            return upperBoundChange || lowerBoundChange;
        }
        if (this.getType() == INeuron.Type.EXCITATORY) {
            Decision nd = this.getNextDecision(this.currentOption, sn);
            if (nd == Decision.SELECTED) {
                return upperBoundChange;
            }
            if (nd == Decision.EXCLUDED) {
                return lowerBoundChange;
            }
        }
        return false;
    }

    public boolean checkSelfReferencing(Activation act) {
        Activation act1 = this.getInputExcitatoryActivation();
        if (act1 == null) {
            return false;
        }
        if (act == act1) {
            return true;
        }
        Integer f1 = act1.currentOption.getState().fired;
        Integer f2 = act.currentOption.getState().fired;
        if (f1 == null) {
            return false;
        }
        if (f2 != null && f1 > f2) {
            return act1.checkSelfReferencingRecursiveStep(act, 0);
        }
        return act.checkSelfReferencingRecursiveStep(act1, 0);
    }

    private boolean checkSelfReferencingRecursiveStep(Activation act, int depth) {
        if (this == act) {
            return true;
        }
        if (depth > 0 && this.currentOption.getState().value <= 0.0) {
            return false;
        }
        if (depth > MAX_SELF_REFERENCING_DEPTH) {
            return false;
        }
        if (this.getType() == INeuron.Type.INHIBITORY) {
            Link strongestLink = this.getStrongestLink();
            if (strongestLink == null) {
                return false;
            }
            return strongestLink.getInput().checkSelfReferencingRecursiveStep(act, depth + 1);
        }
        for (Link l : this.inputLinks.values()) {
            Synapse s = l.getSynapse();
            if (s.isWeak(Synapse.State.CURRENT) || s.isNegative(Synapse.State.CURRENT) || !l.getInput().checkSelfReferencingRecursiveStep(act, depth + 1)) continue;
            return true;
        }
        return false;
    }

    private Activation getInputExcitatoryActivation() {
        if (this.getType() != INeuron.Type.INHIBITORY) {
            return this;
        }
        Link l = this.getStrongestLink();
        if (l == null) {
            return null;
        }
        return l.getInput().getInputExcitatoryActivation();
    }

    private Link getStrongestLink() {
        if (this.inputLinks.size() == 1) {
            return this.inputLinks.firstEntry().getValue();
        }
        return this.inputLinks.values().stream().filter(l -> l.getInput().currentOption.getState().value > 0.0).max(Comparator.comparing(l -> l.getInput().currentOption.getState().value)).orElse(null);
    }

    public List<Link> getFinalInputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.inputLinks.values()) {
            if (!l.getInput().isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public List<Link> getFinalOutputActivationLinks() {
        ArrayList<Link> results = new ArrayList<Link>();
        for (Link l : this.outputLinks.values()) {
            if (!l.getOutput().isFinalActivation()) continue;
            results.add(l);
        }
        return results;
    }

    public boolean isFinalActivation() {
        return this.getFinalState().value > 0.0;
    }

    public State getFinalState() {
        return this.finalOption != null ? this.finalOption.getState() : State.ZERO;
    }

    public double getValue() {
        return this.getFinalState().value;
    }

    public Integer getSequence() {
        if (this.sequence != null) {
            return this.sequence;
        }
        this.sequence = 0;
        this.inputLinks.values().stream().filter(l -> !l.isRecurrent()).forEach(l -> {
            this.sequence = Math.max(this.sequence, l.getInput().getSequence() + 1);
        });
        return this.sequence;
    }

    public Integer getCandidateId() {
        return this.candidateId;
    }

    public void setCandidateId(Integer candidateId) {
        this.candidateId = candidateId;
    }

    public boolean match(Predicate<Link> filter) {
        Synapse ls = null;
        boolean matched = false;
        for (Link l : this.inputLinks.navigableKeySet()) {
            Synapse s = l.getSynapse();
            if (ls != null && ls != s) {
                if (!matched) {
                    return false;
                }
                matched = false;
            }
            if (filter.test(l)) {
                matched = true;
            }
            ls = s;
        }
        return matched;
    }

    public void computeSoftMax() {
        this.rootOption.traverse(o -> o.computeRemainingWeight());
        double[] offset = new double[]{Double.MAX_VALUE};
        this.rootOption.traverse(o -> {
            offset[0] = Math.min(offset[0], Math.log(o.cacheFactor) + o.remainingWeight);
        });
        double[] norm = new double[]{0.0};
        this.rootOption.traverse(o -> {
            norm[0] = norm[0] + (Math.log(o.cacheFactor) + o.remainingWeight - offset[0]);
        });
        this.rootOption.traverse(o -> {
            if (o.decision == Decision.SELECTED) {
                o.p = Math.exp(Math.log(o.cacheFactor) + o.remainingWeight - offset[0]) / norm[0];
            }
        });
    }

    public String toString() {
        return this.id + " " + this.getNeuron().getId() + ":" + this.getINeuron().typeToString() + " " + this.getLabel() + " " + this.slotsToString() + " " + this.identityToString() + " -  UB:" + Utils.round(this.upperBound) + (String)(this.inputValue != null ? " IV:" + Utils.round(this.inputValue) : "") + (String)(this.targetValue != null ? " TV:" + Utils.round(this.targetValue) : "") + " V:" + (Serializable)(this.currentOption != null ? Double.valueOf(Utils.round(this.currentOption.getState().value)) : "-") + " FV:" + (Serializable)(this.finalOption != null ? Double.valueOf(Utils.round(this.finalOption.getState().value)) : "-");
    }

    public String searchStateToString() {
        return this.id + " " + this.getNeuron().getId() + ":" + this.getLabel() + "  CD:" + this.cachedDecision + " LIMITED:" + this.debugCounts[SearchNode.DebugState.LIMITED.ordinal()] + " CACHED:" + this.debugCounts[SearchNode.DebugState.CACHED.ordinal()] + " EXPLORE:" + this.debugCounts[SearchNode.DebugState.EXPLORE.ordinal()] + " SELECTED:" + this.debugDecisionCounts[0] + " EXCLUDED:" + this.debugDecisionCounts[1];
    }

    public String toStringDetailed() {
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.addPadding("" + this.id, 3) + " ");
        sb.append(Utils.addPadding(this.getINeuron().typeToString(), 10) + " - ");
        sb.append(Utils.addPadding((String)(this.getType() == INeuron.Type.EXCITATORY ? "" + (Serializable)(this.getFinalDecision() != null ? this.getFinalDecision() : "X") : ""), 8) + " - ");
        sb.append(this.slotsToString());
        sb.append(" \"");
        if (this.getINeuron().getOutputText() != null) {
            sb.append(Utils.collapseText(this.getINeuron().getOutputText(), 7));
        } else {
            sb.append(Utils.collapseText(this.doc.getText(this.lookupSlot(BEGIN), this.lookupSlot(END)), 7));
        }
        sb.append("\"");
        sb.append(this.identityToString());
        sb.append(" - ");
        sb.append(this.getLabel());
        if (DEBUG_OUTPUT) {
            sb.append(" - UB:");
            sb.append(Utils.round(this.upperBound));
        }
        if (SearchNode.COMPUTE_SOFT_MAX) {
            sb.append(" Exp:");
            sb.append(this.getExpectedState());
        }
        sb.append(" - ");
        State fs = this.getFinalState();
        if (fs != null) {
            sb.append(fs);
        }
        if (this.inputValue != null) {
            sb.append(" - IV:" + Utils.round(this.inputValue));
        }
        if (this.targetValue != null) {
            sb.append(" - TV:" + Utils.round(this.targetValue));
        }
        return sb.toString();
    }

    public State getExpectedState() {
        return State.ZERO;
    }

    @Override
    public int compareTo(Activation act) {
        return Integer.compare(this.id, act.id);
    }

    public String slotsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Map.Entry<Integer, Position> me : this.slots.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(me.getKey());
            sb.append(":");
            sb.append(me.getValue());
        }
        sb.append(")");
        return sb.toString();
    }

    public String identityToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (");
        boolean first = true;
        for (Link l : this.inputLinks.values()) {
            if (!l.isIdentity()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(l.getInput().id);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public String linksToString() {
        StringBuilder sb = new StringBuilder();
        for (Link l : this.inputLinks.values()) {
            sb.append("  " + l.getInput().getLabel() + "  W:" + l.getSynapse().getWeight() + "\n");
        }
        return sb.toString();
    }

    public void saveState(SearchNode sn) {
        this.currentOption = new Option(this.currentOption, this, sn);
        if (sn.getModifiedActivations() != null) {
            sn.getModifiedActivations().put(this.currentOption.act, this.currentOption);
        }
    }

    public static class RecursiveDepthExceededException
    extends RuntimeException {
        public RecursiveDepthExceededException() {
            super("MAX_PREDECESSOR_DEPTH limit exceeded. Probable cause is a non recurrent loop.");
        }
    }

    public static class OscillatingActivationsException
    extends RuntimeException {
        private String activationsDump;

        public OscillatingActivationsException(String activationsDump) {
            super("Maximum number of rounds reached. The network might be oscillating.");
            this.activationsDump = activationsDump;
        }

        public String getActivationsDump() {
            return this.activationsDump;
        }
    }

    public static class Builder {
        public SortedMap<Integer, Integer> positions = new TreeMap<Integer, Integer>();
        public double value = 1.0;
        public double net = 0.0;
        public Double targetValue;
        public int fired;

        public Builder setRange(int begin, int end) {
            this.setPosition(BEGIN, begin);
            this.setPosition(END, end);
            return this;
        }

        public Builder setPosition(int slot, int pos) {
            this.positions.put(slot, pos);
            return this;
        }

        public Builder setValue(double value) {
            this.value = value;
            return this;
        }

        public Builder setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public Map<Integer, Position> getSlots(Document doc) {
            TreeMap<Integer, Position> slots = new TreeMap<Integer, Position>();
            for (Map.Entry<Integer, Integer> me : this.positions.entrySet()) {
                slots.put(me.getKey(), doc.lookupFinalPosition(me.getValue()));
            }
            return slots;
        }
    }

    public static enum Mode {
        OLD,
        NEW;

    }

    private static class InputState {
        Link l;
        State s;

        public InputState(Link l, State s) {
            this.l = l;
            this.s = s;
        }
    }
}

