/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation.link;

import java.util.Comparator;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.link.Direction;

public class Link {
    private final Synapse synapse;
    private final Activation input;
    private final Activation output;
    public static Comparator<Link> INPUT_COMP = (l1, l2) -> {
        int r = Synapse.INPUT_SYNAPSE_COMP.compare(l1.synapse, l2.synapse);
        if (r != 0) {
            return r;
        }
        return Integer.compare(l1.input.getId(), l2.input.getId());
    };
    public static Comparator<Link> OUTPUT_COMP = (l1, l2) -> {
        int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(l1.synapse, l2.synapse);
        if (r != 0) {
            return r;
        }
        return Integer.compare(l1.output.getId(), l2.output.getId());
    };

    public Link(Synapse s, Activation input, Activation output) {
        this.synapse = s;
        this.input = input;
        this.output = output;
    }

    public Synapse getSynapse() {
        return this.synapse;
    }

    public Activation getInput() {
        return this.input;
    }

    public Activation getOutput() {
        return this.output;
    }

    public boolean isRecurrent() {
        return this.synapse.isRecurrent();
    }

    public boolean isIdentity() {
        return this.synapse.isIdentity();
    }

    public boolean isNegative(Synapse.State s) {
        return this.synapse.isNegative(s);
    }

    public boolean isInactive() {
        return this.synapse.isInactive();
    }

    public void link() {
        this.input.addLink(Direction.INPUT, this);
        this.output.addLink(Direction.OUTPUT, this);
    }

    public String toString() {
        return this.synapse + ": " + this.input + " --> " + this.output;
    }
}

