/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import network.aika.Document;
import network.aika.Utils;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.State;
import network.aika.neuron.activation.link.Link;
import network.aika.neuron.activation.search.Decision;
import network.aika.neuron.activation.search.SearchNode;

public class Option
implements Comparable<Option> {
    public static final State INITIAL_STATE = new State(0.0, Double.MAX_VALUE, 0.0, null, 0.0);
    private State state = INITIAL_STATE;
    public Activation act;
    public SearchNode searchNode;
    private Option parent;
    private List<Option> children = new ArrayList<Option>();
    public Decision decision;
    private double weight;
    public double remainingWeight;
    public int cacheFactor = 1;
    public double p;
    public Map<Link, Option> inputOptions = new TreeMap<Link, Option>(Link.INPUT_COMP);
    public Map<Link, Option> outputOptions = new TreeMap<Link, Option>(Link.OUTPUT_COMP);
    private boolean isQueued;
    public int round;

    public Option(Option parent, Activation act, SearchNode sn) {
        this.act = act;
        this.searchNode = sn;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
        this.decision = act.getNextDecision(parent, sn);
    }

    public boolean setState(State s) {
        if (this.state.equalsWithWeights(s)) {
            return false;
        }
        ++this.round;
        if (this.round > Document.MAX_ROUND) {
            throw new Activation.OscillatingActivationsException(this.act.getDocument().activationsToString());
        }
        this.state = s;
        return true;
    }

    public State getState() {
        return this.state;
    }

    public void setQueued(boolean v) {
        this.isQueued = v;
    }

    public boolean isQueued() {
        return this.isQueued;
    }

    public void restoreState(Activation.Mode m) {
        this.act.currentOption = m == Activation.Mode.OLD ? this.parent : this;
    }

    public boolean compare(Option r) {
        return this.state.equalsWithWeights(r.state);
    }

    public boolean isActive() {
        return this.state.value > 0.0;
    }

    public void link() {
        for (Link l : this.act.getInputLinks().collect(Collectors.toList())) {
            Activation iAct = l.getInput();
            if (iAct.currentOption == null || iAct.currentOption.decision == Decision.UNKNOWN || !iAct.currentOption.isActive()) continue;
            this.link(l, iAct.currentOption);
        }
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void link(Link l, Option in) {
        this.inputOptions.put(l, in);
        in.outputOptions.put(l, this);
    }

    public void setCacheFactor(int cf) {
        this.cacheFactor = cf;
    }

    public Activation getAct() {
        return this.act;
    }

    public void computeRemainingWeight() {
        double sum = 0.0;
        for (Option c : this.children) {
            sum += c.weight;
        }
        this.remainingWeight = this.weight - sum;
    }

    public void traverse(Consumer<Option> f) {
        for (Option c : this.children) {
            c.traverse(f);
            f.accept(c);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" snId:" + (Serializable)(this.searchNode != null ? Integer.valueOf(this.searchNode.getId()) : "-") + " d:" + this.decision + " cacheFactor:" + this.cacheFactor + " w:" + Utils.round(this.weight) + " p:" + this.p + " value:" + Utils.round(this.state.value));
        return sb.toString();
    }

    @Override
    public int compareTo(Option o) {
        int r = Integer.compare(this.getAct().getId(), o.getAct().getId());
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.searchNode.getId(), o.searchNode.getId());
    }
}

