/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class MultiRelation
extends Relation {
    public static final int ID = 1;
    private SortedSet<Relation> relations;

    public MultiRelation() {
        this.relations = new TreeSet<Relation>();
    }

    public MultiRelation(Relation ... rels) {
        this.relations = new TreeSet<Relation>(Arrays.asList(rels));
    }

    public MultiRelation(SortedSet<Relation> rels) {
        this.relations = rels;
    }

    public SortedSet<Relation> getRelations() {
        return this.relations;
    }

    public int size() {
        return this.relations.size();
    }

    public void addRelation(Relation r) {
        for (Relation rel : this.relations) {
            if (rel.compareTo(r) != 0) continue;
            return;
        }
        this.relations.add(r);
    }

    public void removeRelation(Relation r) {
        this.relations.removeIf(rel -> rel.compareTo(r) == 0);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct, boolean allowUndefined) {
        for (Relation rel : this.relations) {
            if (rel.test(act, linkedAct, allowUndefined)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Relation invert() {
        TreeSet<Relation> invRels = new TreeSet<Relation>();
        for (Relation rel : this.relations) {
            invRels.add(rel.invert());
        }
        return new MultiRelation(invRels);
    }

    @Override
    public void mapSlots(Map<Integer, Position> slots, Activation act) {
        for (Relation rel : this.relations) {
            rel.mapSlots(slots, act);
        }
    }

    @Override
    public boolean isExact() {
        for (Relation rel : this.relations) {
            if (!rel.isExact()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
        if (this.relations.isEmpty()) {
            return n.getActivations(linkedAct.getDocument());
        }
        return this.relations.first().getActivations(n, linkedAct).filter(act -> {
            for (Relation rel : this.relations) {
                if (rel.test((Activation)act, linkedAct, false)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public int compareTo(Relation rel) {
        int r = super.compareTo(rel);
        if (r != 0) {
            return r;
        }
        MultiRelation mr = (MultiRelation)rel;
        r = Integer.compare(this.relations.size(), mr.relations.size());
        if (r != 0) {
            return r;
        }
        Iterator ita = this.relations.iterator();
        Iterator itb = mr.relations.iterator();
        while (ita.hasNext() || itb.hasNext()) {
            Relation b;
            Relation a = (Relation)ita.next();
            r = a.compareTo(b = (Relation)itb.next());
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.relations.size());
        for (Relation rel : this.relations) {
            rel.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            this.relations.add(Relation.read(in, m));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MULTI(");
        boolean first = true;
        for (Relation rel : this.relations) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(rel.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        MultiRelation.registerRelation(1, () -> new MultiRelation());
    }
}

