/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice.refinement;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.TreeMap;
import network.aika.Model;
import network.aika.Provider;
import network.aika.Writable;
import network.aika.lattice.Node;
import network.aika.lattice.OrNode;

public class OrEntry
implements Comparable<OrEntry>,
Writable {
    public int[] synapseIds;
    public TreeMap<Integer, Integer> revSynapseIds = new TreeMap();
    public Provider<? extends Node> parent;
    public Provider<OrNode> child;

    private OrEntry() {
    }

    public OrEntry(int[] synapseIds, Provider<? extends Node> parent, Provider<OrNode> child) {
        this.synapseIds = synapseIds;
        for (int ofs = 0; ofs < synapseIds.length; ++ofs) {
            this.revSynapseIds.put(synapseIds[ofs], ofs);
        }
        this.parent = parent;
        this.child = child;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.synapseIds.length);
        for (int i = 0; i < this.synapseIds.length; ++i) {
            Integer ofs = this.synapseIds[i];
            out.writeBoolean(ofs != null);
            out.writeInt(ofs);
        }
        out.writeInt(this.parent.getId());
        out.writeInt(this.child.getId());
    }

    public static OrEntry read(DataInput in, Model m) throws IOException {
        OrEntry rv = new OrEntry();
        rv.readFields(in, m);
        return rv;
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int l = in.readInt();
        this.synapseIds = new int[l];
        for (int i = 0; i < l; ++i) {
            if (!in.readBoolean()) continue;
            Integer ofs = in.readInt();
            this.synapseIds[i] = ofs;
            this.revSynapseIds.put(ofs, i);
        }
        this.parent = m.lookupNodeProvider(in.readInt());
        this.child = m.lookupNodeProvider(in.readInt());
    }

    @Override
    public int compareTo(OrEntry oe) {
        int r = this.child.compareTo(oe.child);
        if (r != 0) {
            return r;
        }
        r = this.parent.compareTo(oe.parent);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.synapseIds.length, oe.synapseIds.length);
        if (r != 0) {
            return r;
        }
        for (int i = 0; i < this.synapseIds.length; ++i) {
            r = Integer.compare(this.synapseIds[i], oe.synapseIds[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }
}

