/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.io.Serializable;
import network.aika.Utils;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.search.Decision;

public class State {
    public final double value;
    public final double ub;
    public final double net;
    public final Integer fired;
    public final double weight;
    public static final State ZERO = new State(0.0, 0.0, 0.0, null, 0.0);

    public State(double value, double ub, double net, Integer fired, double weight) {
        assert (!Double.isNaN(value));
        this.value = value;
        this.ub = ub;
        this.net = net;
        this.fired = fired;
        this.weight = weight;
    }

    public boolean equals(State s) {
        return this.lowerBoundEquals(s) && this.upperBoundEquals(s);
    }

    public boolean lowerBoundEquals(State s) {
        return Math.abs(this.value - s.value) <= INeuron.WEIGHT_TOLERANCE;
    }

    public boolean upperBoundEquals(State s) {
        return Math.abs(this.ub - s.ub) <= INeuron.WEIGHT_TOLERANCE;
    }

    public boolean equalsWithWeights(State s) {
        return this.equals(s) && Math.abs(this.weight - s.weight) <= INeuron.WEIGHT_TOLERANCE;
    }

    public Decision getPreferredDecision() {
        return this.value > 0.0 ? Decision.SELECTED : Decision.EXCLUDED;
    }

    public String toString() {
        return "V:" + Utils.round(this.value) + " UB:" + (Serializable)(this.ub == Double.MAX_VALUE ? "MAX" : Double.valueOf(Utils.round(this.ub))) + " Net:" + Utils.round(this.net) + " W:" + Utils.round(this.weight);
    }
}

