/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice.refinement;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.relation.Relation;

public class RelationsMap
implements Comparable<RelationsMap>,
Writable {
    public static final RelationsMap MIN = new RelationsMap();
    public static final RelationsMap MAX = new RelationsMap();
    public Relation[] relations;

    public RelationsMap() {
    }

    public RelationsMap(Relation[] relations) {
        this.relations = relations;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.relations.length);
        for (int i = 0; i < this.relations.length; ++i) {
            Relation rel = this.relations[i];
            out.writeBoolean(rel != null);
            if (rel == null) continue;
            rel.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int l = in.readInt();
        this.relations = new Relation[l];
        for (int i = 0; i < l; ++i) {
            if (!in.readBoolean()) continue;
            this.relations[i] = Relation.read(in, m);
        }
    }

    public static RelationsMap read(DataInput in, Model m) throws IOException {
        RelationsMap k = new RelationsMap();
        k.readFields(in, m);
        return k;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.relations.length; ++i) {
            Relation rel = this.relations[i];
            if (rel == null) continue;
            sb.append(i + ":" + rel + ", ");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(RelationsMap rm) {
        if (this == MIN) {
            return -1;
        }
        if (rm == MIN) {
            return 1;
        }
        if (this == MAX) {
            return 1;
        }
        if (rm == MAX) {
            return -1;
        }
        int r = Integer.compare(this.relations.length, rm.relations.length);
        if (r != 0) {
            return r;
        }
        for (int i = 0; i < this.relations.length; ++i) {
            Relation ra = this.relations[i];
            Relation rb = rm.relations[i];
            if (ra == null && rb == null) continue;
            if (ra == null && rb != null) {
                return -1;
            }
            if (ra != null && rb == null) {
                return 1;
            }
            r = ra.compareTo(rb);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public int length() {
        return this.relations.length;
    }

    public Relation get(int i) {
        return this.relations[i];
    }

    public int size() {
        if (this.relations.length == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.relations.length; ++i) {
            if (this.relations[i] == null) continue;
            ++count;
        }
        return count;
    }

    public boolean isExact() {
        for (Relation rel : this.relations) {
            if (rel.isExact()) continue;
            return false;
        }
        return true;
    }
}

