/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import network.aika.Model;
import network.aika.Provider;
import network.aika.Writable;
import network.aika.lattice.Node;
import network.aika.neuron.Neuron;

public abstract class AbstractNode<P extends Provider<? extends AbstractNode>>
implements Writable {
    public volatile int lastUsedDocumentId = 0;
    public volatile boolean modified;
    protected P provider;
    private Set<String> modelLabels;

    public Set<String> getModelLabels() {
        if (this.modelLabels == null) {
            this.modelLabels = new TreeSet<String>();
        }
        return this.modelLabels;
    }

    public void addModelLabel(String modelLabel) {
        if (modelLabel != null) {
            this.getModelLabels().add(modelLabel);
        }
    }

    public P getProvider() {
        return this.provider;
    }

    public void setModified() {
        this.modified = true;
    }

    public void suspend() {
    }

    public void reactivate() {
    }

    public String getLabel() {
        return null;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.modelLabels != null) {
            for (String modelLabel : this.modelLabels) {
                out.writeBoolean(true);
                out.writeUTF(modelLabel);
            }
        }
        out.writeBoolean(false);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        while (in.readBoolean()) {
            this.getModelLabels().add(in.readUTF());
        }
    }

    public static <P extends Provider> AbstractNode read(DataInput in, P p) throws IOException {
        AbstractNode n = in.readBoolean() ? p.getModel().readNeuron(in, (Neuron)p) : Node.readNode(in, p);
        return n;
    }

    public abstract void delete(Set<String> var1);

    public abstract boolean isNeuron();
}

