/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice.refinement;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import network.aika.Model;
import network.aika.Provider;
import network.aika.Writable;
import network.aika.lattice.AndNode;
import network.aika.lattice.Node;

public class RefValue
implements Writable {
    public Integer[] offsets;
    public Integer[] reverseOffsets;
    public int refOffset;
    public Provider<? extends Node> parent;
    public Provider<AndNode> child;

    private RefValue() {
    }

    public RefValue(Integer[] offsets, int refOffset, Provider<? extends Node> parent) {
        this.offsets = offsets;
        this.reverseOffsets = new Integer[offsets.length + 1];
        for (int i = 0; i < offsets.length; ++i) {
            this.reverseOffsets[offsets[i].intValue()] = i;
        }
        this.refOffset = refOffset;
        this.parent = parent;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.offsets.length);
        for (int i = 0; i < this.offsets.length; ++i) {
            Integer ofs = this.offsets[i];
            out.writeBoolean(ofs != null);
            out.writeInt(ofs);
        }
        out.writeInt(this.refOffset);
        out.writeInt(this.parent.getId());
        out.writeInt(this.child.getId());
    }

    public static RefValue read(DataInput in, Model m) throws IOException {
        RefValue rv = new RefValue();
        rv.readFields(in, m);
        return rv;
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int l = in.readInt();
        this.offsets = new Integer[l];
        this.reverseOffsets = new Integer[l + 1];
        for (int i = 0; i < l; ++i) {
            Integer ofs;
            if (!in.readBoolean()) continue;
            this.offsets[i] = ofs = Integer.valueOf(in.readInt());
            this.reverseOffsets[ofs.intValue()] = i;
        }
        this.refOffset = in.readInt();
        this.parent = m.lookupNodeProvider(in.readInt());
        this.child = m.lookupNodeProvider(in.readInt());
    }
}

