/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import network.aika.Document;
import network.aika.Model;
import network.aika.Utils;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.link.Link;
import network.aika.neuron.relation.Relation;

public class Synapse
implements Writable {
    public static final int OUTPUT = -1;
    public static double TOLERANCE = 1.0E-7;
    public static final Comparator<Synapse> INPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.input.compareTo(s2.input);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    public static final Comparator<Synapse> OUTPUT_SYNAPSE_COMP = (s1, s2) -> {
        int r = s1.output.compareTo(s2.output);
        if (r != 0) {
            return r;
        }
        return Integer.compare(s1.id, s2.id);
    };
    private Neuron input;
    private Neuron output;
    private Integer id;
    private boolean isRecurrent;
    private boolean identity;
    private Map<Integer, Relation> relations = new TreeMap<Integer, Relation>();
    private boolean inactive;
    private boolean inactiveNew;
    private double weight;
    private double weightDelta;
    private double limit = 1.0;
    private double limitDelta;
    boolean isWeak;

    public Synapse() {
    }

    public Synapse(Neuron input, Neuron output, Integer id) {
        this.id = id;
        this.input = input;
        this.output = output;
    }

    public Neuron getInput() {
        return this.input;
    }

    public Neuron getOutput() {
        return this.output;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean isRecurrent() {
        return this.isRecurrent;
    }

    public void setRecurrent(boolean recurrent) {
        this.isRecurrent = recurrent;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public Map<Integer, Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(Map<Integer, Relation> relations) {
        this.relations = relations;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public boolean isInactive(State s) {
        return s == State.CURRENT ? this.inactive : this.inactiveNew;
    }

    public void setInactive(State s, boolean inactive) {
        if (s == State.CURRENT) {
            this.inactive = inactive;
        } else if (s == State.NEXT) {
            this.inactiveNew = inactive;
        }
    }

    public double getWeight() {
        return this.weight;
    }

    public double getLimit() {
        return this.limit;
    }

    public double getNewWeight() {
        return this.weight + this.weightDelta;
    }

    public double getNewLimit() {
        return this.limit + this.limitDelta;
    }

    public double getWeight(State s) {
        return s == State.CURRENT ? this.weight : this.getNewWeight();
    }

    public double getLimit(State s) {
        return s == State.CURRENT ? this.limit : this.getNewLimit();
    }

    public double getWeightDelta() {
        return this.weightDelta;
    }

    public double getLimitDelta() {
        return this.limitDelta;
    }

    public void link() {
        this.verify();
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = in.getId() < out.getId();
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        this.input.lock.acquireWriteLock();
        this.input.activeOutputSynapses.put(this, this);
        this.input.lock.releaseWriteLock();
        this.output.lock.acquireWriteLock();
        this.output.activeInputSynapses.put(this, this);
        this.output.inputSynapsesById.put(this.id, this);
        this.output.lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        if (out.getType() == INeuron.Type.EXCITATORY) {
            out.inputSynapses.put(this, this);
            out.setModified();
        }
        if (out.getType() == INeuron.Type.INHIBITORY) {
            in.outputSynapses.put(this, this);
            in.setModified();
        }
        out.registerSynapseId(this.id);
        if (in.isPassiveInputNeuron()) {
            out.registerPassiveInputSynapse(this);
        }
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    public void unlink() {
        INeuron in = (INeuron)this.input.get();
        INeuron out = (INeuron)this.output.get();
        boolean dir = this.input.getId() < out.getId();
        (dir ? in : out).lock.acquireWriteLock();
        (dir ? out : in).lock.acquireWriteLock();
        this.input.lock.acquireWriteLock();
        this.input.activeOutputSynapses.remove(this);
        this.input.lock.releaseWriteLock();
        this.output.lock.acquireWriteLock();
        this.output.activeInputSynapses.remove(this);
        this.output.inputSynapsesById.remove(this.id);
        this.output.lock.releaseWriteLock();
        this.removeLinkInternal(in, out);
        (dir ? in : out).lock.releaseWriteLock();
        (dir ? out : in).lock.releaseWriteLock();
    }

    private void verify() {
        if ((this.isRecurrent || this.isNegative(State.CURRENT)) && this.output.getType() == INeuron.Type.INHIBITORY) {
            throw new InvalidInhibitoryNeuronSynapse();
        }
    }

    private void removeLinkInternal(INeuron in, INeuron out) {
        if (out.getType() == INeuron.Type.EXCITATORY && out.inputSynapses.remove(this) != null) {
            out.setModified();
        }
        if (out.getType() == INeuron.Type.INHIBITORY && in.outputSynapses.remove(this) != null) {
            in.setModified();
        }
    }

    public double getMaxInputValue() {
        return this.limit * this.weight;
    }

    public boolean exists() {
        if (((INeuron)this.input.get()).outputSynapses.containsKey(this)) {
            return true;
        }
        return ((INeuron)this.output.get()).inputSynapses.containsKey(this);
    }

    public void commit() {
        this.weight += this.weightDelta;
        this.weightDelta = 0.0;
        this.limit += this.limitDelta;
        this.limitDelta = 0.0;
        this.inactive = this.inactiveNew;
        this.isWeak = this.isWeakIntern(State.CURRENT);
    }

    public boolean isZero() {
        return Math.abs(this.weight) < TOLERANCE;
    }

    public double computeRelationWeights(Link l) {
        return 0.0;
    }

    public double computeMaxRelationWeights() {
        return 0.0;
    }

    public boolean isWeak(State state) {
        return this.isWeak;
    }

    public boolean isWeakIntern(State state) {
        double w = this.getLimit(state) * this.getWeight(state);
        INeuron n = (INeuron)this.output.get();
        switch (n.getType()) {
            case EXCITATORY: {
                return w < n.getBias();
            }
            case INHIBITORY: {
                return w < -n.getBias();
            }
            case INPUT: {
                return false;
            }
        }
        return false;
    }

    public void updateDelta(Document doc, double weightDelta, double limitDelta) {
        this.weightDelta += weightDelta;
        this.limitDelta += limitDelta;
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public void update(Document doc, double weight, double limit) {
        this.weightDelta = weight - this.weight;
        this.limitDelta = limit - this.limit;
        if (doc != null) {
            doc.notifyWeightModified(this);
        }
    }

    public boolean isNegative(State s) {
        return this.getWeight(s) < 0.0;
    }

    public Relation getRelationById(Integer id) {
        return this.relations.get(id);
    }

    public String toString() {
        return "S ID:" + this.id + " NW:" + Utils.round(this.getNewWeight()) + " rec:" + this.isRecurrent + " " + this.input + "->" + this.output;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeBoolean(this.isRecurrent);
        out.writeBoolean(this.identity);
        out.writeInt(this.input.getId());
        out.writeInt(this.output.getId());
        out.writeInt(this.relations.size());
        for (Map.Entry<Integer, Relation> me : this.relations.entrySet()) {
            out.writeInt(me.getKey());
            me.getValue().write(out);
        }
        out.writeDouble(this.weight);
        out.writeDouble(this.limit);
        out.writeBoolean(this.inactive);
        out.writeBoolean(this.isWeak);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.id = in.readInt();
        this.isRecurrent = in.readBoolean();
        this.identity = in.readBoolean();
        this.input = m.lookupNeuron(in.readInt());
        this.output = m.lookupNeuron(in.readInt());
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            Integer relId = in.readInt();
            this.relations.put(relId, Relation.read(in, m));
        }
        this.weight = in.readDouble();
        this.limit = in.readDouble();
        this.inactive = in.readBoolean();
        this.isWeak = in.readBoolean();
    }

    public static Synapse createOrReplace(Document doc, Integer synapseId, Neuron inputNeuron, Neuron outputNeuron, SynapseFactory synapseFactory) {
        outputNeuron.get(doc);
        inputNeuron.get(doc);
        outputNeuron.lock.acquireWriteLock();
        Synapse synapse = (Synapse)outputNeuron.inputSynapsesById.get(synapseId);
        if (synapse != null) {
            synapse.unlink();
        }
        outputNeuron.lock.releaseWriteLock();
        if (synapse == null) {
            synapse = synapseFactory.createSynapse(inputNeuron, outputNeuron, synapseId);
        } else {
            synapse.input = inputNeuron;
            synapse.output = outputNeuron;
        }
        if (synapseId == null) {
            synapse.id = ((INeuron)outputNeuron.get(doc)).getNewSynapseId();
        }
        synapse.link();
        return synapse;
    }

    public boolean linksAnyOutput() {
        return this.relations.get(-1) != null;
    }

    public class InvalidInhibitoryNeuronSynapse
    extends RuntimeException {
        public InvalidInhibitoryNeuronSynapse() {
            super("An inhibitory neuron is not allowed to have recurrent or negative input synapses.");
        }
    }

    public static interface SynapseFactory {
        public Synapse createSynapse(Neuron var1, Neuron var2, Integer var3);
    }

    public static class Builder
    implements Neuron.Builder {
        private boolean recurrent;
        private Neuron neuron;
        double weight;
        double limit = 1.0;
        private boolean identity;
        private Integer synapseId;

        public Integer getSynapseId() {
            return this.synapseId;
        }

        public Builder setRecurrent(boolean recurrent) {
            this.recurrent = recurrent;
            return this;
        }

        public Builder setNeuron(Neuron neuron) {
            assert (neuron != null);
            this.neuron = neuron;
            return this;
        }

        public Builder setNeuron(INeuron neuron) {
            assert (neuron != null);
            this.neuron = (Neuron)neuron.getProvider();
            return this;
        }

        public Builder setWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public Builder setLimit(double limit) {
            this.limit = limit;
            return this;
        }

        public Builder setIdentity(boolean identity) {
            this.identity = identity;
            return this;
        }

        public Builder setSynapseId(int synapseId) {
            assert (synapseId >= 0);
            this.synapseId = synapseId;
            return this;
        }

        @Override
        public void registerSynapseIds(Neuron n) {
            n.registerSynapseId(this.synapseId);
        }

        public Synapse getSynapse(Neuron outputNeuron) {
            Synapse s = Synapse.createOrReplace(null, this.synapseId, this.neuron, outputNeuron, this.getSynapseFactory());
            s.isRecurrent = this.recurrent;
            s.identity = this.identity;
            return s;
        }

        protected SynapseFactory getSynapseFactory() {
            return (input, output, id) -> new Synapse(input, output, id);
        }
    }

    public static enum State {
        NEXT,
        CURRENT;

    }
}

