/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.Writable;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.MultiRelation;
import network.aika.neuron.relation.PositionRelation;

public abstract class Relation
implements Comparable<Relation>,
Writable {
    public static Map<Integer, RelationFactory> relationRegistry = new TreeMap<Integer, RelationFactory>();
    public static Relation EQUALS = new MultiRelation(new PositionRelation.Equals(Activation.BEGIN, Activation.BEGIN), new PositionRelation.Equals(Activation.END, Activation.END));
    public static Relation BEGIN_EQUALS = new PositionRelation.Equals(Activation.BEGIN, Activation.BEGIN);
    public static Relation END_EQUALS = new PositionRelation.Equals(Activation.END, Activation.END);
    public static Relation BEGIN_TO_END_EQUALS = new PositionRelation.Equals(Activation.BEGIN, Activation.END);
    public static Relation END_TO_BEGIN_EQUALS = new PositionRelation.Equals(Activation.END, Activation.BEGIN);
    public static Relation CONTAINS = new MultiRelation(new PositionRelation.LessThan(Activation.BEGIN, Activation.BEGIN, true), new PositionRelation.GreaterThan(Activation.END, Activation.END, true, Integer.MAX_VALUE));
    public static Relation CONTAINED_IN = new MultiRelation(new PositionRelation.GreaterThan(Activation.BEGIN, Activation.BEGIN, true), new PositionRelation.LessThan(Activation.END, Activation.END, true, Integer.MAX_VALUE));
    public static Relation OVERLAPS = new MultiRelation(new PositionRelation.LessThan(Activation.BEGIN, Activation.END, false), new PositionRelation.GreaterThan(Activation.END, Activation.BEGIN, false, Integer.MAX_VALUE));
    public static Relation BEFORE = new PositionRelation.LessThan(Activation.END, Activation.BEGIN, true);
    public static Relation AFTER = new PositionRelation.GreaterThan(Activation.BEGIN, Activation.END, true);
    public static Relation ANY = new Any();

    @Override
    public int compareTo(Relation rel) {
        return Integer.compare(this.getType(), rel.getType());
    }

    public static void registerRelation(int relationType, RelationFactory rf) {
        relationRegistry.put(relationType, rf);
    }

    public abstract int getType();

    public abstract boolean test(Activation var1, Activation var2, boolean var3);

    public abstract Relation invert();

    public abstract void mapSlots(Map<Integer, Position> var1, Activation var2);

    public Collection<Relation> getLeafRelations() {
        return Collections.singletonList(this);
    }

    public Relation getRelation(Relation r) {
        if (this.compareTo(r) == 0) {
            return this;
        }
        return null;
    }

    public void setFromSynapseId(int fromSynapseId) {
    }

    public void setToSynapseId(int toSynapseId) {
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.getType());
    }

    public static Relation read(DataInput in, Model m) throws IOException {
        RelationFactory rf = relationRegistry.get(in.readInt());
        Relation rel = rf.create();
        rel.readFields(in, m);
        return rel;
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
    }

    public abstract boolean isExact();

    public abstract Stream<Activation> getActivations(INeuron var1, Activation var2);

    public void link(Neuron n, int from, int to) {
        Relation.addRelation(to, from, n, this);
        Relation.addRelation(from, to, n, this.invert());
    }

    public static void addRelation(Integer synId, Integer targetSynId, Neuron n, Relation rel) {
        Relation.addRelation(Relation.getRelationsMap(targetSynId, n), synId, targetSynId, n, rel);
    }

    public static void addRelation(Map<Integer, Relation> relMap, Integer synId, Integer targetSynId, Neuron n, Relation r) {
        Synapse s;
        if (targetSynId == -1 && ((s = n.getSynapseById(synId)) == null || r.isExact() && n.getType() == INeuron.Type.INHIBITORY && !s.isInactive())) {
            return;
        }
        Relation existingRel = relMap.get(synId);
        if (existingRel == null) {
            relMap.put(synId, r);
        } else if (existingRel instanceof MultiRelation) {
            MultiRelation mr = (MultiRelation)existingRel;
            mr.addRelation(r);
        } else if (existingRel.compareTo(r) != 0) {
            MultiRelation mr = new MultiRelation();
            mr.addRelation(existingRel);
            mr.addRelation(r);
            relMap.put(synId, mr);
        }
    }

    public static void removeRelation(Integer synId, Integer targetSynId, Neuron n, Relation r) {
        Relation.removeRelation(Relation.getRelationsMap(targetSynId, n), synId, r);
    }

    public static void removeRelation(Map<Integer, Relation> relMap, Integer synId, Relation r) {
        Relation existingRel = relMap.get(synId);
        if (existingRel == null) {
            return;
        }
        if (existingRel.compareTo(r) == 0) {
            relMap.remove(synId);
        } else if (existingRel instanceof MultiRelation) {
            MultiRelation mr = (MultiRelation)existingRel;
            mr.removeRelation(r);
            if (mr.size() == 1) {
                relMap.put(synId, mr.getLeafRelations().iterator().next());
            }
        }
    }

    public static Map<Integer, Relation> getRelationsMap(int synapseId, Neuron n) {
        if (synapseId == -1) {
            return ((INeuron)n.get()).getOutputRelations();
        }
        Synapse s = n.getSynapseById(synapseId);
        return s.getRelations();
    }

    public static class Any
    extends Relation {
        public static int ID = 100;

        @Override
        public int getType() {
            return ID;
        }

        @Override
        public boolean test(Activation act, Activation linkedAct, boolean allowUndefined) {
            return true;
        }

        @Override
        public Relation invert() {
            return this;
        }

        @Override
        public void mapSlots(Map<Integer, Position> slots, Activation act) {
        }

        @Override
        public boolean isExact() {
            return false;
        }

        @Override
        public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
            return n.getActivations(linkedAct.getDocument());
        }

        static {
            Any.registerRelation(ID, () -> ANY);
        }
    }

    public static class Builder
    implements Neuron.Builder {
        protected int from;
        protected int to;
        protected Relation relation;

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public Builder setFrom(int synapseId) {
            assert (synapseId >= -1);
            this.from = synapseId;
            return this;
        }

        public Builder setTo(int synapseId) {
            assert (synapseId >= -1);
            this.to = synapseId;
            return this;
        }

        public Builder setRelation(Relation rel) {
            this.relation = rel;
            return this;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void connect(Neuron n) {
            this.getRelation().link(n, this.from, this.to);
        }

        @Override
        public void registerSynapseIds(Neuron n) {
            n.registerSynapseId(this.from);
            n.registerSynapseId(this.to);
            this.relation.setFromSynapseId(this.from);
            this.relation.setToSynapseId(this.to);
        }
    }

    public static interface RelationFactory {
        public Relation create();
    }
}

