/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import network.aika.Document;
import network.aika.neuron.activation.Activation;

public class Position {
    public static final Position MIN = new Position(null, Integer.MIN_VALUE);
    public static final Position MAX = new Position(null, Integer.MAX_VALUE);
    private SortedMap<ActKey, Activation> activations = new TreeMap<ActKey, Activation>();
    private Document doc;
    private int id;
    private Integer finalPosition;

    public Position(Document doc) {
        this(doc, null);
    }

    public Position(Document doc, Integer pos) {
        int n;
        this.doc = doc;
        if (doc != null) {
            int n2 = doc.positionIdCounter;
            n = n2;
            doc.positionIdCounter = n2 + 1;
        } else {
            n = -1;
        }
        this.id = n;
        this.finalPosition = pos;
    }

    public int getId() {
        return this.id;
    }

    public Document getDocument() {
        return this.doc;
    }

    public static int compare(Position a, Position b) {
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a == null && b == null) {
            return 0;
        }
        return a.compare(b);
    }

    public int compare(Position pos) {
        if (this.finalPosition != null && pos.finalPosition != null) {
            return Integer.compare(this.finalPosition, pos.finalPosition);
        }
        return 0;
    }

    public String toString() {
        return this.finalPosition != null ? "" + this.finalPosition : "<" + this.id + ">";
    }

    public Integer getDistance(Position pos) {
        if (this.finalPosition != null && pos.finalPosition != null) {
            return pos.finalPosition - this.finalPosition;
        }
        return null;
    }

    public Integer getFinalPosition() {
        return this.finalPosition;
    }

    public void setFinalPosition(int finalPos) {
        this.finalPosition = finalPos;
    }

    public void addActivation(Integer slot, Activation act) {
        this.activations.put(new ActKey(slot, act.getId()), act);
    }

    public Stream<Activation> getActivations(int slot) {
        return this.activations.subMap(new ActKey(slot, Integer.MIN_VALUE), new ActKey(slot, Integer.MAX_VALUE)).values().stream();
    }

    public Collection<Activation> getActivations() {
        return this.activations.values();
    }

    private static class ActKey
    implements Comparable<ActKey> {
        int slot;
        int actId;

        public ActKey(int slot, int actId) {
            this.slot = slot;
            this.actId = actId;
        }

        @Override
        public int compareTo(ActKey ak) {
            int r = Integer.compare(this.slot, ak.slot);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.actId, ak.actId);
        }
    }
}

