/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import network.aika.AbstractNode;
import network.aika.Document;
import network.aika.Model;

public class Provider<T extends AbstractNode>
implements Comparable<Provider<?>> {
    protected Model model;
    protected Integer id;
    private volatile T n;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider(Model model, int id) {
        this.model = model;
        this.id = id;
        if (model != null) {
            WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = model.providers;
            synchronized (weakHashMap) {
                model.providers.put(this.id, new WeakReference<Provider>(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider(Model model, T n) {
        this.model = model;
        this.n = n;
        this.id = model.suspensionHook != null ? model.suspensionHook.getNewId() : model.currentId.addAndGet(1);
        WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = model.providers;
        synchronized (weakHashMap) {
            model.providers.put(this.id, new WeakReference<Provider>(this));
            if (n != null) {
                model.register(this);
            }
        }
    }

    public Integer getId() {
        return this.id;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean isSuspended() {
        return this.n == null;
    }

    public T getIfNotSuspended() {
        return this.n;
    }

    public synchronized T get() {
        if (this.n == null) {
            this.reactivate();
        }
        return this.n;
    }

    public synchronized T get(int lastUsedDocumentId) {
        T n = this.get();
        ((AbstractNode)n).lastUsedDocumentId = Math.max(((AbstractNode)n).lastUsedDocumentId, lastUsedDocumentId);
        return n;
    }

    public T get(Document doc) {
        return doc != null ? this.get(doc.getId()) : this.get();
    }

    public synchronized void suspend(SuspensionMode sm) {
        if (this.n == null) {
            return;
        }
        assert (this.model.suspensionHook != null);
        ((AbstractNode)this.n).suspend();
        this.model.unregister(this);
        if (sm == SuspensionMode.SAVE) {
            this.save();
        }
        this.n = null;
    }

    public void save() {
        if (((AbstractNode)this.n).modified) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipos = new GZIPOutputStream(baos);
                 DataOutputStream dos = new DataOutputStream(gzipos);){
                this.n.write(dos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.model.suspensionHook.store(this.id, ((AbstractNode)this.n).getLabel(), baos.toByteArray());
        }
        ((AbstractNode)this.n).modified = false;
    }

    private void reactivate() {
        assert (this.model.suspensionHook != null);
        byte[] data = this.model.suspensionHook.retrieve(this.id);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try (GZIPInputStream gzipis = new GZIPInputStream(bais);
             DataInputStream dis = new DataInputStream(gzipis);){
            this.n = AbstractNode.read(dis, this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((AbstractNode)this.n).reactivate();
        this.model.register(this);
    }

    public boolean equals(Object o) {
        return this.id == ((Provider)o).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "p(" + this.id + ":" + (this.n != null ? this.n.toString() : "SUSPENDED") + ")";
    }

    @Override
    public int compareTo(Provider<?> n) {
        if (this.id < n.id) {
            return -1;
        }
        if (this.id > n.id) {
            return 1;
        }
        return 0;
    }

    public static enum SuspensionMode {
        SAVE,
        DISCARD;

    }
}

