/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import network.aika.AbstractNode;
import network.aika.Model;
import network.aika.Provider;
import network.aika.lattice.Converter;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.NodeQueue;
import network.aika.neuron.INeuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.UpperBoundQueue;
import network.aika.neuron.activation.ValueQueue;
import network.aika.neuron.activation.link.Linker;
import network.aika.neuron.activation.search.Decision;
import network.aika.neuron.activation.search.SearchNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Document
implements Comparable<Document> {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    public static int CLEANUP_INTERVAL = 500;
    public static int MAX_ROUND = 20;
    private final int id;
    private final StringBuilder content;
    private long visitedCounter = 1L;
    private int activationIdCounter = 0;
    private int nodeActivationIdCounter = 0;
    public int searchNodeIdCounter = 0;
    public int searchStepCounter = 0;
    public int positionIdCounter = 0;
    private Model model;
    Integer threadId;
    long startTime;
    private NodeQueue nodeQueue = new NodeQueue(this);
    private ValueQueue valueQueue = new ValueQueue();
    private UpperBoundQueue ubQueue = new UpperBoundQueue();
    private Linker linker;
    private TreeMap<Integer, Position> positions = new TreeMap();
    private TreeSet<Node> activatedNodes = new TreeSet();
    private TreeSet<INeuron> activatedNeurons = new TreeSet();
    private TreeSet<INeuron> finallyActivatedNeurons = new TreeSet();
    private TreeSet<Activation> inputNeuronActivations = new TreeSet();
    private TreeMap<INeuron, Set<Synapse>> modifiedWeights = new TreeMap();
    private TreeMap<ActKey, Activation> activationsBySlotAndPosition = new TreeMap((ak1, ak2) -> {
        int r = Integer.compare(ak1.slot, ak2.slot);
        if (r != 0) {
            return r;
        }
        r = Position.compare(ak1.pos, ak2.pos);
        if (r != 0) {
            return r;
        }
        r = ak1.neuron.compareTo(ak2.neuron);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    });
    private TreeMap<ActKey, Activation> activationsByPosition = new TreeMap((ak1, ak2) -> {
        int r = Position.compare(ak1.pos, ak2.pos);
        if (r != 0) {
            return r;
        }
        r = ak1.neuron.compareTo(ak2.neuron);
        if (r != 0) {
            return r;
        }
        return Integer.compare(ak1.actId, ak2.actId);
    });
    private TreeMap<Integer, Activation> activationsById = new TreeMap();
    public TreeSet<Node> addedNodes = new TreeSet();
    public ArrayList<NodeActivation> addedNodeActivations = new ArrayList();
    public SearchNode selectedSearchNode;
    public ArrayList<Activation> candidates = new ArrayList();
    public long createV;
    public static Comparator<Activation> ACTIVATIONS_OUTPUT_COMPARATOR = (act1, act2) -> {
        int r = Position.compare(act1.lookupSlot(Activation.BEGIN), act2.lookupSlot(Activation.BEGIN));
        if (r != 0) {
            return r;
        }
        r = act1.getINeuron().compareTo(act2.getINeuron());
        if (r != 0) {
            return r;
        }
        return Integer.compare(act1.getId(), act2.getId());
    };

    public Document(Model model, String content) {
        this(model, model.getNewDocumentId(), content);
    }

    public Document(Model model, int id, String content) {
        this.id = id;
        this.content = new StringBuilder(content);
        this.model = model;
        this.linker = this.initLinker();
        this.startTime = System.currentTimeMillis();
        model.acquireThread(this);
    }

    protected Linker initLinker() {
        return new Linker(this);
    }

    public int getId() {
        return this.id;
    }

    public Model getModel() {
        return this.model;
    }

    public Linker getLinker() {
        return this.linker;
    }

    public ValueQueue getValueQueue() {
        return this.valueQueue;
    }

    public long getNewVisitedId() {
        return this.visitedCounter++;
    }

    public int getNewActivationId() {
        return this.activationIdCounter++;
    }

    public int getNewNodeActivationId() {
        return this.nodeActivationIdCounter++;
    }

    public void addActivatedNode(Node n) {
        this.activatedNodes.add(n);
    }

    public void addInputNeuronActivation(Activation act) {
        this.inputNeuronActivations.add(act);
    }

    public void addFinallyActivatedNeuron(INeuron n) {
        this.finallyActivatedNeurons.add(n);
    }

    public void addActivatedNeuron(INeuron n) {
        this.activatedNeurons.add(n);
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void append(String txt) {
        this.content.append(txt);
    }

    public char charAt(int i) {
        return this.content.charAt(i);
    }

    public String getContent() {
        return this.content.toString();
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content.toString();
    }

    public UpperBoundQueue getUpperBoundQueue() {
        return this.ubQueue;
    }

    public NodeQueue getNodeQueue() {
        return this.nodeQueue;
    }

    public Position lookupFinalPosition(int pos) {
        Position p = this.positions.get(pos);
        if (p == null) {
            p = new Position(this, pos);
            this.positions.put(pos, p);
        }
        return p;
    }

    public String getText(Position begin, Position end) {
        if (begin == null || end == null) {
            return "";
        }
        return this.getText(begin.getFinalPosition(), end.getFinalPosition());
    }

    public String getText(Integer begin, Integer end) {
        if (begin != null && end != null) {
            return this.content.substring(Math.max(0, Math.min(begin, this.length())), Math.max(0, Math.min(end, this.length())));
        }
        return "";
    }

    public void addActivation(Activation act) {
        for (Map.Entry<Integer, Position> me : act.getSlots().entrySet()) {
            Position pos = me.getValue();
            if (pos == null || pos.getFinalPosition() == null) continue;
            ActKey dak = new ActKey(me.getKey(), pos, act.getINeuron(), act.getId());
            this.activationsBySlotAndPosition.put(dak, act);
            this.activationsByPosition.put(dak, act);
        }
        this.activationsById.put(act.getId(), act);
    }

    public Collection<Activation> getActivations(boolean onlyFinal) {
        if (!onlyFinal) {
            return this.activationsById.values();
        }
        return this.activationsById.values().stream().filter(act -> act.isFinalActivation()).collect(Collectors.toList());
    }

    public Collection<Activation> getActivationsByPosition(int fromSlot, Position fromPos, boolean fromInclusive, int toSlot, Position toPos, boolean toInclusive) {
        return this.activationsBySlotAndPosition.subMap(new ActKey(fromSlot, fromPos, INeuron.MIN_NEURON, Integer.MIN_VALUE), fromInclusive, new ActKey(toSlot, toPos, INeuron.MAX_NEURON, Integer.MAX_VALUE), toInclusive).values();
    }

    public Collection<Activation> getActivationsByPosition(Position fromPos, boolean fromInclusive, Position toPos, boolean toInclusive) {
        return this.activationsByPosition.subMap(new ActKey(-1, fromPos, INeuron.MIN_NEURON, Integer.MIN_VALUE), fromInclusive, new ActKey(-1, toPos, INeuron.MAX_NEURON, Integer.MAX_VALUE), toInclusive).values();
    }

    public Activation getNextActivation(Activation currentAct) {
        Map.Entry<Integer, Activation> me = currentAct == null ? this.activationsById.firstEntry() : this.activationsById.higherEntry(currentAct.getId());
        return me != null ? me.getValue() : null;
    }

    public int getNumberOfActivations() {
        return this.activationsById.size();
    }

    @Override
    public int compareTo(Document doc) {
        return Integer.compare(this.id, doc.id);
    }

    public void propagate() {
        boolean flag = true;
        while (flag) {
            this.nodeQueue.process();
            flag = this.ubQueue.process();
        }
    }

    public void generateCandidates() throws CyclicDependencyException {
        TreeSet<Activation> tmp = new TreeSet<Activation>(Activation.CANDIDATE_COMP);
        int i = 0;
        for (Activation act : this.activationsById.values()) {
            if (act.getType() != INeuron.Type.EXCITATORY || act.getDecision() != Decision.UNKNOWN || !(act.getUpperBound() > 0.0)) continue;
            act.setCandidateId(i++);
            tmp.add(act);
        }
        long v = this.visitedCounter++;
        for (Activation act : this.inputNeuronActivations) {
            act.markHasCandidate(v);
        }
        while (!tmp.isEmpty()) {
            int oldSize = tmp.size();
            for (Activation act : tmp) {
                if (!act.checkDependenciesSatisfied(v)) continue;
                tmp.remove(act);
                act.setCandidateId(this.candidates.size());
                this.candidates.add(act);
                act.markHasCandidate(v);
                break;
            }
            if (tmp.size() != oldSize) continue;
            log.info(this.activationsToString());
            throw new CyclicDependencyException();
        }
    }

    public void process() throws SearchNode.TimeoutException, CyclicDependencyException, Activation.OscillatingActivationsException {
        this.process(null);
    }

    public void process(Long timeoutInMilliSeconds) throws SearchNode.TimeoutException, CyclicDependencyException, Activation.OscillatingActivationsException {
        this.linker.lateLinking();
        this.inputNeuronActivations.forEach(act -> this.valueQueue.propagateActivationValue((Activation)act, null, true, true));
        this.generateCandidates();
        this.selectedSearchNode = new SearchNode(this, null, null, 0);
        this.selectedSearchNode.updateActivations(this);
        this.storeFinalState();
        SearchNode rootNode = this.selectedSearchNode;
        SearchNode.search(this, this.selectedSearchNode, this.visitedCounter++, timeoutInMilliSeconds);
        for (Activation act2 : this.activationsById.values()) {
            if (!act2.isFinalActivation()) continue;
            this.finallyActivatedNeurons.add(act2.getINeuron());
        }
        if (SearchNode.COMPUTE_SOFT_MAX) {
            SearchNode.computeCachedFactor(rootNode);
            this.computeOptionProbabilities();
        }
    }

    public void storeFinalState() {
        for (Activation act : this.activationsById.values()) {
            act.finalOption = act.currentOption;
        }
    }

    private void computeOptionProbabilities() {
        for (Activation act : this.activationsById.values()) {
            act.computeOptionProbabilities();
        }
    }

    public void dumpDebugCandidateStatistics() {
        for (Activation act : this.candidates) {
            log.info(act.searchStateToString());
        }
    }

    public void notifyWeightModified(Synapse synapse) {
        Set<Synapse> is = this.modifiedWeights.get(synapse.getOutput().get());
        if (is == null) {
            is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_COMP);
            this.modifiedWeights.put((INeuron)synapse.getOutput().get(), is);
        }
        is.add(synapse);
    }

    public Map<INeuron, Set<Synapse>> getModifiedWeights() {
        return this.modifiedWeights;
    }

    public void commit() {
        this.modifiedWeights.forEach((n, inputSyns) -> {
            n.commit((Collection<Synapse>)inputSyns);
            Converter.convert(this.threadId, this, n, inputSyns);
        });
        this.modifiedWeights.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActivations() {
        if (this.threadId == null) {
            return;
        }
        this.activatedNeurons.forEach(n -> n.clearActivations(this));
        this.activatedNodes.forEach(n -> n.clearActivations(this));
        this.activationsById.clear();
        this.addedNodeActivations.clear();
        this.activatedNeurons.clear();
        this.activatedNodes.clear();
        this.addedNodes.clear();
        if (this.model.lastCleanup[this.threadId] + CLEANUP_INTERVAL < this.id) {
            ArrayList<Provider<? extends AbstractNode>> tmp;
            this.model.lastCleanup[this.threadId.intValue()] = this.id;
            Map<Integer, Provider<? extends AbstractNode>> map = this.model.activeProviders;
            synchronized (map) {
                tmp = new ArrayList<Provider<? extends AbstractNode>>(this.model.activeProviders.values());
            }
            tmp.forEach(np -> {
                Object an = np.getIfNotSuspended();
                if (an != null && an instanceof Node) {
                    Node n = (Node)an;
                    n.clearThreadState(this.threadId, this.id - CLEANUP_INTERVAL);
                }
            });
        }
        this.model.docs[this.threadId.intValue()] = null;
        this.model.releaseThread(this);
    }

    public String generateOutputText() {
        int oldLength = this.length();
        TreeSet<Position> queue = new TreeSet<Position>(Comparator.comparingInt(p -> p.getId()));
        for (Activation act2 : this.activationsById.values()) {
            if (act2.getINeuron().getOutputText() == null || act2.lookupSlot(Activation.BEGIN).getFinalPosition() == null || act2.lookupSlot(Activation.END).getFinalPosition() != null) continue;
            queue.add(act2.lookupSlot(Activation.BEGIN));
        }
        while (!queue.isEmpty()) {
            Position pos = queue.pollFirst();
            pos.getActivations(Activation.BEGIN).filter(act -> act.getINeuron().getOutputText() != null && act.isFinalActivation()).forEach(act -> {
                String outText = act.getINeuron().getOutputText();
                Position nextPos = act.lookupSlot(Activation.END);
                nextPos.setFinalPosition(pos.getFinalPosition() + outText.length());
                this.content.replace(act.lookupSlot(Activation.BEGIN).getFinalPosition(), act.lookupSlot(Activation.END).getFinalPosition(), outText);
                queue.add(nextPos);
            });
        }
        return this.content.substring(oldLength, this.length());
    }

    public String activationsToString() {
        TreeSet<Activation> acts = new TreeSet<Activation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        acts.addAll(this.activationsById.values());
        StringBuilder sb = new StringBuilder();
        sb.append("Id -");
        sb.append(" Decision -");
        sb.append(" Range | Text Snippet");
        sb.append(" | Identity -");
        sb.append(" Neuron Label -");
        sb.append(" Upper Bound -");
        sb.append(" Value | Net | Weight -");
        sb.append(" Input Value |");
        sb.append(" Target Value");
        sb.append("\n");
        sb.append("\n");
        for (Activation act : acts) {
            if (act.getUpperBound() <= 0.0 && (act.getTargetValue() == null || act.getTargetValue() <= 0.0)) continue;
            sb.append(act.toStringDetailed());
            sb.append("\n");
        }
        if (this.selectedSearchNode != null) {
            sb.append("\n Final SearchNode:" + this.selectedSearchNode.getId() + "  WeightSum:" + this.selectedSearchNode.getAccumulatedWeight() + "\n");
        }
        return sb.toString();
    }

    public static class CyclicDependencyException
    extends RuntimeException {
        public CyclicDependencyException() {
            super("Cycle detected in the activations that is not marked recurrent.");
        }
    }

    private static class ActKey {
        int slot;
        Position pos;
        INeuron neuron;
        int actId;

        public ActKey(int slot, Position pos, INeuron neuron, int actId) {
            this.slot = slot;
            this.pos = pos;
            this.neuron = neuron;
            this.actId = actId;
        }
    }
}

