/*
 * Decompiled with CFR 0.152.
 */
package network.aika;

public class ReadWriteLock {
    private int readers = 0;
    private int writers = 0;
    private int writeRequests = 0;
    private long writerThreadId = -1L;
    private int waitForReadLock = 0;
    private int waitForWriteLock = 0;
    private Object writeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireWriteLock() {
        try {
            ReadWriteLock readWriteLock = this;
            synchronized (readWriteLock) {
                ++this.writeRequests;
                while (this.readers > 0) {
                    this.wait();
                }
            }
            long tid = Thread.currentThread().getId();
            Object object = this.writeLock;
            synchronized (object) {
                if (this.writerThreadId != tid) {
                    ++this.waitForWriteLock;
                    while (this.writers > 0) {
                        this.writeLock.wait();
                    }
                    --this.waitForWriteLock;
                    this.writerThreadId = tid;
                }
                ++this.writers;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void acquireReadLock() {
        try {
            ++this.waitForReadLock;
            while (this.writeRequests > 0) {
                this.wait();
            }
            --this.waitForReadLock;
            ++this.readers;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWriteLock() {
        Object object = this.writeLock;
        synchronized (object) {
            --this.writers;
            if (this.writers == 0) {
                this.writerThreadId = -1L;
                if (this.waitForWriteLock > 0) {
                    this.writeLock.notify();
                }
            }
        }
        object = this;
        synchronized (object) {
            --this.writeRequests;
            if (this.writeRequests == 0 && this.waitForReadLock > 0) {
                this.notifyAll();
            }
        }
    }

    public synchronized void releaseReadLock() {
        --this.readers;
        if (this.writeRequests > 0 && this.readers == 0) {
            this.notifyAll();
        }
    }
}

