/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.activation;

import java.util.ArrayDeque;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.search.Decision;
import network.aika.neuron.activation.search.SearchNode;

public class ValueQueue {
    private final ArrayDeque<Activation> queue = new ArrayDeque();

    public void propagateActivationValue(Activation act, SearchNode sn, boolean lowerBoundChange, boolean upperBoundChange) {
        if (!lowerBoundChange && !upperBoundChange) {
            return;
        }
        act.getOutputLinks().filter(l -> l.getOutput().needsPropagation(sn, lowerBoundChange, upperBoundChange)).forEach(l -> this.add(l.getOutput(), sn));
    }

    public void add(Activation act, SearchNode sn) {
        if (act == null || act.currentOption.isQueued()) {
            return;
        }
        if (act.getNextDecision(act.currentOption, sn) == Decision.UNKNOWN && act.getType() == INeuron.Type.EXCITATORY) {
            return;
        }
        if (act.getType() == INeuron.Type.INHIBITORY) {
            this.queue.addFirst(act);
        } else {
            this.queue.addLast(act);
        }
        act.currentOption.setQueued(true);
    }

    public double process(SearchNode sn) throws Activation.OscillatingActivationsException {
        this.add(sn.getActivation(), sn);
        double delta = 0.0;
        while (!this.queue.isEmpty()) {
            Activation act = this.queue.pollFirst();
            act.currentOption.setQueued(false);
            delta += act.process(sn);
        }
        return delta;
    }
}

