/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import network.aika.Document;
import network.aika.Model;
import network.aika.Provider;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.activation.AndActivation;
import network.aika.lattice.activation.InputActivation;
import network.aika.lattice.refinement.RefValue;
import network.aika.lattice.refinement.Refinement;
import network.aika.lattice.refinement.RelationsMap;
import network.aika.neuron.relation.Relation;

public class AndNode
extends Node<AndNode, AndActivation> {
    public List<Entry> parents;

    public AndNode() {
        this.parents = new ArrayList<Entry>();
    }

    public AndNode(Model m, int level, List<Entry> parents) {
        super(m, level);
        this.parents = parents;
    }

    private void init() {
        for (Entry e : this.parents) {
            e.rv.child = this.provider;
            Node pn = e.rv.parent.get();
            pn.addAndChild(e.ref, e.rv);
            pn.setModified();
        }
    }

    @Override
    public void addModelLabel(String modelLabel) {
        super.addModelLabel(modelLabel);
        this.parents.forEach(e -> e.rv.parent.get().addModelLabel(modelLabel));
    }

    @Override
    protected void propagate(AndActivation act) {
        if (this.andChildren != null) {
            for (AndActivation.Link fl : act.inputs) {
                if (fl == null) continue;
                NodeActivation<?> pAct = fl.input;
                for (AndActivation.Link sl : pAct.outputsToAndNode.values()) {
                    AndActivation secondAct = sl.output;
                    if (act == secondAct) continue;
                    this.applyIntern(act, fl.refAct, fl.ref, fl.rv, secondAct, sl.refAct, sl.ref, sl.rv);
                }
            }
        }
        this.propagateToOrNode(act);
    }

    @Override
    public void delete(Set<String> modelLabels) {
        for (Entry e : this.parents) {
            Provider<? extends Node> pp = e.rv.parent;
            Node pn = pp.get();
            pn.lock.acquireWriteLock();
            pn.removeAndChild(e.ref);
            pn.setModified();
            pn.lock.releaseWriteLock();
            pp.delete(modelLabels);
        }
        for (Entry e : this.parents) {
            e.rv.parent.get().cleanup();
        }
    }

    @Override
    public void cleanup() {
        if (!this.isRemoved && !this.isRequired()) {
            this.remove();
            for (Entry e : this.parents) {
                e.rv.parent.get().cleanup();
            }
        }
    }

    @Override
    void processActivation(AndActivation act) {
        if (act.isComplete()) {
            super.processActivation(act);
        }
    }

    private void applyIntern(AndActivation act, InputActivation refAct, Refinement ref, RefValue rv, NodeActivation secondAct, InputActivation secondRefAct, Refinement secondRef, RefValue secondRv) {
        Document doc = act.getDocument();
        this.lock.acquireReadLock();
        block0: for (Map.Entry me : this.andChildren.subMap(new Refinement(RelationsMap.MIN, secondRef.input), new Refinement(RelationsMap.MAX, secondRef.input)).entrySet()) {
            Refinement nRef = me.getKey();
            RefValue nRv = (RefValue)me.getValue();
            if (!nRef.contains(secondRef, rv)) continue;
            AndNode nlNode = nRv.child.get(doc);
            AndActivation nlAct = this.lookupAndActivation(act, nRef);
            if (nlAct == null) {
                nlAct = new AndActivation(doc, nlNode);
                nlAct.link(nRef, nRv, secondRefAct, act);
            }
            ((AndNode)nlAct.getNode()).addActivation(nlAct);
            for (Entry secondNE : nlNode.parents) {
                if (secondNE.rv.parent.get(doc) != secondAct.getNode() || !secondNE.ref.contains(ref, secondRv)) continue;
                nlAct.link(secondNE.ref, secondNE.rv, refAct, secondAct);
                continue block0;
            }
        }
        this.lock.releaseReadLock();
    }

    private AndActivation lookupAndActivation(NodeActivation<?> input, Refinement ref) {
        for (AndActivation.Link l : input.outputsToAndNode.values()) {
            if (l.ref.compareTo(ref) != 0) continue;
            return l.output;
        }
        return null;
    }

    @Override
    RefValue expand(int threadId, Document doc, Refinement firstRef) {
        if (!firstRef.isConvertible()) {
            return null;
        }
        RefValue firstRV = this.getAndChild(firstRef);
        if (firstRV != null) {
            return firstRV;
        }
        int firstRefOffset = this.level;
        Integer[] firstOffsets = new Integer[this.level];
        for (int i = 0; i < firstOffsets.length; ++i) {
            firstOffsets[i] = i;
        }
        ArrayList<Entry> nextLevelParents = new ArrayList<Entry>();
        for (Entry firstParent : this.parents) {
            Refinement secondParentRef;
            Node parentNode = firstParent.rv.parent.get(doc);
            RefValue secondParentRV = parentNode.expand(threadId, doc, secondParentRef = new Refinement(this.getParentRelations(firstRef, firstParent), firstRef.input));
            if (secondParentRV == null) continue;
            Refinement secondRef = new Refinement(AndNode.getRelations(firstRef, firstParent, secondParentRV), firstParent.ref.input);
            RefValue secondRV = new RefValue(AndNode.getOffsets(firstRefOffset, firstParent, secondParentRV), firstOffsets[firstParent.rv.refOffset], secondParentRV.child);
            nextLevelParents.add(new Entry(secondRef, secondRV));
        }
        firstRV = new RefValue(firstOffsets, firstRefOffset, this.provider);
        nextLevelParents.add(new Entry(firstRef, firstRV));
        return AndNode.createAndNode(this.provider.getModel(), doc, nextLevelParents, this.level + 1) ? firstRV : null;
    }

    private RelationsMap getParentRelations(Refinement firstRef, Entry firstParent) {
        Relation[] secondParentRelations = new Relation[firstRef.relations.length() - 1];
        for (int i = 0; i < firstRef.relations.length(); ++i) {
            Integer j = firstParent.rv.reverseOffsets[i];
            if (j == null) continue;
            secondParentRelations[j.intValue()] = firstRef.relations.get(i);
        }
        return new RelationsMap(secondParentRelations);
    }

    private static RelationsMap getRelations(Refinement firstRef, Entry firstParent, RefValue secondParentRV) {
        Relation[] secondRelations = new Relation[firstParent.ref.relations.length() + 1];
        for (int i = 0; i < firstParent.ref.relations.length(); ++i) {
            int j = secondParentRV.offsets[i];
            secondRelations[j] = firstParent.ref.relations.get(i);
        }
        Relation rel = firstRef.relations.get(firstParent.rv.refOffset);
        if (rel != null) {
            secondRelations[secondParentRV.refOffset] = rel.invert();
        }
        return new RelationsMap(secondRelations);
    }

    private static Integer[] getOffsets(int firstRefOffset, Entry firstParent, RefValue secondParentRV) {
        Integer[] secondOffsets = new Integer[secondParentRV.offsets.length + 1];
        for (int i = 0; i < firstParent.rv.reverseOffsets.length; ++i) {
            Integer j = firstParent.rv.reverseOffsets[i];
            if (j == null) continue;
            secondOffsets[secondParentRV.offsets[j.intValue()].intValue()] = i;
        }
        secondOffsets[secondParentRV.refOffset] = firstRefOffset;
        return secondOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createAndNode(Model m, Document doc, List<Entry> parents, int level) {
        if (parents != null) {
            TreeSet<Provider<? extends Node>> parentsForLocking = new TreeSet<Provider<? extends Node>>();
            for (Entry entry : parents) {
                parentsForLocking.add(entry.rv.parent);
            }
            for (Provider provider : parentsForLocking) {
                ((Node)provider.get()).lock.acquireWriteLock();
            }
            try {
                AndNode nln = new AndNode(m, level, parents);
                nln.init();
                nln.postCreate(doc);
            }
            catch (Throwable throwable) {
                for (Provider provider : parentsForLocking) {
                    ((Node)provider.get()).lock.releaseWriteLock();
                }
                throw throwable;
            }
            for (Provider provider : parentsForLocking) {
                ((Node)provider.get()).lock.releaseWriteLock();
            }
        }
        return true;
    }

    @Override
    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        super.changeNumberOfNeuronRefs(threadId, v, d);
        this.parents.forEach(e -> e.rv.parent.get().changeNumberOfNeuronRefs(threadId, v, d));
    }

    @Override
    public void reprocessInputs(Document doc) {
        for (Entry e : this.parents) {
            Node pn = e.rv.parent.get();
            for (NodeActivation act : pn.getActivations(doc)) {
                act.repropagateV = this.markedCreated;
                ((Node)act.getNode()).propagate((NodeActivation)act);
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (Entry e : this.parents) {
            Node pn = e.rv.parent.get();
            pn.lock.acquireWriteLock();
            pn.removeAndChild(e.ref);
            pn.setModified();
            pn.lock.releaseWriteLock();
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND(" + this.level + ")[");
        boolean first = true;
        for (Entry e : this.parents) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(e.ref);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(65);
        super.write(out);
        out.writeInt(this.parents.size());
        for (Entry e : this.parents) {
            e.ref.write(out);
            e.rv.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            Refinement ref = Refinement.read(in, m);
            RefValue rv = RefValue.read(in, m);
            this.parents.add(new Entry(ref, rv));
        }
    }

    public static class Entry {
        public Refinement ref;
        public RefValue rv;

        public Entry(Refinement ref, RefValue rv) {
            this.ref = ref;
            this.rv = rv;
        }
    }
}

