/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.util.TreeSet;
import network.aika.Document;
import network.aika.lattice.Node;

public class NodeQueue {
    private Document doc;
    private final TreeSet<Node> queue = new TreeSet((n1, n2) -> Node.compareRank(this.doc.getThreadId(), n1, n2));
    private long queueIdCounter = 0L;

    public NodeQueue(Document doc) {
        this.doc = doc;
    }

    public void add(Node n) {
        if (!n.isQueued(this.doc.getThreadId(), this.queueIdCounter++)) {
            this.queue.add(n);
        }
    }

    public void process() {
        while (!this.queue.isEmpty()) {
            Node n = this.queue.pollFirst();
            n.setNotQueued(this.doc.getThreadId());
            n.processChanges(this.doc);
        }
    }
}

