/*
 * Decompiled with CFR 0.152.
 */
package network.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import network.aika.Document;
import network.aika.Model;
import network.aika.Provider;
import network.aika.lattice.Node;
import network.aika.lattice.NodeActivation;
import network.aika.lattice.activation.OrActivation;
import network.aika.lattice.refinement.OrEntry;
import network.aika.lattice.refinement.RefValue;
import network.aika.lattice.refinement.Refinement;
import network.aika.neuron.INeuron;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.activation.link.Direction;
import network.aika.neuron.activation.link.Link;
import network.aika.neuron.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrNode
extends Node<OrNode, OrActivation> {
    private static final Logger log = LoggerFactory.getLogger(OrNode.class);
    TreeSet<OrEntry> andParents = new TreeSet();
    private Neuron outputNeuron = null;

    public OrNode() {
    }

    public OrNode(Model m) {
        super(m, -1);
    }

    @Override
    public RefValue expand(int threadId, Document doc, Refinement ref) {
        throw new UnsupportedOperationException();
    }

    protected void addActivation(OrEntry oe, NodeActivation inputAct) {
        OrActivation orAct;
        OrActivation.Link ol = new OrActivation.Link(oe, inputAct);
        Document doc = inputAct.getDocument();
        INeuron n = (INeuron)this.outputNeuron.get(doc);
        if (n == null) {
            return;
        }
        Activation act = this.lookupActivation(ol, l -> {
            Synapse s = l.getSynapse();
            if (!s.isIdentity()) {
                return true;
            }
            Integer i = oe.revSynapseIds.get(s.getId());
            Activation iAct = doc.getLinker().computeInputActivation(s, inputAct.getInputActivation(i));
            return i != null && l.getInput() == iAct;
        });
        if (act == null) {
            orAct = new OrActivation(doc, this);
            this.register(orAct);
            act = new Activation(doc, n, this.getSlots(oe, inputAct));
            act.setInputNodeActivation(orAct);
            orAct.setOutputAct(act);
        }
        orAct = act.getInputNodeActivation();
        this.propagate(orAct);
        orAct.link(ol);
        ol.linkOutputActivation(act);
    }

    private Activation lookupActivation(OrActivation.Link ol, Predicate<Link> filter) {
        for (Link l : ol.getInputLinks(this.outputNeuron)) {
            Synapse syn = l.getSynapse();
            Map<Integer, Relation> rels = syn.getRelations();
            for (Map.Entry<Integer, Relation> me : rels.entrySet()) {
                Integer relSynId = me.getKey();
                Relation rel = me.getValue();
                Activation existingAct = null;
                if (relSynId != -1) {
                    Synapse s = this.outputNeuron.getSynapseById(relSynId);
                    if (s != null) {
                        existingAct = rel.invert().getActivations((INeuron)s.getInput().get(), l.getInput()).flatMap(act -> act.getLinksBySynapse(Direction.OUTPUT, s)).map(rl -> rl.getOutput()).findFirst().orElse(null);
                    }
                } else {
                    INeuron n = (INeuron)this.outputNeuron.get();
                    if (n == null) {
                        return null;
                    }
                    existingAct = rel.invert().getActivations(n, l.getInput()).findFirst().orElse(null);
                }
                if (existingAct == null || !existingAct.match(filter)) continue;
                return existingAct;
            }
        }
        return null;
    }

    private SortedMap<Integer, Position> getSlots(OrEntry oe, NodeActivation inputAct) {
        TreeMap<Integer, Position> slots = new TreeMap<Integer, Position>();
        for (int i = 0; i < oe.synapseIds.length; ++i) {
            int synapseId = oe.synapseIds[i];
            Synapse s = this.outputNeuron.getSynapseById(synapseId);
            if (s == null) continue;
            for (Map.Entry<Integer, Relation> me : s.getRelations().entrySet()) {
                Relation rel = me.getValue();
                if (me.getKey() != -1) continue;
                Activation iAct = inputAct.getInputActivation(i);
                rel.mapSlots(slots, iAct);
            }
        }
        return slots;
    }

    @Override
    protected void propagate(OrActivation act) {
        act.getDocument().getUpperBoundQueue().add(act.getOutputAct());
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reprocessInputs(Document doc) {
        for (OrEntry oe : this.andParents) {
            Node pn = oe.parent.get();
            for (NodeActivation act : pn.getActivations(doc)) {
                act.repropagateV = this.markedCreated;
                ((Node)act.getNode()).propagate((NodeActivation)act);
            }
        }
    }

    void addInput(int[] synapseIds, int threadId, Node in, boolean andMode) {
        this.provider.getModel();
        in.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), 1);
        OrEntry oe = new OrEntry(synapseIds, (Provider<? extends Node>)in.getProvider(), this.provider);
        in.addOrChild(oe);
        in.setModified();
        if (andMode) {
            this.lock.acquireWriteLock();
            this.setModified();
            this.andParents.add(oe);
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public void delete(Set<String> modelLabels) {
        ((INeuron)this.outputNeuron.get()).remove();
        super.remove();
        try {
            this.lock.acquireReadLock();
            this.removeParents(modelLabels);
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    void removeParents(Set<String> modelLabels) {
        for (OrEntry oe : this.andParents) {
            Provider<? extends Node> pp = oe.parent;
            Node pn = pp.get();
            int n = this.provider.getModel().defaultThreadId;
            this.provider.getModel();
            pn.changeNumberOfNeuronRefs(n, Model.visitedCounter.addAndGet(1L), -1);
            pn.removeOrChild(oe);
            pn.setModified();
        }
        this.andParents.clear();
    }

    void removeParents(int threadId) {
        for (OrEntry oe : this.andParents) {
            Node pn = oe.parent.get();
            this.provider.getModel();
            pn.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), -1);
            pn.removeOrChild(oe);
            pn.setModified();
        }
        this.andParents.clear();
    }

    @Override
    protected void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        for (OrEntry oe : this.andParents) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(oe.parent.get().logicToString());
            if (i > 2) {
                sb.append(",...");
                break;
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(79);
        super.write(out);
        out.writeInt(this.outputNeuron.getId());
        out.writeInt(this.andParents.size());
        for (OrEntry oe : this.andParents) {
            oe.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.outputNeuron = m.lookupNeuron(in.readInt());
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            this.andParents.add(OrEntry.read(in, m));
        }
    }

    @Override
    public String getNeuronLabel() {
        String l = this.outputNeuron.getLabel();
        return l != null ? l : "";
    }

    public void setOutputNeuron(Neuron n) {
        this.outputNeuron = n;
    }

    public Neuron getOutputNeuron() {
        return this.outputNeuron;
    }
}

