/*
 * Decompiled with CFR 0.152.
 */
package network.aika.neuron.relation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import network.aika.Model;
import network.aika.neuron.INeuron;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Position;
import network.aika.neuron.relation.Relation;

public class MultiRelation
extends Relation {
    public static final int ID = 1;
    private SortedMap<Relation, Relation> relations;

    public MultiRelation() {
        this.relations = new TreeMap<Relation, Relation>();
    }

    public MultiRelation(Relation ... rels) {
        this.relations = new TreeMap<Relation, Relation>();
        for (Relation r : rels) {
            this.relations.put(r, r);
        }
    }

    public MultiRelation(SortedMap<Relation, Relation> rels) {
        this.relations = rels;
    }

    @Override
    public Collection<Relation> getLeafRelations() {
        return this.relations.values();
    }

    public int size() {
        return this.relations.size();
    }

    @Override
    public Relation getRelation(Relation r) {
        return (Relation)this.relations.get(r);
    }

    public void addRelation(Relation r) {
        if (r instanceof MultiRelation) {
            MultiRelation mr = (MultiRelation)r;
            for (Relation rel : mr.relations.values()) {
                this.relations.put(rel, rel);
            }
        } else {
            this.relations.put(r, r);
        }
    }

    public void removeRelation(Relation r) {
        this.relations.remove(r);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean test(Activation act, Activation linkedAct, boolean allowUndefined) {
        for (Relation rel : this.relations.values()) {
            if (rel.test(act, linkedAct, allowUndefined)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Relation invert() {
        TreeMap<Relation, Relation> invRels = new TreeMap<Relation, Relation>();
        for (Relation rel : this.relations.values()) {
            Relation ir = rel.invert();
            invRels.put(ir, ir);
        }
        return new MultiRelation(invRels);
    }

    @Override
    public void mapSlots(Map<Integer, Position> slots, Activation act) {
        for (Relation rel : this.relations.values()) {
            rel.mapSlots(slots, act);
        }
    }

    @Override
    public boolean isExact() {
        for (Relation rel : this.relations.values()) {
            if (!rel.isExact()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stream<Activation> getActivations(INeuron n, Activation linkedAct) {
        if (this.relations.isEmpty()) {
            return n.getActivations(linkedAct.getDocument());
        }
        return this.relations.firstKey().getActivations(n, linkedAct).filter(act -> {
            for (Relation rel : this.relations.values()) {
                if (rel.test((Activation)act, linkedAct, false)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public int compareTo(Relation rel) {
        int r = super.compareTo(rel);
        if (r != 0) {
            return r;
        }
        MultiRelation mr = (MultiRelation)rel;
        r = Integer.compare(this.relations.size(), mr.relations.size());
        if (r != 0) {
            return r;
        }
        Iterator<Relation> ita = this.relations.values().iterator();
        Iterator<Relation> itb = mr.relations.values().iterator();
        while (ita.hasNext() || itb.hasNext()) {
            Relation b;
            Relation a = ita.next();
            r = a.compareTo(b = itb.next());
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.relations.size());
        for (Relation rel : this.relations.values()) {
            rel.write(out);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        int l = in.readInt();
        for (int i = 0; i < l; ++i) {
            Relation r = Relation.read(in, m);
            this.relations.put(r, r);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MULTI(");
        boolean first = true;
        for (Relation rel : this.relations.values()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(rel.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        MultiRelation.registerRelation(1, () -> new MultiRelation());
    }
}

