/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Proxy;
import org.aincraft.config.FileBackedConfiguration;
import org.aincraft.config.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

final class YamlFileBackedConfigurationImpl
implements FileBackedConfiguration {
    private final Plugin plugin;
    private final String path;
    private org.bukkit.configuration.file.YamlConfiguration config;
    private File configFile;

    YamlFileBackedConfigurationImpl(Plugin plugin, String path) {
        this.plugin = plugin;
        this.path = path;
        this.configFile = new File(plugin.getDataFolder(), path);
        if (!this.configFile.exists()) {
            plugin.saveResource(path, false);
        }
        assert (this.configFile != null);
        this.config = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    static YamlConfiguration create(Plugin plugin, String path) {
        String[] split = path.split("\\.");
        Preconditions.checkArgument((split.length >= 2 ? 1 : 0) != 0);
        Preconditions.checkArgument((split[1].equals("yml") || split[1].equals("yaml") ? 1 : 0) != 0);
        YamlFileBackedConfigurationImpl impl = new YamlFileBackedConfigurationImpl(plugin, path);
        org.bukkit.configuration.file.YamlConfiguration config = impl.config;
        return (YamlConfiguration)Proxy.newProxyInstance(YamlConfiguration.class.getClassLoader(), new Class[]{YamlConfiguration.class}, (proxy, method, args) -> {
            if ("getPlugin".equals(method.getName())) {
                return impl.getPlugin();
            }
            if ("reload".equals(method.getName())) {
                impl.reload();
                return null;
            }
            if ("save".equals(method.getName())) {
                impl.save();
                return null;
            }
            return method.invoke((Object)config, args);
        });
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void reload() {
        try {
            this.configFile = new File(this.plugin.getDataFolder(), this.path);
            this.config = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.configFile);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

