/*
 * Decompiled with CFR 0.152.
 */
package org.aincraft.events;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PacketBlockInteractEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    @NotNull
    private final Player player;
    @NotNull
    private final Block block;
    @NotNull
    private final Action action;
    @Nullable
    private final EquipmentSlot hand;
    @Nullable
    private final BlockFace face;
    @Nullable
    private final ItemStack item;
    @NotNull
    private final String resourceKey;
    private boolean cancelled;

    @ApiStatus.Internal
    public PacketBlockInteractEvent(@NotNull Player player, @NotNull Block block, @NotNull Action action, @Nullable EquipmentSlot hand, @Nullable BlockFace face, @Nullable ItemStack item, @NotNull String resourceKey) {
        this.player = player;
        this.block = block;
        this.action = action;
        this.hand = hand;
        this.face = face;
        this.item = item;
        this.resourceKey = resourceKey;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Block getBlock() {
        return this.block;
    }

    @NotNull
    public Action getAction() {
        return this.action;
    }

    @Nullable
    public EquipmentSlot getHand() {
        return this.hand;
    }

    @Nullable
    public BlockFace getFace() {
        return this.face;
    }

    @Nullable
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public String getResourceKey() {
        return this.resourceKey;
    }

    public boolean isLeftClick() {
        return this.action == Action.LEFT_CLICK_BLOCK;
    }

    public boolean isRightClick() {
        return this.action == Action.RIGHT_CLICK_BLOCK;
    }

    public boolean isPhysical() {
        return this.action == Action.PHYSICAL;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

